/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import java.io.File;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishCheck;
import org.kitteh.vanish.VanishCommand;
import org.kitteh.vanish.VanishManager;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.hooks.HookManager;
import org.kitteh.vanish.listeners.Listen119;
import org.kitteh.vanish.listeners.ListenEntity;
import org.kitteh.vanish.listeners.ListenInventory;
import org.kitteh.vanish.listeners.ListenPaperEvents;
import org.kitteh.vanish.listeners.ListenPlayerJoin;
import org.kitteh.vanish.listeners.ListenPlayerMessages;
import org.kitteh.vanish.listeners.ListenPlayerOther;
import org.kitteh.vanish.listeners.ListenServerPing;
import org.kitteh.vanish.listeners.ListenToYourHeart;
import org.kitteh.vanish.utils.MinecraftVersion;

public final class VanishPlugin
extends JavaPlugin {
    private final HashSet<String> haveInventoriesOpen = new HashSet();
    private VanishManager manager;
    private final HookManager hookManager = new HookManager(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chestFakeClose(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            this.haveInventoriesOpen.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chestFakeInUse(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            return this.haveInventoriesOpen.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chestFakeOpen(String name) {
        HashSet<String> hashSet = this.haveInventoriesOpen;
        synchronized (hashSet) {
            this.haveInventoriesOpen.add(name);
        }
    }

    public String getCurrentVersion() {
        return this.getDescription().getVersion();
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public VanishManager getManager() {
        return this.manager;
    }

    public void hooksJoin(Player player) {
        this.hookManager.onJoin(player);
    }

    public void hooksQuit(Player player) {
        this.hookManager.onQuit(player);
        this.hookManager.onUnvanish(player);
    }

    public void hooksUnvanish(Player player) {
        this.hookManager.onUnvanish(player);
    }

    public void hooksVanish(Player player) {
        this.hookManager.onVanish(player);
    }

    public void messageStatusUpdate(String message) {
        this.messageStatusUpdate(message, null);
    }

    public void messageStatusUpdate(String message, Player avoid) {
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player == null || player.equals((Object)avoid) || !VanishPerms.canSeeStatusUpdates(player)) continue;
            player.sendMessage(message);
        }
    }

    public void onDisable() {
        Debuggle.nah();
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player == null || !this.manager.isVanished(player)) continue;
            player.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "[Vanish] You have been forced visible by a reload.");
        }
        this.hookManager.onDisable();
        this.manager.onPluginDisable();
        this.getLogger().info(this.getCurrentVersion() + " unloaded.");
    }

    public void onEnable() {
        File check = new File(this.getDataFolder(), "config.yml");
        if (!check.exists()) {
            this.saveDefaultConfig();
            this.reloadConfig();
            if (this.getServer().getPluginManager().isPluginEnabled("Essentials")) {
                this.getConfig().set("hooks.essentials", (Object)true);
                this.getLogger().info("Detected Essentials. Enabling Essentials hook.");
                this.saveConfig();
            }
        }
        Settings.freshStart(this);
        if (this.getConfig().getBoolean("hooks.essentials", false)) {
            this.hookManager.getHook(HookManager.HookType.Essentials).onEnable();
        }
        if (this.getConfig().getBoolean("hooks.dynmap", false)) {
            this.hookManager.getHook(HookManager.HookType.Dynmap).onEnable();
        }
        this.manager = new VanishManager(this);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.setMetadata("vanished", (MetadataValue)new LazyMetadataValue((Plugin)this, LazyMetadataValue.CacheStrategy.NEVER_CACHE, (Callable)new VanishCheck(this.manager, player.getName())));
        }
        this.getCommand("vanish").setExecutor((CommandExecutor)new VanishCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ListenEntity(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerMessages(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerJoin(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenPlayerOther(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenToYourHeart(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenInventory(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ListenServerPing(this.manager), (Plugin)this);
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            this.getServer().getPluginManager().registerEvents((Listener)new ListenPaperEvents(this), (Plugin)this);
        }
        catch (ClassNotFoundException ignored) {
            this.getLogger().warning("Not using Paper API, because it is not available.");
        }
        if (MinecraftVersion.isAboveOrEqual(1, 19, 0)) {
            this.getServer().getPluginManager().registerEvents((Listener)new Listen119(this), (Plugin)this);
        }
        this.getLogger().info(this.getCurrentVersion() + " loaded.");
    }

    public void reload() {
        this.reloadConfig();
        Settings.freshStart(this);
    }
}

