/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitRunnable;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishAnnounceManipulator;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.event.VanishStatusChangeEvent;

public final class VanishManager {
    public static final String VANISH_PLUGIN_CHANNEL = "vanishnopacket:status";
    private final VanishPlugin plugin;
    private final Set<String> vanishedPlayerNames = Collections.synchronizedSet(new HashSet());
    private final Map<String, Boolean> sleepIgnored = new HashMap<String, Boolean>();
    private final Set<UUID> bats = new HashSet<UUID>();
    private final VanishAnnounceManipulator announceManipulator;
    private final Random random = new Random();
    private final ShowPlayerHandler showPlayer = new ShowPlayerHandler();

    public VanishManager(final VanishPlugin plugin) {
        this.plugin = plugin;
        this.announceManipulator = new VanishAnnounceManipulator(this.plugin);
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this.showPlayer, 4L, 4L);
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, VANISH_PLUGIN_CHANNEL, new PluginMessageListener(){

            public void onPluginMessageReceived(String channel, Player player, byte[] message) {
                if (channel.equals(VanishManager.VANISH_PLUGIN_CHANNEL) && new String(message).equals("check")) {
                    byte[] byArray;
                    if (VanishManager.this.isVanished(player)) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 1;
                    } else {
                        byte[] byArray3 = new byte[1];
                        byArray = byArray3;
                        byArray3[0] = 0;
                    }
                    player.sendPluginMessage((Plugin)plugin, VanishManager.VANISH_PLUGIN_CHANNEL, byArray);
                }
            }
        });
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, VANISH_PLUGIN_CHANNEL);
    }

    public VanishAnnounceManipulator getAnnounceManipulator() {
        return this.announceManipulator;
    }

    public Set<UUID> getBats() {
        return this.bats;
    }

    public Set<String> getVanishedPlayers() {
        return ImmutableSet.copyOf(this.vanishedPlayerNames);
    }

    public boolean isVanished(Player player) {
        return this.vanishedPlayerNames.contains(player.getName());
    }

    public boolean isVanished(String playerName) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        if (player != null) {
            Debuggle.log("Testing vanished status of " + player.getName() + ": " + this.isVanished(player));
            return this.isVanished(player);
        }
        Debuggle.log("Testing vanished status of " + playerName + ": null");
        return false;
    }

    public int numVanished() {
        return this.vanishedPlayerNames.size();
    }

    public void playerQuit(Player player) {
        Debuggle.log("Quitting: " + player.getName());
        this.resetSleepingIgnored(player);
        VanishPerms.userQuit(player);
        this.removeVanished(player.getName());
    }

    public void playerRefresh(Player player) {
        this.resetSeeing(player);
        if (this.isVanished(player) && !VanishPerms.canVanish(player)) {
            this.toggleVanish(player);
        }
    }

    public void resetSeeing(Player player) {
        Debuggle.log("Resetting visibility on " + player.getName());
        if (VanishPerms.canSeeAll(player)) {
            this.showVanished(player);
            Debuggle.log("Showing all to " + player.getName());
        } else {
            this.hideVanished(player);
            Debuggle.log("Hiding all to " + player.getName());
        }
    }

    public void toggleVanish(Player togglingPlayer) {
        String messageBit;
        this.toggleVanishQuiet(togglingPlayer);
        String vanishingPlayerName = togglingPlayer.getName();
        String base = String.valueOf(ChatColor.YELLOW) + vanishingPlayerName + " has ";
        if (this.isVanished(togglingPlayer)) {
            Debuggle.log("LoudVanishToggle Vanishing " + togglingPlayer.getName());
            this.plugin.hooksVanish(togglingPlayer);
            messageBit = "vanished. Poof.";
        } else {
            Debuggle.log("LoudVanishToggle Revealing " + togglingPlayer.getName());
            this.plugin.hooksUnvanish(togglingPlayer);
            messageBit = "become visible.";
            this.announceManipulator.vanishToggled(togglingPlayer);
        }
        String message = base + messageBit;
        togglingPlayer.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "You have " + messageBit);
        this.plugin.messageStatusUpdate(message, togglingPlayer);
    }

    public void toggleVanishQuiet(Player vanishingPlayer) {
        this.toggleVanishQuiet(vanishingPlayer, true);
    }

    public void toggleVanishQuiet(Player vanishingPlayer, boolean effects) {
        byte[] byArray;
        boolean vanishing = !this.isVanished(vanishingPlayer);
        String vanishingPlayerName = vanishingPlayer.getName();
        if (vanishing) {
            Debuggle.log("It's invisible time! " + vanishingPlayer.getName());
            this.setSleepingIgnored(vanishingPlayer);
            if (VanishPerms.canNotFollow(vanishingPlayer)) {
                for (Entity entity : vanishingPlayer.getNearbyEntities(100.0, 100.0, 100.0)) {
                    Creature creature;
                    if (entity == null || !(entity instanceof Creature) || (creature = (Creature)entity).getTarget() == null || !creature.getTarget().equals((Object)vanishingPlayer)) continue;
                    creature.setTarget(null);
                }
            }
            this.vanishedPlayerNames.add(vanishingPlayerName);
            this.plugin.getLogger().info(vanishingPlayerName + " disappeared.");
        } else {
            Debuggle.log("It's visible time! " + vanishingPlayer.getName());
            this.resetSleepingIgnored(vanishingPlayer);
            this.removeVanished(vanishingPlayerName);
            this.plugin.getLogger().info(vanishingPlayerName + " reappeared.");
        }
        if (effects) {
            Location oneUp = vanishingPlayer.getLocation().add(0.0, 1.0, 0.0);
            if (VanishPerms.canEffectSmoke(vanishingPlayer)) {
                this.effectSmoke(vanishingPlayer.getLocation());
            }
            if (VanishPerms.canEffectExplode(vanishingPlayer)) {
                this.effectExplosion(vanishingPlayer);
            }
            if (VanishPerms.canEffectLightning(vanishingPlayer)) {
                this.effectLightning(vanishingPlayer.getLocation());
            }
            if (VanishPerms.canEffectFlames(vanishingPlayer)) {
                this.effectFlames(oneUp);
            }
            if (VanishPerms.canEffectBats(vanishingPlayer)) {
                this.effectBats(oneUp);
            }
            if (Settings.getSoundOnVanish()) {
                vanishingPlayer.playSound(vanishingPlayer.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 5.0f, 5.0f);
            }
        }
        if (Settings.getVanishedActionBarMessage() != null && !Settings.getVanishedActionBarMessage().isEmpty()) {
            this.showVanishedActionBar(vanishingPlayer);
        }
        this.plugin.getServer().getPluginManager().callEvent((Event)new VanishStatusChangeEvent(vanishingPlayer, vanishing));
        if (vanishing) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        vanishingPlayer.sendPluginMessage((Plugin)this.plugin, VANISH_PLUGIN_CHANNEL, byArray);
        Collection playerList = this.plugin.getServer().getOnlinePlayers();
        for (Player otherPlayer : playerList) {
            if (vanishingPlayer.equals((Object)otherPlayer)) continue;
            Debuggle.log("Determining what to do about " + vanishingPlayer.getName() + " for " + otherPlayer.getName());
            if (vanishing) {
                if (!VanishPerms.canSeeAll(otherPlayer)) {
                    if (!otherPlayer.canSee(vanishingPlayer)) continue;
                    Debuggle.log("Hiding " + vanishingPlayer.getName() + " from " + otherPlayer.getName());
                    otherPlayer.hidePlayer((Plugin)this.plugin, vanishingPlayer);
                    continue;
                }
                otherPlayer.hidePlayer((Plugin)this.plugin, vanishingPlayer);
                this.showPlayer.add(new ShowPlayerEntry(this, otherPlayer, vanishingPlayer));
                continue;
            }
            if (VanishPerms.canSeeAll(otherPlayer)) {
                otherPlayer.hidePlayer((Plugin)this.plugin, vanishingPlayer);
            }
            if (otherPlayer.canSee(vanishingPlayer)) continue;
            Debuggle.log("Showing " + vanishingPlayer.getName() + " to " + otherPlayer.getName());
            this.showPlayer.add(new ShowPlayerEntry(this, otherPlayer, vanishingPlayer));
        }
    }

    private void showVanishedActionBar(final Player vanishingPlayer) {
        if (Bukkit.getPlayer((UUID)vanishingPlayer.getUniqueId()) != null && this.isVanished(vanishingPlayer)) {
            vanishingPlayer.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Settings.getVanishedActionBarMessage()));
            new BukkitRunnable(){

                public void run() {
                    VanishManager.this.showVanishedActionBar(vanishingPlayer);
                }
            }.runTaskLater((Plugin)this.plugin, 20L);
        } else {
            vanishingPlayer.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(""));
        }
    }

    public void vanish(Player vanishingPlayer, boolean silent, boolean effects) {
        if (this.isVanished(vanishingPlayer)) {
            return;
        }
        if (silent) {
            this.toggleVanishQuiet(vanishingPlayer, effects);
        } else {
            this.toggleVanish(vanishingPlayer);
        }
    }

    public void reveal(Player revealingPlayer, boolean silent, boolean effects) {
        if (!this.isVanished(revealingPlayer)) {
            return;
        }
        if (silent) {
            this.toggleVanishQuiet(revealingPlayer, effects);
        } else {
            this.toggleVanish(revealingPlayer);
        }
    }

    private void effectBats(final Location location) {
        final HashSet<UUID> batty = new HashSet<UUID>();
        for (int x = 0; x < 10; ++x) {
            batty.add(location.getWorld().spawnEntity(location, EntityType.BAT).getUniqueId());
        }
        this.bats.addAll(batty);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                VanishManager.this.effectBatsCleanup(location.getWorld(), batty);
                VanishManager.this.bats.removeAll(batty);
            }
        }, 60L);
    }

    private void effectBatsCleanup(World world, Set<UUID> bats) {
        for (Entity entity : world.getEntities()) {
            if (!bats.contains(entity.getUniqueId())) continue;
            world.playEffect(entity.getLocation(), Effect.SMOKE, this.random.nextInt(9));
            entity.remove();
        }
    }

    private void effectExplosion(Player player) {
        Location loc = player.getLocation();
        player.getWorld().createExplosion(loc.getX(), loc.getY(), loc.getZ(), 0.0f, false, false);
    }

    private void effectFlames(Location location) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, this.random.nextInt(9));
        }
    }

    private void effectLightning(Location location) {
        int x = location.getBlockX();
        double y = location.getBlockY();
        int z = location.getBlockZ();
        for (int i = 0; i < Settings.getLightningCount(); ++i) {
            double xToStrike = this.random.nextBoolean() ? (double)(x + this.random.nextInt(6)) : (double)(x - this.random.nextInt(6));
            double zToStrike = this.random.nextBoolean() ? (double)(z + this.random.nextInt(6)) : (double)(z - this.random.nextInt(6));
            Location toStrike = new Location(location.getWorld(), xToStrike, y, zToStrike);
            location.getWorld().strikeLightningEffect(toStrike);
        }
    }

    private void effectSmoke(Location location) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().playEffect(location, Effect.SMOKE, this.random.nextInt(9));
        }
    }

    private void hideVanished(Player player) {
        for (Player otherPlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (player.equals((Object)otherPlayer) || !this.isVanished(otherPlayer) || !player.canSee(otherPlayer)) continue;
            player.hidePlayer((Plugin)this.plugin, otherPlayer);
        }
    }

    private void removeVanished(String name) {
        this.vanishedPlayerNames.remove(name);
    }

    private void showVanished(Player player) {
        for (Player otherPlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (!this.isVanished(otherPlayer) || player.canSee(otherPlayer)) continue;
            this.showPlayer.add(new ShowPlayerEntry(this, player, otherPlayer));
        }
    }

    void onPluginDisable() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            for (Player player2 : this.plugin.getServer().getOnlinePlayers()) {
                if (player == null || player2 == null || player.equals((Object)player2)) continue;
                player.showPlayer((Plugin)this.plugin, player2);
            }
        }
        for (World world : this.plugin.getServer().getWorlds()) {
            this.effectBatsCleanup(world, this.bats);
        }
    }

    void resetSleepingIgnored(Player player) {
        if (this.sleepIgnored.containsKey(player.getName())) {
            player.setSleepingIgnored(this.sleepIgnored.remove(player.getName()).booleanValue());
        }
    }

    void setSleepingIgnored(Player player) {
        if (!this.sleepIgnored.containsKey(player.getName())) {
            this.sleepIgnored.put(player.getName(), player.isSleepingIgnored());
        }
        player.setSleepingIgnored(true);
    }

    private final class ShowPlayerHandler
    implements Runnable {
        Set<ShowPlayerEntry> entries = new HashSet<ShowPlayerEntry>();
        Set<ShowPlayerEntry> next = new HashSet<ShowPlayerEntry>();

        private ShowPlayerHandler() {
        }

        public void add(ShowPlayerEntry player) {
            this.entries.add(player);
        }

        @Override
        public void run() {
            for (ShowPlayerEntry entry : this.next) {
                Player player = entry.getPlayer();
                Player target = entry.getTarget();
                if (player == null || !player.isOnline() || target == null || !target.isOnline()) continue;
                player.showPlayer((Plugin)VanishManager.this.plugin, target);
            }
            this.next.clear();
            this.next.addAll(this.entries);
            this.entries.clear();
        }
    }

    private final class ShowPlayerEntry {
        private final Player player;
        private final Player target;

        public ShowPlayerEntry(VanishManager vanishManager, Player player, Player target) {
            this.player = player;
            this.target = target;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Player getTarget() {
            return this.target;
        }
    }
}

