/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.MojangsonParseException;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagTuple;
import org.cyberiantiger.minecraft.nbt.TagType;

public class MojangsonParser {
    private final PushbackReader in;
    StringBuilder element = new StringBuilder();
    StringBuilder unicodeEscape = new StringBuilder();

    public MojangsonParser(Reader in) {
        this.in = in instanceof PushbackReader ? (PushbackReader)in : new PushbackReader(in);
    }

    public TagTuple parse() throws IOException {
        return this.parseRoot();
    }

    private TagTuple parseRoot() throws IOException {
        int i;
        RootState state = RootState.KEY_OR_COMPOUND;
        String name = null;
        CompoundTag value = null;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block0 : switch (state) {
                case KEY_OR_COMPOUND: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case '\"': {
                            this.parseQuotedString();
                            name = this.element.toString();
                            this.element.setLength(0);
                            state = RootState.PAIR_IDENTIFIER;
                            break block0;
                        }
                        case '{': {
                            name = "";
                            value = this.parseCompound();
                            state = RootState.EOF;
                            break block0;
                        }
                    }
                    if ('a' <= ch && 'z' >= ch || 'A' <= ch && 'Z' >= ch) {
                        this.element.append(ch);
                        this.parseString();
                        name = this.element.toString();
                        this.element.setLength(0);
                        state = RootState.PAIR_IDENTIFIER;
                        break;
                    }
                    throw new MojangsonParseException("Expected [a-zA-Z{] but got: " + ch);
                }
                case PAIR_IDENTIFIER: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case ':': {
                            state = RootState.COMPOUND;
                            break block0;
                        }
                    }
                    throw new MojangsonParseException("Expected [:] but got: " + ch);
                }
                case COMPOUND: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case '{': {
                            value = this.parseCompound();
                            state = RootState.EOF;
                            break block0;
                        }
                    }
                    throw new MojangsonParseException("Expected { but got " + ch);
                }
                case EOF: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                    }
                    throw new MojangsonParseException("Expected EOF but got " + ch);
                }
            }
        }
        if (state != RootState.EOF) {
            throw new MojangsonParseException("Unexpected EOF");
        }
        return new TagTuple<Object>(name, value);
    }

    private void parseQuotedString() throws IOException {
        int i;
        QuotedStringState state = QuotedStringState.LITERAL;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block0 : switch (state) {
                case LITERAL: {
                    switch (ch) {
                        case '\"': {
                            return;
                        }
                        case '\\': {
                            state = QuotedStringState.ESCAPED;
                            break block0;
                        }
                    }
                    this.element.append(ch);
                    break;
                }
                case ESCAPED: {
                    switch (ch) {
                        case '\"': {
                            this.element.append('\"');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case '\\': {
                            this.element.append('\\');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case '/': {
                            this.element.append('/');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case 'b': {
                            this.element.append('\b');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case 'f': {
                            this.element.append('\f');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case 'n': {
                            this.element.append('\n');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case 'r': {
                            this.element.append('\r');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case 't': {
                            this.element.append('\t');
                            state = QuotedStringState.LITERAL;
                            break block0;
                        }
                        case 'u': {
                            state = QuotedStringState.UNICODE;
                        }
                    }
                    break;
                }
                case UNICODE: {
                    if ('0' <= ch && '9' >= ch || 'a' <= ch && 'f' >= ch || 'A' <= ch && 'F' >= ch) {
                        this.unicodeEscape.append(ch);
                        if (this.unicodeEscape.length() < 4) break;
                        this.element.append((char)Integer.parseInt(this.unicodeEscape.toString(), 16));
                        this.unicodeEscape.setLength(0);
                        state = QuotedStringState.LITERAL;
                        break;
                    }
                    throw new MojangsonParseException("Unicode escape in string, expected [0-9a-fA-F] got: " + ch);
                }
            }
        }
        throw new MojangsonParseException("Unexpected EOF in quoted string");
    }

    private void parseString() throws IOException {
        int i;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            if ('a' <= ch && 'z' >= ch || 'A' <= ch && 'Z' >= ch) {
                this.element.append(ch);
                continue;
            }
            this.in.unread(ch);
            return;
        }
    }

    private CompoundTag parseCompound() throws IOException {
        int i;
        CompoundTag result = new CompoundTag();
        String name = null;
        CompoundState state = CompoundState.KEY_OR_END;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block0 : switch (state) {
                case KEY_OR_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case '}': {
                            return result;
                        }
                        case '\"': {
                            this.parseQuotedString();
                            name = this.element.toString();
                            this.element.setLength(0);
                            state = CompoundState.PAIR_IDENTIFIER;
                            break block0;
                        }
                    }
                    if ('a' <= ch && 'z' >= ch || 'A' <= ch && 'Z' >= ch) {
                        this.element.append(ch);
                        this.parseString();
                        name = this.element.toString();
                        this.element.setLength(0);
                        state = CompoundState.PAIR_IDENTIFIER;
                        break;
                    }
                    throw new MojangsonParseException("Expected [a-zA-Z{] but got: " + ch);
                }
                case PAIR_IDENTIFIER: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case ':': {
                            state = CompoundState.VALUE;
                            break block0;
                        }
                    }
                    throw new MojangsonParseException("Expected [:] but got: " + ch);
                }
                case VALUE: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case '\"': {
                            this.parseQuotedString();
                            result.setString(name, this.element.toString());
                            this.element.setLength(0);
                            state = CompoundState.PAIR_SEPARATOR_OR_END;
                            break block0;
                        }
                        case '<': {
                            result.setByteArray(name, this.parseByteArray());
                            state = CompoundState.PAIR_SEPARATOR_OR_END;
                            break block0;
                        }
                        case '\u00ab': {
                            result.setIntArray(name, this.parseIntList());
                            state = CompoundState.PAIR_SEPARATOR_OR_END;
                            break block0;
                        }
                        case '[': {
                            result.setList(name, this.parseList());
                            state = CompoundState.PAIR_SEPARATOR_OR_END;
                            break block0;
                        }
                        case '{': {
                            result.setCompound(name, this.parseCompound());
                            state = CompoundState.PAIR_SEPARATOR_OR_END;
                            break block0;
                        }
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.in.unread(ch);
                            this.parseNumericValue(new CompoundNumericResultHandler(name, result));
                            state = CompoundState.PAIR_SEPARATOR_OR_END;
                            break block0;
                        }
                    }
                    if ('a' <= ch && 'z' >= ch || 'A' <= ch && 'Z' >= ch) {
                        this.element.append(ch);
                        this.parseString();
                        result.setString(name, this.element.toString());
                        this.element.setLength(0);
                        state = CompoundState.PAIR_SEPARATOR_OR_END;
                        break;
                    }
                    throw new MojangsonParseException("Expected value got: " + ch);
                }
                case PAIR_SEPARATOR_OR_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case ',': {
                            state = CompoundState.KEY_OR_END;
                            break block0;
                        }
                        case '}': {
                            return result;
                        }
                    }
                    throw new MojangsonParseException("Expected [,}] but got: " + ch);
                }
            }
        }
        throw new MojangsonParseException("Unexpected EOF in compound");
    }

    private ListTag constructList(TagType tag, List<? extends Tag> data) {
        if (tag == null) {
            return new ListTag(TagType.END, null);
        }
        return new ListTag(tag, data.toArray(tag.newArray(data.size())));
    }

    private ListTag parseList() throws IOException {
        int i;
        ArrayList<Tag> listData = new ArrayList<Tag>();
        TagType type = null;
        ListState state = ListState.VALUE_OR_END;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block0 : switch (state) {
                case VALUE_OR_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case ']': {
                            return this.constructList(type, listData);
                        }
                        case '\"': {
                            if (type == null) {
                                type = TagType.STRING;
                            } else if (type != TagType.STRING) {
                                throw new MojangsonParseException("Expected list value of type: " + (Object)((Object)type) + " got: " + (Object)((Object)TagType.STRING));
                            }
                            this.parseQuotedString();
                            listData.add(new StringTag(this.element.toString()));
                            this.element.setLength(0);
                            state = ListState.SEPARATOR_OR_END;
                            break block0;
                        }
                        case '<': {
                            if (type == null) {
                                type = TagType.BYTE_ARRAY;
                            } else if (type != TagType.BYTE_ARRAY) {
                                throw new MojangsonParseException("Expected list value of type: " + (Object)((Object)type) + " got: " + (Object)((Object)TagType.BYTE_ARRAY));
                            }
                            listData.add(new ByteArrayTag(this.parseByteArray()));
                            state = ListState.SEPARATOR_OR_END;
                            break block0;
                        }
                        case '\u00ab': {
                            if (type == null) {
                                type = TagType.INT_ARRAY;
                            } else if (type != TagType.INT_ARRAY) {
                                throw new MojangsonParseException("Expected list value of type: " + (Object)((Object)type) + " got: " + (Object)((Object)TagType.INT_ARRAY));
                            }
                            listData.add(new IntArrayTag(this.parseIntList()));
                            state = ListState.SEPARATOR_OR_END;
                            break block0;
                        }
                        case '[': {
                            if (type == null) {
                                type = TagType.LIST;
                            } else if (type != TagType.LIST) {
                                throw new MojangsonParseException("Expected list value of type: " + (Object)((Object)type) + " got: " + (Object)((Object)TagType.LIST));
                            }
                            listData.add(this.parseList());
                            state = ListState.SEPARATOR_OR_END;
                            break block0;
                        }
                        case '{': {
                            if (type == null) {
                                type = TagType.COMPOUND;
                            } else if (type != TagType.COMPOUND) {
                                throw new MojangsonParseException("Expected list value of type: " + (Object)((Object)type) + " got: " + (Object)((Object)TagType.COMPOUND));
                            }
                            listData.add(this.parseCompound());
                            state = ListState.SEPARATOR_OR_END;
                            break block0;
                        }
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.in.unread(ch);
                            type = this.parseNumericValue(type, new ListNumericResultHandler(listData));
                            state = ListState.SEPARATOR_OR_END;
                            break block0;
                        }
                    }
                    if ('a' <= ch && 'z' >= ch || 'A' <= ch && 'Z' >= ch) {
                        if (type == null) {
                            type = TagType.STRING;
                        } else if (type != TagType.STRING) {
                            throw new MojangsonParseException("Expected list value of type: " + (Object)((Object)type) + " got: " + (Object)((Object)TagType.STRING));
                        }
                        this.parseString();
                        listData.add(new StringTag(this.element.toString()));
                        this.element.setLength(0);
                        state = ListState.SEPARATOR_OR_END;
                        break;
                    }
                    throw new MojangsonParseException("Expected value got: " + ch);
                }
                case SEPARATOR_OR_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case ',': {
                            state = ListState.VALUE_OR_END;
                            break block0;
                        }
                        case ']': {
                            return this.constructList(type, listData);
                        }
                    }
                    throw new MojangsonParseException("Expected [,\\]] but got: " + ch);
                }
            }
        }
        throw new MojangsonParseException("Unexpected EOF in list");
    }

    private byte[] toByteArray(List<Byte> data) {
        byte[] result = new byte[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            result[i] = data.get(i);
        }
        return result;
    }

    private byte[] parseByteArray() throws IOException {
        int i;
        ArrayList<Byte> data = new ArrayList<Byte>();
        ByteArrayState state = ByteArrayState.WS_NUMBER_END;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block1 : switch (state) {
                case WS_NUMBER_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                        case '>': {
                            return this.toByteArray(data);
                        }
                        case '0': {
                            data.add((byte)0);
                            state = ByteArrayState.SEPARATOR_OR_END;
                            break block1;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            state = ByteArrayState.NUMBER;
                            break block1;
                        }
                    }
                    throw new MojangsonParseException("Expected [1-9] got: " + ch);
                }
                case NUMBER: {
                    if ('0' <= ch && '9' >= ch) {
                        this.element.append(ch);
                        break;
                    }
                    this.in.unread(ch);
                    try {
                        int num = Integer.parseInt(this.element.toString());
                        if (num >= 255) {
                            throw new MojangsonParseException("Byte expected, got: " + this.element);
                        }
                        data.add((byte)num);
                    }
                    catch (NumberFormatException e) {
                        throw new MojangsonParseException("Byte expected, got: " + this.element);
                    }
                    this.element.setLength(0);
                    state = ByteArrayState.SEPARATOR_OR_END;
                    break;
                }
                case SEPARATOR_OR_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                        case ',': {
                            state = ByteArrayState.WS_NUMBER_END;
                            break block1;
                        }
                        case '>': {
                            return this.toByteArray(data);
                        }
                    }
                    throw new IOException("Expected [,>] got: " + ch);
                }
            }
        }
        throw new MojangsonParseException("Unexpected EOF in byte array");
    }

    private int[] toIntArray(List<Integer> data) {
        int[] result = new int[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            result[i] = data.get(i);
        }
        return result;
    }

    private int[] parseIntList() throws IOException {
        int i;
        ArrayList<Integer> data = new ArrayList<Integer>();
        IntArrayState state = IntArrayState.WS_MINUS_NUMBER_END;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block1 : switch (state) {
                case WS_MINUS_NUMBER_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                        case '\u00bb': {
                            return this.toIntArray(data);
                        }
                        case '-': {
                            this.element.append(ch);
                            state = IntArrayState.FIRST_NUMBER;
                            break block1;
                        }
                        case '0': {
                            data.add(0);
                            state = IntArrayState.SEPARATOR_OR_END;
                            break block1;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            state = IntArrayState.NUMBER;
                            break block1;
                        }
                    }
                    throw new MojangsonParseException("Expected [1-9] got: " + ch);
                }
                case FIRST_NUMBER: {
                    switch (ch) {
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            state = IntArrayState.NUMBER;
                            break;
                        }
                        default: {
                            throw new MojangsonParseException("Expected [1-9] got: " + ch);
                        }
                    }
                }
                case NUMBER: {
                    if ('0' <= ch && '9' >= ch) {
                        this.element.append(ch);
                        break;
                    }
                    this.in.unread(ch);
                    try {
                        data.add(Integer.parseInt(this.element.toString()));
                    }
                    catch (NumberFormatException e) {
                        throw new MojangsonParseException("Byte expected, got: " + this.element);
                    }
                    this.element.setLength(0);
                    state = IntArrayState.SEPARATOR_OR_END;
                    break;
                }
                case SEPARATOR_OR_END: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                        case ',': {
                            state = IntArrayState.WS_MINUS_NUMBER_END;
                            break block1;
                        }
                        case '\u00bb': {
                            return this.toIntArray(data);
                        }
                    }
                    throw new IOException("Expected [,\u00bb] got: " + ch);
                }
            }
        }
        throw new MojangsonParseException("Unexpected EOF in int array");
    }

    private TagType parseNumericValue(NumericResultHandler handler) throws IOException {
        return this.parseNumericValue(null, handler);
    }

    private TagType parseNumericValue(TagType expected, NumericResultHandler handler) throws IOException {
        int i;
        NumericValueState state = NumericValueState.NUMBER_DECIMAL_IDENTIFIER;
        while ((i = this.in.read()) != -1) {
            char ch = (char)i;
            block8 : switch (state) {
                case MINUS_NUMBER: {
                    switch (ch) {
                        case '-': {
                            this.element.append(ch);
                            state = NumericValueState.NUMBER;
                            break block8;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            state = NumericValueState.NUMBER_DECIMAL_IDENTIFIER;
                        }
                    }
                    break;
                }
                case NUMBER: {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            state = NumericValueState.NUMBER_DECIMAL_IDENTIFIER;
                        }
                    }
                }
                case NUMBER_DECIMAL_IDENTIFIER: {
                    switch (ch) {
                        case '.': {
                            this.element.append(ch);
                            state = NumericValueState.NUMBER_IDENTIFIER;
                            break block8;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            break block8;
                        }
                        case 'B': 
                        case 'b': {
                            if (expected != null && expected != TagType.BYTE) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.BYTE));
                            }
                            try {
                                handler.value(Byte.parseByte(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.BYTE;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected byte, got: " + this.element.toString() + ch);
                            }
                        }
                        case 'S': 
                        case 's': {
                            if (expected != null && expected != TagType.SHORT) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.SHORT));
                            }
                            try {
                                handler.value(Short.parseShort(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.SHORT;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected short, got: " + this.element.toString() + ch);
                            }
                        }
                        case 'L': 
                        case 'l': {
                            if (expected != null && expected != TagType.LONG) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.LONG));
                            }
                            try {
                                handler.value(Long.parseLong(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.LONG;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected long, got: " + this.element.toString() + ch);
                            }
                        }
                        case 'F': 
                        case 'f': {
                            if (expected != null && expected != TagType.FLOAT) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.FLOAT));
                            }
                            try {
                                handler.value(Float.parseFloat(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.FLOAT;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected float, got: " + this.element.toString() + ch);
                            }
                        }
                        case 'D': 
                        case 'd': {
                            if (expected != null && expected != TagType.DOUBLE) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.DOUBLE));
                            }
                            try {
                                handler.value(Double.parseDouble(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.DOUBLE;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected double, got: " + this.element.toString() + ch);
                            }
                        }
                        case ',': 
                        case ']': 
                        case '}': {
                            this.in.unread(ch);
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (expected != null && expected != TagType.INT) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.INT));
                            }
                            try {
                                handler.value(Integer.parseInt(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.INT;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected double, got: " + this.element.toString() + ch);
                            }
                        }
                    }
                    break;
                }
                case NUMBER_IDENTIFIER: {
                    switch (ch) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.element.append(ch);
                            break block8;
                        }
                        case 'F': 
                        case 'f': {
                            if (expected != null && expected != TagType.FLOAT) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.FLOAT));
                            }
                            try {
                                handler.value(Float.parseFloat(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.FLOAT;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected float, got: " + this.element.toString() + ch);
                            }
                        }
                        case ',': 
                        case ']': 
                        case '}': {
                            this.in.unread(ch);
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case 'D': 
                        case 'd': {
                            if (expected != null && expected != TagType.DOUBLE) {
                                throw new MojangsonParseException("Expected " + (Object)((Object)expected) + " got " + (Object)((Object)TagType.DOUBLE));
                            }
                            try {
                                handler.value(Double.parseDouble(this.element.toString()));
                                this.element.setLength(0);
                                return TagType.DOUBLE;
                            }
                            catch (NumberFormatException ex) {
                                throw new MojangsonParseException("Expected double, got: " + this.element.toString() + ch);
                            }
                        }
                    }
                }
            }
        }
        throw new MojangsonParseException("Unexpected EOF in numeric value");
    }

    private static interface NumericResultHandler {
        public void value(byte var1);

        public void value(short var1);

        public void value(int var1);

        public void value(long var1);

        public void value(float var1);

        public void value(double var1);
    }

    private static class CompoundNumericResultHandler
    implements NumericResultHandler {
        private final String key;
        private final CompoundTag tag;

        public CompoundNumericResultHandler(String key, CompoundTag tag) {
            this.key = key;
            this.tag = tag;
        }

        @Override
        public void value(byte b) {
            this.tag.setByte(this.key, b);
        }

        @Override
        public void value(short s) {
            this.tag.setShort(this.key, s);
        }

        @Override
        public void value(int i) {
            this.tag.setInt(this.key, i);
        }

        @Override
        public void value(long l) {
            this.tag.setLong(this.key, l);
        }

        @Override
        public void value(float f) {
            this.tag.setFloat(this.key, f);
        }

        @Override
        public void value(double d) {
            this.tag.setDouble(this.key, d);
        }
    }

    private static class ListNumericResultHandler
    implements NumericResultHandler {
        private List<Tag> data;

        public ListNumericResultHandler(List<Tag> data) {
            this.data = data;
        }

        @Override
        public void value(byte b) {
            this.data.add(new ByteTag(b));
        }

        @Override
        public void value(short s) {
            this.data.add(new ShortTag(s));
        }

        @Override
        public void value(int i) {
            this.data.add(new IntTag(i));
        }

        @Override
        public void value(long l) {
            this.data.add(new LongTag(l));
        }

        @Override
        public void value(float f) {
            this.data.add(new FloatTag(f));
        }

        @Override
        public void value(double d) {
            this.data.add(new DoubleTag(d));
        }
    }

    private static enum NumericValueState {
        MINUS_NUMBER,
        NUMBER,
        NUMBER_DECIMAL_IDENTIFIER,
        NUMBER_IDENTIFIER;

    }

    private static enum IntArrayState {
        WS_MINUS_NUMBER_END,
        FIRST_NUMBER,
        NUMBER,
        SEPARATOR_OR_END;

    }

    private static enum ByteArrayState {
        WS_NUMBER_END,
        NUMBER,
        SEPARATOR_OR_END;

    }

    private static enum ListState {
        VALUE_OR_END,
        SEPARATOR_OR_END;

    }

    private static enum CompoundState {
        KEY_OR_END,
        PAIR_IDENTIFIER,
        VALUE,
        PAIR_SEPARATOR_OR_END;

    }

    private static enum QuotedStringState {
        LITERAL,
        ESCAPED,
        UNICODE;

    }

    private static enum RootState {
        KEY_OR_COMPOUND,
        PAIR_IDENTIFIER,
        COMPOUND,
        EOF;

    }
}

