/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Converter {
    private TreasureChest plugin;

    public Converter(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public void convertAll() {
        File chestContentFolder = new File(this.plugin.getDataFolder(), "content");
        if (!chestContentFolder.isDirectory()) {
            return;
        }
        File[] treasureChestFiles = chestContentFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".yml");
            }
        });
        this.plugin.getLogger().info("Konvertiere " + treasureChestFiles.length + " Dateien");
        int i = 0;
        for (File file : treasureChestFiles) {
            try {
                UUID owner = UUID.fromString(file.getName().substring(0, file.getName().length() - 4));
                this.convertPlayer(owner, file);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not convert " + file.getName() + ": " + e.getMessage(), e);
            }
            if (++i % 100 != 0) continue;
            this.plugin.getLogger().info(i + "/" + treasureChestFiles.length);
        }
        if (chestContentFolder.listFiles().length == 0) {
            chestContentFolder.delete();
        }
        this.plugin.getLogger().info(i + "/" + treasureChestFiles.length);
        File uuidFile = new File(this.plugin.getDataFolder(), "playerUUIDs.yml");
        if (uuidFile.exists()) {
            uuidFile.delete();
        }
    }

    public void convertPlayer(UUID owner, File file) {
        try {
            YamlConfiguration conf;
            ConfigurationSection prices;
            if (file.exists() && (prices = (conf = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("prices")) != null) {
                for (String e : prices.getKeys(false)) {
                    ConfigurationSection price = prices.getConfigurationSection(e);
                    if (price == null) continue;
                    ItemStack display = price.getItemStack("displayItem");
                    if (display == null) {
                        display = new ItemStack(Material.BEDROCK);
                        ItemMeta meta = display.getItemMeta();
                        meta.setDisplayName("Unset displayitem");
                        display.setItemMeta(meta);
                    }
                    int priceMoney = price.getInt("priceMoney");
                    ArrayList<ItemStack> priceItems = new ArrayList<ItemStack>();
                    ConfigurationSection itemPricesSection = price.getConfigurationSection("itemPrices");
                    if (itemPricesSection != null) {
                        for (String pricee : itemPricesSection.getKeys(false)) {
                            ItemStack priceItem = itemPricesSection.getItemStack(pricee);
                            if (priceItem == null) continue;
                            priceItems.add(priceItem);
                        }
                    }
                    TreasureChestItem item = new TreasureChestItem(display, priceItems.toArray(new ItemStack[priceItems.size()]), priceMoney);
                    this.plugin.getDatabase().addItem(owner, item);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load user chest file: " + file.getName(), e);
        }
        file.delete();
    }
}

