/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.PlayerUUIDCache;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;

public class BinaryStorage {
    private static final int ENTRY_LENGTH = 56;
    private final PlayerUUIDCache plugin;
    private final HashMap<UUID, Integer> filePositions;
    private final RandomAccessFile file;
    private boolean loaded = false;
    private int totalEntries = 0;

    public BinaryStorage(PlayerUUIDCache plugin) throws IOException {
        this.plugin = plugin;
        this.filePositions = new HashMap();
        File dataFile = new File(plugin.getDataFolder(), "players.dat");
        this.file = new RandomAccessFile(dataFile, "rw");
    }

    public ArrayList<CachedPlayer> loadAllPlayers() throws IOException {
        if (this.loaded) {
            throw new IllegalStateException("loadAllPlayers can only be called once");
        }
        this.loaded = true;
        ArrayList<CachedPlayer> players = new ArrayList<CachedPlayer>();
        if (this.file.length() >= 4L) {
            int version = this.file.readInt();
            if (version != 1) {
                throw new IOException("Invalid data file version: " + version);
            }
            long length = this.file.length() - 4L;
            if (length > 0L) {
                long now = System.currentTimeMillis();
                byte[] data = new byte[(int)length];
                this.file.readFully(data);
                this.totalEntries = (int)length / 56;
                ByteBuffer bb = ByteBuffer.wrap(data);
                char[] nameChars = new char[16];
                for (int i = 0; i < this.totalEntries; ++i) {
                    long msb = bb.getLong();
                    long lsb = bb.getLong();
                    UUID uuid = new UUID(msb, lsb);
                    int nameLength = 16;
                    for (int j = 0; j < 16; ++j) {
                        nameChars[j] = bb.getChar();
                        if (nameChars[j] != '\u0000' || nameLength != 16) continue;
                        nameLength = j;
                    }
                    String name = new String(nameChars, 0, nameLength);
                    long lastSeen = bb.getLong();
                    players.add(new CachedPlayer(uuid, name, lastSeen, now));
                    this.filePositions.put(uuid, i);
                }
            }
        } else {
            this.file.seek(0L);
            this.file.writeInt(1);
        }
        return players;
    }

    public void addOrUpdate(CachedPlayer player) throws IOException {
        if (!this.loaded) {
            throw new IllegalStateException("loadAllPlayers must be called first");
        }
        Integer knownPosition = this.filePositions.get(player.getUUID());
        if (knownPosition == null) {
            knownPosition = this.totalEntries++;
            this.filePositions.put(player.getUUID(), knownPosition);
        }
        this.file.seek(knownPosition * 56 + 4);
        byte[] dataOut = new byte[56];
        ByteBuffer buffer = ByteBuffer.wrap(dataOut);
        buffer.putLong(player.getUUID().getMostSignificantBits());
        buffer.putLong(player.getUUID().getLeastSignificantBits());
        String name = player.getName();
        for (int i = 0; i < 16; ++i) {
            buffer.putChar(name.length() > i ? name.charAt(i) : (char)'\u0000');
        }
        buffer.putLong(player.getLastSeen());
        this.file.write(dataOut);
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error while trying to close the data file", e);
        }
    }
}

