/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.debug;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.lwc.MessageParser;
import com.griefcraft.model.Flag;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DebugModule
extends JavaModule {
    private String yes = null;
    private String no = null;

    @Override
    public void load(LWC lwc) {
        MessageParser parser = lwc.getPlugin().getMessageParser();
        this.yes = parser.parseMessage("yes", new Object[0]);
        this.no = parser.parseMessage("no", new Object[0]);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("debug")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            lwc.sendLocale(sender, "lwc.onlyrealplayers", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        player.sendMessage(" ");
        player.sendMessage("\u00a78LWC: " + String.valueOf(LWCInfo.FULL_VERSION));
        player.sendMessage(" ");
        player.sendMessage("Groups => " + String.valueOf(lwc.getPermissions().getGroups(player)));
        lwc.sendLocale((CommandSender)player, "lwc.debug.standard", new Object[0]);
        this.doPermission(player, "lwc.protect");
        this.doPlayerPermission(player, "lwc.create.public");
        this.doPlayerPermission(player, "lwc.create.password");
        this.doPlayerPermission(player, "lwc.create.private");
        this.doPlayerPermission(player, "lwc.info");
        this.doPlayerPermission(player, "lwc.remove");
        this.doPlayerPermission(player, "lwc.modify");
        this.doPlayerPermission(player, "lwc.unlock");
        for (Flag.Type type : Flag.Type.values()) {
            this.doPlayerPermission(player, "lwc.flag." + type.toString().toLowerCase());
        }
        player.sendMessage(" ");
        this.doPermission(player, "lwc.mod");
        this.doPermission(player, "lwc.admin");
        player.sendMessage("isMod: " + this.strval(lwc.isMod(player)));
        player.sendMessage("isAdmin: " + this.strval(lwc.isAdmin(player)));
    }

    private void doPermission(Player player, String node) {
        player.sendMessage(node + ": " + this.strval(LWC.getInstance().hasPermission(player, node)));
    }

    private void doPlayerPermission(Player player, String node) {
        player.sendMessage(node + ": " + this.strval(LWC.getInstance().hasPlayerPermission((CommandSender)player, node)));
    }

    private String strval(boolean bool) {
        return bool ? this.yes : this.no;
    }
}

