/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.owners;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Permission;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OwnersModule
extends JavaModule {
    public static final int RESULTS_PER_PAGE = 15;

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("owners")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        LWCPlayer player = lwc.wrapPlayer((CommandSender)event.getPlayer());
        event.setResult(Module.Result.CANCEL);
        Action action = player.getAction("owners");
        int accessPage = Integer.parseInt(action.getData());
        int start = (accessPage - 1) * 15;
        int max = start + 15;
        List<Permission> permissions = protection.getPermissions();
        int numRights = permissions.size();
        int realMax = start + permissions.size();
        lwc.sendLocale(player, "lwc.owners.results", "start", start, "max", realMax, "total", numRights);
        for (int index = 0; index < max && start + index < numRights; ++index) {
            Permission permission = permissions.get(start + index);
            player.sendMessage(permission.toString());
        }
        lwc.removeModes(player);
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("owners")) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(block));
        lwc.removeModes((CommandSender)player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("o", "owner", "owners")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            lwc.sendLocale(sender, "lwc.onlyrealplayers", new Object[0]);
            return;
        }
        LWCPlayer player = lwc.wrapPlayer(sender);
        int page = 1;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                lwc.sendSimpleUsage(sender, "/lwc -owners [page]");
                return;
            }
        }
        Action action = new Action();
        action.setName("owners");
        action.setPlayer(player);
        action.setData(page + "");
        player.removeAllActions();
        player.addAction(action);
        lwc.sendLocale(sender, "protection.owners.finalize", new Object[0]);
    }
}

