/*
 * Decompiled with CFR 0.152.
 */
package de.iani.interactiveBookAPI;

import com.google.common.base.Preconditions;
import de.iani.interactiveBookAPI.FontUtil;
import de.iani.interactiveBookAPI.InteractiveBookAPI;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class InteractiveBookAPIPlugin
extends JavaPlugin
implements InteractiveBookAPI {
    private Field bookMetaPagesField;
    private FontUtil fontUtil;

    public void onEnable() {
        this.getServer().getServicesManager().register(InteractiveBookAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        this.fontUtil = new FontUtil();
    }

    @Override
    public void addPage(BookMeta book, BaseComponent ... text) {
        this.internalSetPage(book, true, book.getPageCount(), text);
    }

    @Override
    public void insertPage(BookMeta book, int page, BaseComponent ... text) {
        this.internalSetPage(book, true, page, text);
    }

    @Override
    public void setPage(BookMeta book, int page, BaseComponent ... text) {
        this.internalSetPage(book, false, page, text);
    }

    private void internalSetPage(BookMeta book, boolean insert, int page, BaseComponent ... text) {
        ArrayList<String> pages;
        Preconditions.checkNotNull((Object)book, (Object)"book");
        Preconditions.checkNotNull((Object)text, (Object)"text");
        Preconditions.checkArgument((page >= 0 && page < book.getPageCount() + (insert ? 1 : 0) ? 1 : 0) != 0, (Object)("invalid page: " + page + ", page count: " + book.getPageCount()));
        if (this.bookMetaPagesField == null) {
            try {
                this.bookMetaPagesField = book.getClass().getSuperclass().getDeclaredField("pages");
                this.bookMetaPagesField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e2) {
                this.getLogger().log(Level.SEVERE, "BookMeta.pages could not be found. Please update the InteractiveBookAPI plugin.", e2);
                return;
            }
        }
        try {
            ArrayList<String> pages1;
            pages = pages1 = (ArrayList<String>)this.bookMetaPagesField.get(book);
            if (pages == null) {
                pages = new ArrayList<String>();
                this.bookMetaPagesField.set(book, pages);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.getLogger().log(Level.SEVERE, "BookMeta.pages could not be accessed. Please update the InteractiveBookAPI plugin.", e);
            return;
        }
        String pageJson = ComponentSerializer.toString((BaseComponent[])text);
        if (insert) {
            pages.add(page, pageJson);
        } else {
            pages.set(page, pageJson);
        }
    }

    @Override
    public void showBookToPlayer(Player player, ItemStack book) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)book, (Object)"book");
        Preconditions.checkArgument((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (Object)"book is no writen book");
        player.openBook(book);
    }

    @Override
    public boolean fitsPage(BaseComponent ... text) {
        if (text == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (BaseComponent c : text) {
            sb.append(c.toLegacyText());
        }
        return this.fontUtil.fitsSingleBookPage(sb.toString());
    }
}

