/*
 * Decompiled with CFR 0.152.
 */
package de.iani.interactiveBookAPI;

import com.google.common.base.Preconditions;
import de.iani.interactiveBookAPI.FontUtil;
import de.iani.interactiveBookAPI.InteractiveBookAPI;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_15_R1.EnumHand;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenBook;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class InteractiveBookAPIPlugin
extends JavaPlugin
implements InteractiveBookAPI {
    private Field bookMetaPagesField;
    private Method chatSerializerJsonToComponentMethod;
    private FontUtil fontUtil;

    public void onEnable() {
        this.getServer().getServicesManager().register(InteractiveBookAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        this.fontUtil = new FontUtil();
    }

    @Override
    public void addPage(BookMeta book, BaseComponent ... text) {
        this.internalSetPage(book, true, book.getPageCount(), text);
    }

    @Override
    public void insertPage(BookMeta book, int page, BaseComponent ... text) {
        this.internalSetPage(book, true, page, text);
    }

    @Override
    public void setPage(BookMeta book, int page, BaseComponent ... text) {
        this.internalSetPage(book, false, page, text);
    }

    private void internalSetPage(BookMeta book, boolean insert, int page, BaseComponent ... text) {
        Object iChatBaseComponent;
        List pages;
        Preconditions.checkNotNull((Object)book, (Object)"book");
        Preconditions.checkNotNull((Object)text, (Object)"text");
        Preconditions.checkArgument((page >= 0 && page < book.getPageCount() + (insert ? 1 : 0) ? 1 : 0) != 0, (Object)("invalid page: " + page + ", page count: " + book.getPageCount()));
        if (this.bookMetaPagesField == null) {
            try {
                this.bookMetaPagesField = book.getClass().getField("pages");
                this.bookMetaPagesField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                this.getLogger().log(Level.SEVERE, "BookMeta.pages could not be found. Please update the InteractiveBookAPI plugin.", e);
                return;
            }
        }
        if (this.chatSerializerJsonToComponentMethod == null) {
            Class<?> chatSerializer;
            String className = book.getClass().getName();
            String[] parts = className.split("\\.");
            if (parts.length < 4) {
                this.getLogger().log(Level.SEVERE, "Could not find server version in " + className + ".");
                return;
            }
            String version = parts[3];
            try {
                chatSerializer = Class.forName("net.minecraft.server." + version + ".IChatBaseComponent$ChatSerializer");
            }
            catch (ClassNotFoundException e) {
                this.getLogger().log(Level.SEVERE, "IChatBaseComponent$ChatSerializer could not be found. Please update the InteractiveBookAPI plugin.", e);
                return;
            }
            try {
                this.chatSerializerJsonToComponentMethod = chatSerializer.getMethod("a", String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                this.getLogger().log(Level.SEVERE, "ChatSerializer.a could not be found. Please update the InteractiveBookAPI plugin.", e);
                return;
            }
        }
        try {
            List pages1;
            pages = pages1 = (List)this.bookMetaPagesField.get(book);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.getLogger().log(Level.SEVERE, "BookMeta.pages could not be accessed. Please update the InteractiveBookAPI plugin.", e);
            return;
        }
        String pageJson = ComponentSerializer.toString((BaseComponent[])text);
        try {
            iChatBaseComponent = this.chatSerializerJsonToComponentMethod.invoke(null, pageJson);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "ChatSerializer.a could not be accessed. Please update the InteractiveBookAPI plugin.", e);
            return;
        }
        if (insert) {
            pages.add(page, iChatBaseComponent);
        } else {
            pages.set(page, iChatBaseComponent);
        }
    }

    @Override
    public void showBookToPlayer(Player player, ItemStack book) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)book, (Object)"book");
        Preconditions.checkArgument((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (Object)"book is no writen book");
        PlayerInventory inv = player.getInventory();
        int slot = inv.getHeldItemSlot();
        ItemStack oldItem = inv.getItemInMainHand();
        inv.setItemInMainHand(book);
        inv.setHeldItemSlot(slot);
        try {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutOpenBook(EnumHand.MAIN_HAND));
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "OpenBook could not be called. Please update the InteractiveBookAPI plugin.", t);
        }
        inv.setItemInMainHand(oldItem);
    }

    @Override
    public boolean fitsPage(BaseComponent ... text) {
        if (text == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (BaseComponent c : text) {
            sb.append(c.toLegacyText());
        }
        return this.fontUtil.fitsSingleBookPage(sb.toString());
    }
}

