/*
 * Decompiled with CFR 0.152.
 */
package de.iani.interactiveBookAPI;

import java.io.IOException;
import java.io.InputStream;

public class FontUtil {
    private static final int BOOK_LINE_WIDTH = 110;
    private byte[] charWidth = new byte[256];
    private byte[] glyphWidth = new byte[65536];

    public FontUtil() {
        Throwable throwable;
        InputStream is;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("unicode_sizes.bin");
            throwable = null;
            try {
                is.read(this.glyphWidth);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("ascii_sizes.bin");
            throwable = null;
            try {
                is.read(this.charWidth);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getBookLines(String string) {
        return this.splitString(this.trimNewlines(string), 110).length;
    }

    public boolean fitsSingleBookPage(String string) {
        return this.getBookLines(string) <= 14;
    }

    public String trimNewlines(String string) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String[] splitString(String string, int availableWidth) {
        return this.wrapString(string, availableWidth).split("\n");
    }

    public String wrapString(String string, int availableWidth) {
        int charactersInLine = this.getFittingCharacters(string, availableWidth);
        if (string.length() <= charactersInLine) {
            return string;
        }
        String thisLine = string.substring(0, charactersInLine);
        char firstRemainingCharacter = string.charAt(charactersInLine);
        boolean removeFirstRemainingChar = firstRemainingCharacter == ' ' || firstRemainingCharacter == '\n';
        String remaining = FontUtil.extractFormatingFromString(thisLine) + string.substring(charactersInLine + (removeFirstRemainingChar ? 1 : 0));
        return thisLine + "\n" + this.wrapString(remaining, availableWidth);
    }

    private int getFittingCharacters(String string, int availableWidth) {
        int pos;
        int stringLength = string.length();
        int totalWidth = 0;
        int lastSpace = -1;
        boolean bold = false;
        for (pos = 0; pos < stringLength; ++pos) {
            char c = string.charAt(pos);
            switch (c) {
                case '\n': {
                    lastSpace = pos;
                    break;
                }
                case '\u00a7': {
                    char colorChar;
                    if (pos >= stringLength - 1) break;
                    if ((colorChar = string.charAt(++pos)) != 'l' && colorChar != 'L') {
                        if (colorChar != 'r' && colorChar != 'R' && !FontUtil.isFormatColor(colorChar)) break;
                        bold = false;
                        break;
                    }
                    bold = true;
                    break;
                }
                case ' ': {
                    lastSpace = pos;
                }
                default: {
                    totalWidth += this.getCharWidth(c) + (bold ? 1 : 0);
                }
            }
            if (c == '\n' || totalWidth > availableWidth) break;
        }
        return pos != stringLength && lastSpace != -1 && lastSpace < pos ? lastSpace : pos;
    }

    private int getCharWidth(char c) {
        if (c == '\u00a7') {
            return -1;
        }
        if (c == ' ') {
            return 4;
        }
        int asciiPosition = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c);
        if (c > '\u0000' && asciiPosition != -1) {
            return this.charWidth[asciiPosition];
        }
        if (this.glyphWidth[c] != 0) {
            int charStart = this.glyphWidth[c] >>> 4;
            int charEnd = this.glyphWidth[c] & 0xF;
            if (charEnd > 7) {
                charEnd = 15;
                charStart = 0;
            }
            return (charEnd + 1 - charStart) / 2 + 1;
        }
        return 0;
    }

    private static boolean isFormatColor(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isFormatSpecialCharacter(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R';
    }

    public static String extractFormatingFromString(String string) {
        String formatingString = "";
        int formatingInitialCharacter = -1;
        int stringLength = string.length();
        while ((formatingInitialCharacter = string.indexOf(167, formatingInitialCharacter + 1)) != -1) {
            if (formatingInitialCharacter >= stringLength - 1) continue;
            char colorCharacter = string.charAt(formatingInitialCharacter + 1);
            if (FontUtil.isFormatColor(colorCharacter)) {
                formatingString = "\u00a7" + colorCharacter;
                continue;
            }
            if (!FontUtil.isFormatSpecialCharacter(colorCharacter)) continue;
            formatingString = formatingString + "\u00a7" + colorCharacter;
        }
        return formatingString;
    }
}

