/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.adventure.translations;

import de.iani.cubesideutils.Pair;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.translation.AbstractTranslationStore;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CubesideTranslations {
    private static Map<String, CubesideTranslationData> knownTranslations;

    public static Pair<MessageFormat, MessageFormat> registerTranslation(String key, String english, String german) {
        return CubesideTranslations.registerTranslation(key, CubesideTranslations.quoteString(english), CubesideTranslations.quoteString(german));
    }

    public static Pair<MessageFormat, MessageFormat> registerTranslation(String key, MessageFormat english, MessageFormat german) {
        CubesideTranslationData newData = new CubesideTranslationData(english, german);
        CubesideTranslationData oldData = knownTranslations.putIfAbsent(key, newData);
        if (oldData == null) {
            return null;
        }
        return new Pair<MessageFormat, MessageFormat>(oldData.replaceEnglish(english), oldData.replaceGerman(german));
    }

    public static MessageFormat registerTranslation(String key, Locale locale, MessageFormat value) {
        CubesideTranslationData data = knownTranslations.get(key);
        return data.setOther(locale, value);
    }

    public static MessageFormat quoteString(String string) {
        return new MessageFormat(string.replace("'", "''"));
    }

    public static CubesideTranslationData getTranslations(String key) {
        return knownTranslations.get(key);
    }

    public static Component translateCubesideKeys(Component message, Locale locale) {
        TranslatableComponent tc;
        if ((message = message.children(message.children().stream().map(c -> CubesideTranslations.translateCubesideKeys(c, locale)).toList())) instanceof TranslatableComponent && knownTranslations.containsKey((tc = (TranslatableComponent)message).key())) {
            message = GlobalTranslator.render((Component)message.children(List.of()), (Locale)locale).children(message.children());
        }
        return message;
    }

    static {
        new CubesideTranslator();
        knownTranslations = new LinkedHashMap<String, CubesideTranslationData>();
        CubesideTranslations.registerTranslation("cubeside.and", "and", "und");
        CubesideTranslations.registerTranslation("cubeside.and_or", "and/or", "und/oder");
        CubesideTranslations.registerTranslation("cubeside.enchanted_with", "enchanted with", "verzaubert mit");
        CubesideTranslations.registerTranslation("cubeside.for", "for", "f\u00fcr");
        CubesideTranslations.registerTranslation("cubeside.roughly", "rougly", "ungef\u00e4hr");
    }

    public static class CubesideTranslationData {
        private MessageFormat english;
        private MessageFormat german;
        private Map<Locale, MessageFormat> otherLocales;

        public CubesideTranslationData(MessageFormat english, MessageFormat german) {
            this.english = Objects.requireNonNull(english);
            this.german = Objects.requireNonNull(german);
            this.otherLocales = new LinkedHashMap<Locale, MessageFormat>();
        }

        public MessageFormat getEnglish() {
            return this.english;
        }

        private MessageFormat replaceEnglish(MessageFormat value) {
            MessageFormat old = this.english;
            this.english = value;
            return old;
        }

        public MessageFormat getGerman() {
            return this.german;
        }

        private MessageFormat replaceGerman(MessageFormat value) {
            MessageFormat old = this.german;
            this.german = value;
            return old;
        }

        public MessageFormat getOther(Locale locale) {
            return this.otherLocales.get(locale);
        }

        private MessageFormat setOther(Locale locale, MessageFormat value) {
            return this.otherLocales.put(locale, value);
        }
    }

    private static class CubesideTranslator
    extends AbstractTranslationStore<Component> {
        private static final Key TRANSLATOR_KEY = Key.key((String)"cubeside", (String)"translator");

        private CubesideTranslator() {
            super(TRANSLATOR_KEY);
            GlobalTranslator.translator().addSource((Translator)this);
        }

        @Nullable
        public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
            CubesideTranslationData data = CubesideTranslations.getTranslations(key);
            if (data == null) {
                return null;
            }
            MessageFormat result = data.getOther(locale);
            if (result != null) {
                return result;
            }
            if ("de".equals(locale.getLanguage())) {
                return data.getGerman();
            }
            return data.getEnglish();
        }
    }

    public static class Keys {
        public static final String AND = "cubeside.and";
        public static final String AND_OR = "cubeside.and_or";
        public static final String ENCHANTED_WITH = "cubeside.enchanted_with";
        public static final String FOR = "cubeside.for";
        public static final String ROUGLY = "cubeside.roughly";
    }

    public static class Components {
        public static final Component AND = Component.translatable((String)"cubeside.and");
        public static final Component AND_OR = Component.translatable((String)"cubeside.and_or");
        public static final Component ENCHANTED_WITH = Component.translatable((String)"cubeside.enchanted_with");
        public static final Component FOR = Component.translatable((String)"cubeside.for");
        public static final Component ROUGLY = Component.translatable((String)"cubeside.roughly");
    }
}

