/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.linkextractor;

import de.iani.cubesideutils.linkextractor.LinkSegment;
import de.iani.cubesideutils.linkextractor.PlainSegment;
import de.iani.cubesideutils.linkextractor.Segment;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkExtractor {
    public static final Pattern URL_PATTERN = Pattern.compile("(?<url>(?<protocol>https?\\:\\/\\/)?(?<domain>(?:[a-z0-9](?:[a-z0-9\\-]*[a-z0-9])?\\.)+[a-z]{2,63})(?<path>[\\/\\#\\?](?:[^\\s\"'<>)]*[^\\s\"'<>),.])?)?)(?=[\\s\"'<>),.]|$)", 2);

    public static List<Segment> extractLinks(String s) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        Matcher matcher = URL_PATTERN.matcher(s);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                result.add(new PlainSegment(s.substring(lastEnd, matcher.start())));
            }
            result.add(new LinkSegment(matcher.group("url"), matcher.group("domain")));
            lastEnd = matcher.end();
        }
        if (lastEnd < s.length()) {
            result.add(new PlainSegment(s.substring(lastEnd)));
        }
        return result;
    }
}

