/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity.plugin;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.velocity.plugin.CubesideUtilsVelocity;
import de.iani.cubesideutils.velocity.plugin.PlayerDataImplVelocity;
import de.iani.cubesideutils.velocity.plugin.api.PlayerCacheMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;

public class PlayerDataCache
extends PlayerCacheMap<PlayerDataImplVelocity, Pair<Boolean, Boolean>> {
    private static final long serialVersionUID = -8879364238741140063L;
    private static final int MAX_SOFT_CACHE_SIZE = 16;
    private UUID currentlyLoggingInPlayerId;

    public PlayerDataCache() {
        super(16, new Pair<Boolean, Boolean>(true, false), "PlayerData");
    }

    public UUID getCurrentlyLoggingInPlayer() {
        return this.currentlyLoggingInPlayerId;
    }

    public Collection<PlayerDataImplVelocity> loadedData() {
        return Collections.unmodifiableCollection(new ArrayList(this.values()));
    }

    public PlayerDataImplVelocity get(Object key, boolean queryDatabase, boolean createIfMissing) {
        return (PlayerDataImplVelocity)this.get(key, new Pair<Boolean, Boolean>(queryDatabase, createIfMissing));
    }

    @Override
    protected void checkData(Pair<Boolean, Boolean> data) {
        if (data == null || data.first == null || data.second == null) {
            throw new NullPointerException();
        }
        if (!((Boolean)data.first).booleanValue() && ((Boolean)data.second).booleanValue()) {
            throw new IllegalArgumentException("can only createIfMissing if queryDatabase");
        }
    }

    @Override
    protected boolean shouldLoadIntoCache(UUID key, Pair<Boolean, Boolean> data) {
        return (Boolean)data.first;
    }

    @Override
    protected PlayerDataImplVelocity load(UUID key, Pair<Boolean, Boolean> data) {
        try {
            return (PlayerDataImplVelocity)CubesideUtilsVelocity.getInstance().getDatabase().getPlayerData(key, (Boolean)data.second);
        }
        catch (SQLException e) {
            CubesideUtilsVelocity.getInstance().getLogger().log(Level.SEVERE, "Exception trying to query database for PlayerData.", e);
            return null;
        }
    }

    @Override
    public void invalidate(UUID key) {
        super.invalidate(key);
    }

    @Override
    protected PlayerDataImplVelocity getReplacement(UUID key, PlayerDataImplVelocity uncached) {
        try {
            return (PlayerDataImplVelocity)CubesideUtilsVelocity.getInstance().getDatabase().getPlayerData(key, true);
        }
        catch (SQLException e) {
            CubesideUtilsVelocity.getInstance().getLogger().log(Level.SEVERE, "Exception trying to load OnlinePlayerData for " + String.valueOf(key) + " from database.");
            return null;
        }
    }

    @Override
    protected void playerStartsLoggingIn(UUID playerId) {
        this.currentlyLoggingInPlayerId = playerId;
    }

    @Override
    protected PlayerDataImplVelocity loadOnLogin(UUID playerId) throws PlayerCacheMap.LoadingPlayerDataFailedException {
        try {
            return (PlayerDataImplVelocity)CubesideUtilsVelocity.getInstance().getDatabase().getPlayerData(playerId, true);
        }
        catch (SQLException e) {
            CubesideUtilsVelocity.getInstance().getLogger().log(Level.SEVERE, "Exception trying to load OnlinePlayerData for " + String.valueOf(playerId) + " from database.");
            return null;
        }
    }

    @Override
    protected void playerFinishsLoggingIn(UUID playerId) {
        this.currentlyLoggingInPlayerId = null;
    }
}

