/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.TagType;
import java.util.Arrays;

public class LongArrayTag
implements BaseTag<LongArrayTag> {
    private static final long[] EMPTY_ARRAY = new long[0];
    public long[] data = EMPTY_ARRAY;

    public LongArrayTag() {
    }

    public LongArrayTag(long[] data) {
        this.setData(data);
    }

    public long[] getData() {
        return this.data;
    }

    public void setData(long[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.data = data;
    }

    @Override
    public TagType getType() {
        return TagType.LONG_ARRAY;
    }

    public String toString() {
        return "[" + this.data.length + " longs]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof LongArrayTag)) return false;
        LongArrayTag other = (LongArrayTag)obj;
        if (!Arrays.equals(this.data, other.data)) return false;
        return true;
    }

    @Override
    public LongArrayTag clone() {
        try {
            LongArrayTag clone = (LongArrayTag)super.clone();
            clone.data = (long[])this.data.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone should be supported");
        }
    }
}

