/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bungee.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.bungee.plugin.CubesideUtilsBungee;
import de.iani.cubesideutils.bungee.plugin.PlayerDataImplBungee;
import de.iani.cubesideutils.bungee.plugin.UtilsPluginBungee;
import de.iani.cubesideutils.bungee.plugin.api.GlobalDataHelperBungee;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import java.io.DataInputStream;
import java.io.IOException;

public class UtilsGlobalDataHelperBungee
extends GlobalDataHelperBungee<UtilsGlobalDataHelper.MessageType>
implements UtilsGlobalDataHelper {
    public UtilsGlobalDataHelperBungee(UtilsPluginBungee plugin) {
        super(UtilsGlobalDataHelper.MessageType.class, "UtilsPlugin", plugin);
    }

    @Override
    protected void handleMessage(UtilsGlobalDataHelper.MessageType messageType, GlobalServer source, DataInputStream data) throws IOException {
        switch (messageType) {
            case RANK_INFORMATION_CHANGED: {
                CubesideUtilsBungee.getInstance().updateRankInformation();
                break;
            }
            case GENERAL_DATA_CHANGED: {
                CubesideUtilsBungee.getInstance().getGeneralDataCache().invalidate(data.readUTF());
                break;
            }
            case PLAYER_DATA_CHANGED: {
                CubesideUtilsBungee.getInstance().getPlayerDataCache().invalidate(this.readUUID(data));
                break;
            }
            case CUSTOM_PLAYER_DATA_CHANGED: {
                PlayerDataImplBungee pData = CubesideUtilsBungee.getInstance().getPlayerDataCache().get(this.readUUID(data), false, false);
                if (pData == null) break;
                pData.customDataChanged();
                break;
            }
            case SEND_MESSAGE: {
                break;
            }
        }
    }
}

