/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class MinecraftDataOutputStream
extends DataOutputStream {
    public MinecraftDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeString(String string) throws IOException {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeVarInt(bytes.length);
        this.out.write(bytes);
    }

    public void writeVarInt(int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value);
    }

    public void writeVarLong(long value) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((int)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        this.writeByte((int)value);
    }

    public void writeUuid(UUID uuid) throws IOException {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public void writeText(BaseComponent ... text) throws IOException {
        this.writeString(ComponentSerializer.toString((BaseComponent[])text));
    }
}

