/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin.api;

import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.collections.AdvancedCacheMap;
import de.iani.cubesideutils.plugin.CubesideUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public abstract class PlayerCacheMap<V, D>
extends AdvancedCacheMap<UUID, V, D>
implements Listener {
    public static final long BETWEEN_LOGIN_AND_JOIN_TIMEOUT = 6000L;
    private static final long serialVersionUID = 9162727527421482928L;
    private String valueLoggingName;
    private Set<UUID> joiningPlayers;
    private Map<UUID, Integer> playerJoinTimeoutTasks;

    protected PlayerCacheMap(int maxSoftCacheSize, D defaultData, String valueLoggingName) {
        super(maxSoftCacheSize, defaultData);
        this.valueLoggingName = Objects.requireNonNull(valueLoggingName);
        this.joiningPlayers = new HashSet<UUID>();
        this.playerJoinTimeoutTasks = new HashMap<UUID, Integer>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CubesideUtilsBukkit.getInstance().getPlugin());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void earlyOnPlayerLoginEvent(PlayerLoginEvent event) {
        V value;
        Player player = event.getPlayer();
        this.playerStartsLoggingIn(player);
        UUID playerId = player.getUniqueId();
        try {
            value = this.loadOnLogin(player);
        }
        catch (LoadingPlayerDataFailedException e) {
            CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Could not load " + this.valueLoggingName + " for player " + String.valueOf(playerId) + ".", e);
            CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Denying join for player " + String.valueOf(playerId) + " because of an internal error.");
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, (Component)LegacyComponentSerializer.legacySection().deserialize(e.getKickMessage()));
            return;
        }
        if (value != null) {
            this.joiningPlayers.add(playerId);
            this.addToHardCache(playerId, value);
        }
        this.playerDataLoadedOnLogin(player, value);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void lateOnPlayerLoginEvent(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.playerFinishsLoggingIn(player);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            Bukkit.getScheduler().runTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> {
                if (Bukkit.getPlayer((UUID)playerId) == null) {
                    Object value = this.removeFromHardCache(playerId);
                    this.joiningPlayers.remove(playerId);
                    this.playerDataUnloadedOnSuccesslessLogin(player, value);
                }
            });
            return;
        }
        BukkitScheduler scheduler = Bukkit.getScheduler();
        Integer oldTaskId = this.playerJoinTimeoutTasks.put(playerId, scheduler.scheduleSyncDelayedTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> this.playerDidntJoinInternal(playerId), 6000L));
        if (oldTaskId != null) {
            scheduler.cancelTask(oldTaskId.intValue());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.joiningPlayers.remove(playerId);
        Integer taskId = this.playerJoinTimeoutTasks.remove(playerId);
        if (taskId != null) {
            Bukkit.getScheduler().cancelTask(taskId.intValue());
        } else {
            this.playerJoinedAfterTimeout(player);
        }
    }

    private void playerDidntJoinInternal(UUID playerId) {
        this.joiningPlayers.remove(playerId);
        Integer taskId = this.playerJoinTimeoutTasks.remove(playerId);
        if (taskId == null) {
            return;
        }
        this.playerDidntJoin(playerId);
        Bukkit.getScheduler().runTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> {
            if (Bukkit.getPlayer((UUID)playerId) == null) {
                Object value = this.removeFromHardCache(playerId);
                this.playerDataUnloadedDidntJoin(playerId, value);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void lateOnPlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.playerQuitting(player);
        UUID playerId = player.getUniqueId();
        Bukkit.getScheduler().runTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> {
            if (Bukkit.getPlayer((UUID)playerId) == null && !this.joiningPlayers.contains(playerId)) {
                Object value = this.removeFromHardCache(playerId);
                this.playerDataUnloadedOnQuit(player, value);
            }
        });
    }

    @Override
    protected boolean checkKey(Object key) {
        return key instanceof UUID;
    }

    protected void playerStartsLoggingIn(Player player) {
    }

    protected abstract V loadOnLogin(Player var1) throws LoadingPlayerDataFailedException;

    protected void playerDataLoadedOnLogin(Player player, V value) {
    }

    protected void playerFinishsLoggingIn(Player player) {
    }

    protected void playerDataUnloadedOnSuccesslessLogin(Player player, V value) {
    }

    protected void playerDidntJoin(UUID playerId) {
    }

    protected void playerDataUnloadedDidntJoin(UUID playerId, V value) {
    }

    protected void playerJoinedAfterTimeout(Player player) {
        Bukkit.getScheduler().runTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> player.kick((Component)Component.text((String)"Timeout between login and join."), PlayerKickEvent.Cause.TIMEOUT));
    }

    protected void playerQuitting(Player player) {
    }

    protected void playerDataUnloadedOnQuit(Player player, V value) {
    }

    public static class LoadingPlayerDataFailedException
    extends Exception {
        private static final long serialVersionUID = 4824440510991755719L;
        private String kickMessage;

        public LoadingPlayerDataFailedException(String kickMessage) {
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public LoadingPlayerDataFailedException(String kickMessage, String message, Throwable cause) {
            super(message, cause);
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public LoadingPlayerDataFailedException(String kickMessage, String message) {
            super(message);
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public LoadingPlayerDataFailedException(String kickMessage, Throwable cause) {
            super(cause);
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public String getKickMessage() {
            return this.kickMessage;
        }
    }
}

