/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ComponentUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.chat.ComponentSerializer;

public abstract class ChatUtil {
    private static final Map<ChatColor, Integer> CHATCOLOR_TO_RGB;
    public static final int PAGE_LENGTH = 10;

    protected ChatUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    @Deprecated
    public static Component convertBaseComponent(BaseComponent bc) {
        return GsonComponentSerializer.gson().deserialize((Object)ComponentSerializer.toString((BaseComponent)bc));
    }

    @Deprecated
    public static Component convertBaseComponents(BaseComponent ... bc) {
        return GsonComponentSerializer.gson().deserialize((Object)ComponentSerializer.toString((BaseComponent[])bc));
    }

    @Deprecated
    public static Component convertLegacy(String s) {
        return ComponentUtil.getLegacyComponentSerializer().deserialize(s);
    }

    @Deprecated
    public static Style convertStyle(String colorString) {
        return colorString == null ? Style.empty() : ChatUtil.convertLegacy(colorString).style();
    }

    public static List<Sendable<MessageReceiver>> stringToSendableList(List<String> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<Sendable<MessageReceiver>> componentToSendableList(List<Component> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (Component msg : messages) {
            result.add(new AdventureComponentMsg(msg));
        }
        return result;
    }

    @Deprecated
    public static List<Sendable<MessageReceiver>> bcToSendableList(List<BaseComponent[]> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (BaseComponent[] msg : messages) {
            result.add(new BaseComponentMsg(msg));
        }
        return result;
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, (Component)Component.text((String)name), openPageCommandPrefix);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, new ComponentBuilder(name).create(), openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, ChatUtil.convertBaseComponents(name), openPageCommandPrefix, ChatUtil.convertLegacy(pluginPrefix), ChatUtil.convertStyle(normalColor.toString()), ChatUtil.convertStyle(warningColor.toString()));
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, Component name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, null);
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, Style.style((TextColor)NamedTextColor.GREEN), Style.style((TextColor)NamedTextColor.GOLD));
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix, Style normalStyle, Style warningStyle) {
        try {
            if (page < 0) {
                ChatUtil.sendMessage(recipient, pluginPrefix, warningStyle, "Bitte gib die Seitenzahl als positive ganze Zahl an.");
                return;
            }
            TextComponent prefixComponent = pluginPrefix == null ? Component.empty() : pluginPrefix.append((Component)Component.space());
            int listSize = messages.size();
            int numPages = (int)Math.ceil((double)listSize / 10.0);
            if (page >= numPages && page > 0) {
                Component result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().style(warningStyle)).append((Component)prefixComponent)).append(name)).append((Component)Component.text((String)(" hat keine Seite " + (page + 1))));
                recipient.sendMessage(result);
                return;
            }
            if (!((String)openPageCommandPrefix).startsWith("/")) {
                openPageCommandPrefix = "/" + (String)openPageCommandPrefix;
            }
            if (numPages > 1) {
                result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().style(normalStyle)).append((Component)prefixComponent)).append(name)).append((Component)Component.text((String)(" (Seite " + (page + 1) + "/" + numPages + "):")));
                recipient.sendMessage(result);
            } else {
                result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().style(normalStyle)).append((Component)prefixComponent)).append(name)).append((Component)Component.text((String)":"));
                recipient.sendMessage(result);
            }
            if (listSize == 0) {
                recipient.sendMessage(Component.text((String)" -- keine --").color((TextColor)NamedTextColor.GRAY));
            }
            int index = page * 10;
            for (int i = 0; i < 10 && index < listSize; ++i, ++index) {
                messages.get(index).send(recipient);
            }
            if (numPages > 1) {
                ChatUtil.sendMessage(recipient, pluginPrefix, normalStyle, "Seite x anzeigen: ", openPageCommandPrefix, " x");
                TextComponent prevComponent = Component.text((String)" << vorherige");
                if (page > 0) {
                    prevComponent = prevComponent.color((TextColor)NamedTextColor.BLUE);
                    he = HoverEvent.showText((Component)Component.text((String)("Seite " + page + " anzeigen")));
                    ClickEvent ce = ClickEvent.runCommand((String)((String)openPageCommandPrefix + " " + page));
                    prevComponent = prevComponent.hoverEvent((HoverEventSource)he).clickEvent(ce);
                } else {
                    prevComponent = prevComponent.color((TextColor)NamedTextColor.GRAY);
                    he = HoverEvent.showText((Component)Component.text((String)"Bereits auf Seite 1"));
                    prevComponent = prevComponent.hoverEvent((HoverEventSource)he);
                }
                TextComponent nextComponent = Component.text((String)"n\u00e4chste >>");
                if (page + 1 < numPages) {
                    nextComponent = nextComponent.color((TextColor)NamedTextColor.BLUE);
                    he = HoverEvent.showText((Component)Component.text((String)("Seite " + (page + 2) + " anzeigen")));
                    ClickEvent ce = ClickEvent.runCommand((String)((String)openPageCommandPrefix + " " + (page + 2)));
                    nextComponent = nextComponent.hoverEvent((HoverEventSource)he).clickEvent(ce);
                } else {
                    nextComponent = nextComponent.color((TextColor)NamedTextColor.GRAY);
                    he = HoverEvent.showText((Component)Component.text((String)("Bereits auf Seite " + numPages)));
                    nextComponent = nextComponent.hoverEvent((HoverEventSource)he);
                }
                Component result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)prefixComponent)).append((Component)prevComponent)).append((Component)Component.text((String)"   "))).append((Component)nextComponent);
                recipient.sendMessage(result);
            }
        }
        catch (AbortPageSendException e) {
            return;
        }
    }

    @Deprecated
    public static void sendMessage(MessageReceiver receiver, String pluginPrefix, String colors, Object ... messageParts) {
        ChatUtil.sendMessage(receiver, ChatUtil.convertLegacy(pluginPrefix), ChatUtil.convertStyle(colors), messageParts);
    }

    public static void sendMessage(MessageReceiver receiver, Component pluginPrefix, Style style, Object ... messageParts) {
        Component result = Component.empty().style(style);
        if (pluginPrefix != null) {
            result = result.append(pluginPrefix).append((Component)Component.space());
        }
        if (style != null) {
            result = result.style(style);
        }
        int outdated = 0;
        for (Object s : messageParts) {
            if (s instanceof BaseComponent[]) {
                BaseComponent[] bc = (BaseComponent[])s;
                result = result.append(ChatUtil.convertBaseComponents(bc));
                outdated |= 1;
                continue;
            }
            if (s instanceof BaseComponent) {
                BaseComponent bc = (BaseComponent)s;
                result = result.append(ChatUtil.convertBaseComponent(bc));
                outdated |= 2;
                continue;
            }
            if (s instanceof Component) {
                Component cmp = (Component)s;
                result = result.append(cmp);
                continue;
            }
            String stringObject = Objects.toString(s);
            if (stringObject.contains("\u00a7")) {
                outdated |= 4;
            }
            result = result.append((Component)ComponentUtil.getLegacyComponentSerializer().deserialize(stringObject));
        }
        if (outdated > 0) {
            // empty if block
        }
        receiver.sendMessage(result);
    }

    @Deprecated
    public static Integer toRGB(ChatColor color) {
        String colorString = color.toString();
        if (colorString != null && colorString.length() > 2 && colorString.charAt(1) == 'x') {
            return Integer.parseInt(colorString.substring(2).replace(String.valueOf('\u00a7'), ""), 16);
        }
        return CHATCOLOR_TO_RGB.get(color);
    }

    static {
        HashMap<ChatColor, Integer> chatcolorToColor = new HashMap<ChatColor, Integer>();
        chatcolorToColor.put(ChatColor.BLACK, 0);
        chatcolorToColor.put(ChatColor.DARK_BLUE, 170);
        chatcolorToColor.put(ChatColor.DARK_GREEN, 43520);
        chatcolorToColor.put(ChatColor.DARK_AQUA, 43690);
        chatcolorToColor.put(ChatColor.DARK_RED, 0xAA0000);
        chatcolorToColor.put(ChatColor.DARK_PURPLE, 0xAA00AA);
        chatcolorToColor.put(ChatColor.GOLD, 0xFFAA00);
        chatcolorToColor.put(ChatColor.GRAY, 0xAAAAAA);
        chatcolorToColor.put(ChatColor.DARK_GRAY, 0x555555);
        chatcolorToColor.put(ChatColor.BLUE, 0x5555FF);
        chatcolorToColor.put(ChatColor.GREEN, 0x55FF55);
        chatcolorToColor.put(ChatColor.AQUA, 0x55FFFF);
        chatcolorToColor.put(ChatColor.RED, 0xFF5555);
        chatcolorToColor.put(ChatColor.LIGHT_PURPLE, 0xFF55FF);
        chatcolorToColor.put(ChatColor.YELLOW, 0xFFFF55);
        chatcolorToColor.put(ChatColor.WHITE, 0xFFFFFF);
        CHATCOLOR_TO_RGB = Collections.unmodifiableMap(chatcolorToColor);
    }

    public record StringMsg(String message) implements Sendable<MessageReceiver>
    {
        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public record AdventureComponentMsg(Component message) implements Sendable<MessageReceiver>
    {
        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    @Deprecated
    public static class BaseComponentMsg
    implements Sendable<MessageReceiver> {
        public final BaseComponent[] message;

        public BaseComponentMsg(BaseComponent ... message) {
            this.message = message;
        }

        public BaseComponentMsg(BaseComponent message) {
            this.message = new BaseComponent[]{message};
        }

        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public static interface MessageReceiver {
        public void sendMessage(String var1);

        public void sendMessage(Component var1);

        @Deprecated
        default public void sendMessage(BaseComponent ... message) {
            this.sendMessage(ChatUtil.convertBaseComponents(message));
        }
    }

    public static interface Sendable<T>
    extends Consumer<T> {
        public void send(T var1);

        @Override
        default public void accept(T t) {
            this.send(t);
        }
    }

    public static class AbortPageSendException
    extends RuntimeException {
        private static final long serialVersionUID = -2300346467867854669L;

        public AbortPageSendException() {
        }

        public AbortPageSendException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public AbortPageSendException(String message, Throwable cause) {
            super(message, cause);
        }

        public AbortPageSendException(String message) {
            super(message);
        }

        public AbortPageSendException(Throwable cause) {
            super(cause);
        }
    }

    public static class CachedSendableList<T extends Sendable<S>, S>
    extends AbstractList<T> {
        private IntSupplier sizeGetter;
        private BiFunction<Integer, Integer, List<T>> listFiller;
        private int cacheSize;
        private int cacheStartIndex;
        private List<T> cache;

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller, int cacheSize) {
            this.sizeGetter = sizeGetter;
            this.listFiller = listFiller;
            this.cacheSize = cacheSize;
        }

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller) {
            this(sizeGetter, listFiller, 10);
        }

        @Override
        public T get(int index) {
            int transformedIndex = index - this.cacheStartIndex;
            if (this.cache == null || transformedIndex < 0 || transformedIndex >= this.cacheSize) {
                this.cache = this.listFiller.apply(index, this.cacheSize);
                this.cacheStartIndex = index;
                transformedIndex = 0;
            }
            return (T)((Sendable)this.cache.get(transformedIndex));
        }

        @Override
        public int size() {
            return this.sizeGetter.getAsInt();
        }
    }
}

