/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin.commands;

import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.commands.ArgsParser;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ChangeRankInformationCommand
extends SubCommand {
    public static final String PERMISSION = "cubesideutils.changerankinformation";
    public static final String SET_COMMAND_PATH = "set";
    public static final String REMOVE_COMMAND_PATH = "remove";
    private final boolean set;

    public ChangeRankInformationCommand(boolean set) {
        this.set = set;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) {
        int priority;
        if (!args.hasNext()) {
            return false;
        }
        String rank = args.next();
        if (!this.set) {
            try {
                if (CubesideUtilsBukkit.getInstance().removeRankInformation(rank)) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Rank removed.");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown rank.");
                return true;
            }
            catch (SQLException e) {
                CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Exception trying to remove rank information for rank " + rank + ".", e);
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Ein interner Fehler ist aufgetreten.");
                return true;
            }
        }
        if (!args.hasNext()) {
            return false;
        }
        try {
            priority = Integer.parseInt(args.next());
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Priority must be an integer.");
            return true;
        }
        if (!args.hasNext()) {
            return false;
        }
        String permission = args.next();
        permission = permission.equals("-") ? null : permission;
        String prefix = StringUtil.convertColors(args.getNext(""));
        try {
            CubesideUtilsBukkit.getInstance().setRankInformation(rank, priority, permission, prefix);
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Exception trying to set rank information for rank " + rank + ".", e);
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Ein interner Fehler ist aufgetreten.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Rank information set.");
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        args.getNext(null);
        if (!args.hasNext()) {
            return CubesideUtilsBukkit.getInstance().getRanks();
        }
        return Collections.emptyList();
    }

    @Override
    public String getUsage() {
        return this.set ? "<rank> <piority> <permission | -> [prefix]" : "<rank>";
    }

    public String getPermission() {
        return PERMISSION;
    }
}

