/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.ConnectionAPI;
import de.iani.cubesideutils.Triple;
import de.iani.cubesideutils.collections.SimpleCacheMap;
import de.iani.cubesideutils.conditions.BinaryCombinedCondition;
import de.iani.cubesideutils.conditions.NegatedCondition;
import de.iani.cubesideutils.plugin.GeneralDataCache;
import de.iani.cubesideutils.plugin.PasswordHandlerImpl;
import de.iani.cubesideutils.plugin.PlayerDataImpl;
import de.iani.cubesideutils.plugin.UtilsDatabase;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.plugin.api.PasswordHandler;
import de.iani.cubesideutils.plugin.api.UtilsApi;
import de.iani.cubesideutils.serialization.StringSerialization;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CubesideUtils
implements UtilsApi {
    private static volatile CubesideUtils instance = null;
    private GeneralDataCache generalDataCache;
    private Map<String, PasswordHandlerImpl> passwordHandlers;
    private ReadWriteLock rankLock;
    private List<String> ranks;
    private Map<String, Triple<Integer, String, String>> rankPermissionsAndPrefixes;
    private Map<String, Boolean> cachedRealServers;

    public static CubesideUtils getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubesideUtils() {
        Class<CubesideUtils> clazz = CubesideUtils.class;
        synchronized (CubesideUtils.class) {
            if (instance != null) {
                throw new IllegalStateException("Only one instance permitted.");
            }
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.passwordHandlers = new SimpleCacheMap<String, PasswordHandlerImpl>(16);
            this.rankLock = new ReentrantReadWriteLock();
            this.ranks = Collections.emptyList();
            this.rankPermissionsAndPrefixes = Collections.emptyMap();
            this.cachedRealServers = Collections.synchronizedMap(new HashMap());
            return;
        }
    }

    public void onEnable() {
        try {
            this.generalDataCache = new GeneralDataCache();
            this.onEnableInternal();
            this.updateRankInformation();
        }
        catch (Throwable e) {
            this.getLogger().log(Level.SEVERE, "Could not initilize CubesideUtils plugin.", e);
            this.shutdownServer();
        }
    }

    protected void onEnableInternal() throws Throwable {
    }

    protected abstract void shutdownServer();

    public abstract Logger getLogger();

    public abstract ConnectionAPI getConnectionApi();

    public abstract UtilsDatabase<?> getDatabase();

    public abstract UtilsGlobalDataHelper getGlobalDataHelper();

    public GeneralDataCache getGeneralDataCache() {
        return this.generalDataCache;
    }

    @Override
    public String getGeneralData(String key) throws SQLException {
        return this.generalDataCache.get(key);
    }

    @Override
    public void setGeneralData(String key, String value) throws SQLException {
        this.generalDataCache.set(key, value);
    }

    @Override
    public PasswordHandler getPasswordHandler(String key) {
        return this.passwordHandlers.computeIfAbsent(key, k -> new PasswordHandlerImpl((String)k));
    }

    @Override
    public boolean removePasswordKey(String key) throws SQLException {
        this.passwordHandlers.remove(key);
        return this.getDatabase().removePasswordKey(key);
    }

    @Override
    public List<String> getRanks() {
        this.rankLock.readLock().lock();
        try {
            List<String> list = this.ranks;
            return list;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    @Override
    public String getDefaultRank() {
        this.rankLock.readLock().lock();
        try {
            if (this.ranks.isEmpty()) {
                String string = null;
                return string;
            }
            String string = this.ranks.get(this.ranks.size() - 1);
            return string;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    @Override
    public int getPriority(String rank) {
        this.rankLock.readLock().lock();
        try {
            int n = (Integer)this.rankPermissionsAndPrefixes.get((Object)rank).first;
            return n;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    @Override
    public String getPermission(String rank) {
        this.rankLock.readLock().lock();
        try {
            String string = (String)this.rankPermissionsAndPrefixes.get((Object)rank).second;
            return string;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    @Override
    public String getPrefix(String rank) {
        this.rankLock.readLock().lock();
        try {
            String string = (String)this.rankPermissionsAndPrefixes.get((Object)rank).third;
            return string;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    @Override
    public void setRankInformation(String rank, int priority, String permission, String prefix) throws SQLException {
        this.getDatabase().setRankInformation(rank, priority, permission, prefix);
        this.getGlobalDataHelper().sendData(UtilsGlobalDataHelper.MessageType.RANK_INFORMATION_CHANGED, new Object[0]);
        this.updateRankInformation();
    }

    @Override
    public boolean removeRankInformation(String rank) throws SQLException {
        if (!this.getDatabase().removeRankInformation(rank)) {
            return false;
        }
        this.getGlobalDataHelper().sendData(UtilsGlobalDataHelper.MessageType.RANK_INFORMATION_CHANGED, new Object[0]);
        this.updateRankInformation();
        return true;
    }

    @Override
    public void updateRankInformation() {
        this.rankLock.writeLock().lock();
        try {
            this.rankPermissionsAndPrefixes = Collections.unmodifiableMap(this.getDatabase().getRankInformation());
            this.ranks = Collections.unmodifiableList(new ArrayList<String>(this.rankPermissionsAndPrefixes.keySet()));
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Could not get rank information from database.", e);
        }
        finally {
            this.rankLock.writeLock().unlock();
        }
        for (PlayerDataImpl playerDataImpl : this.getLoadedPlayerData()) {
            playerDataImpl.checkRank();
        }
    }

    protected abstract Iterable<? extends PlayerDataImpl> getLoadedPlayerData();

    @Override
    public Map<String, Boolean> getCachedRealServers() {
        return this.cachedRealServers;
    }

    @Override
    public void sendMessageToPlayersAllServers(String seeMsgPermission, String message) {
        this.getGlobalDataHelper().sendData(UtilsGlobalDataHelper.MessageType.SEND_MESSAGE, seeMsgPermission, (Object)message);
    }

    static {
        StringSerialization.register("BinaryCombinedCondition", BinaryCombinedCondition::deserialize);
        StringSerialization.register("NegatedCondition", NegatedCondition::deserialize);
    }
}

