/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ComponentUtilAdventure;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;

public class ChatUtilAdventure {
    public static final int PAGE_LENGTH = 10;

    protected ChatUtilAdventure() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    @Deprecated
    public static Component convertLegacy(String s) {
        return ComponentUtilAdventure.fromLegacy(s);
    }

    @Deprecated
    public static Style convertStyle(String colorString) {
        return colorString == null ? Style.empty() : ChatUtilAdventure.convertLegacy(colorString).style();
    }

    public static List<Sendable<MessageReceiver>> stringToSendableList(List<String> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<Sendable<MessageReceiver>> componentToSendableList(List<Component> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (Component msg : messages) {
            result.add(new AdventureComponentMsg(msg));
        }
        return result;
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<? super T>> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtilAdventure.sendMessagesPaged(recipient, messages, page, (Component)Component.text((String)name), openPageCommandPrefix);
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<? super T>> messages, int page, Component name, String openPageCommandPrefix) {
        ChatUtilAdventure.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, null);
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<? super T>> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix) {
        ChatUtilAdventure.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, Style.style((TextColor)NamedTextColor.GREEN), Style.style((TextColor)NamedTextColor.GOLD));
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<? super T>> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix, Style normalStyle, Style warningStyle) {
        try {
            if (page < 0) {
                ChatUtilAdventure.sendMessage(recipient, pluginPrefix, warningStyle, "Bitte gib die Seitenzahl als positive ganze Zahl an.");
                return;
            }
            TextComponent prefixComponent = pluginPrefix == null ? Component.empty() : pluginPrefix.append((Component)Component.space());
            int listSize = messages.size();
            int numPages = (int)Math.ceil((double)listSize / 10.0);
            if (page >= numPages && page > 0) {
                Component result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().style(warningStyle)).append((Component)prefixComponent)).append(name)).append((Component)Component.text((String)(" hat keine Seite " + (page + 1))));
                recipient.sendMessage(result);
                return;
            }
            if (!((String)openPageCommandPrefix).startsWith("/")) {
                openPageCommandPrefix = "/" + (String)openPageCommandPrefix;
            }
            if (numPages > 1) {
                result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().style(normalStyle)).append((Component)prefixComponent)).append(name)).append((Component)Component.text((String)(" (Seite " + (page + 1) + "/" + numPages + "):")));
                recipient.sendMessage(result);
            } else {
                result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().style(normalStyle)).append((Component)prefixComponent)).append(name)).append((Component)Component.text((String)":"));
                recipient.sendMessage(result);
            }
            if (listSize == 0) {
                recipient.sendMessage(Component.text((String)" -- keine --").color((TextColor)NamedTextColor.GRAY));
            }
            int index = page * 10;
            for (int i = 0; i < 10 && index < listSize; ++i, ++index) {
                messages.get(index).send(recipient);
            }
            if (numPages > 1) {
                ChatUtilAdventure.sendMessage(recipient, pluginPrefix, normalStyle, "Seite x anzeigen: ", openPageCommandPrefix, " x");
                TextComponent prevComponent = Component.text((String)" << vorherige");
                if (page > 0) {
                    prevComponent = prevComponent.color((TextColor)NamedTextColor.BLUE);
                    he = HoverEvent.showText((Component)Component.text((String)("Seite " + page + " anzeigen")));
                    ClickEvent ce = ClickEvent.runCommand((String)((String)openPageCommandPrefix + " " + page));
                    prevComponent = prevComponent.hoverEvent((HoverEventSource)he).clickEvent(ce);
                } else {
                    prevComponent = prevComponent.color((TextColor)NamedTextColor.GRAY);
                    he = HoverEvent.showText((Component)Component.text((String)"Bereits auf Seite 1"));
                    prevComponent = prevComponent.hoverEvent((HoverEventSource)he);
                }
                TextComponent nextComponent = Component.text((String)"n\u00e4chste >>");
                if (page + 1 < numPages) {
                    nextComponent = nextComponent.color((TextColor)NamedTextColor.BLUE);
                    he = HoverEvent.showText((Component)Component.text((String)("Seite " + (page + 2) + " anzeigen")));
                    ClickEvent ce = ClickEvent.runCommand((String)((String)openPageCommandPrefix + " " + (page + 2)));
                    nextComponent = nextComponent.hoverEvent((HoverEventSource)he).clickEvent(ce);
                } else {
                    nextComponent = nextComponent.color((TextColor)NamedTextColor.GRAY);
                    he = HoverEvent.showText((Component)Component.text((String)("Bereits auf Seite " + numPages)));
                    nextComponent = nextComponent.hoverEvent((HoverEventSource)he);
                }
                Component result = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)prefixComponent)).append((Component)prevComponent)).append((Component)Component.text((String)"   "))).append((Component)nextComponent);
                recipient.sendMessage(result);
            }
        }
        catch (AbortPageSendException e) {
            return;
        }
    }

    public static void sendMessage(MessageReceiver receiver, Component pluginPrefix, Style style, Object ... messageParts) {
        Component result = Component.empty().style(style);
        if (pluginPrefix != null) {
            result = result.append(pluginPrefix).append((Component)Component.space());
        }
        if (style != null) {
            result = result.style(style);
        }
        for (Object s : messageParts) {
            if (s instanceof Component) {
                Component cmp = (Component)s;
                result = result.append(cmp);
                continue;
            }
            String stringObject = Objects.toString(s);
            result = result.append((Component)ComponentUtilAdventure.fromLegacy(stringObject));
        }
        receiver.sendMessage(result);
    }

    public record StringMsg(String message) implements Sendable<MessageReceiver>
    {
        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public record AdventureComponentMsg(Component message) implements Sendable<MessageReceiver>
    {
        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public static interface MessageReceiver {
        public void sendMessage(String var1);

        public void sendMessage(Component var1);
    }

    public static interface Sendable<T>
    extends Consumer<T> {
        public void send(T var1);

        @Override
        default public void accept(T t) {
            this.send(t);
        }
    }

    public static class AbortPageSendException
    extends RuntimeException {
        private static final long serialVersionUID = -2300346467867854669L;

        public AbortPageSendException() {
        }

        public AbortPageSendException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public AbortPageSendException(String message, Throwable cause) {
            super(message, cause);
        }

        public AbortPageSendException(String message) {
            super(message);
        }

        public AbortPageSendException(Throwable cause) {
            super(cause);
        }
    }

    public static class CachedSendableList<T extends Sendable<S>, S>
    extends AbstractList<T> {
        private IntSupplier sizeGetter;
        private BiFunction<Integer, Integer, List<T>> listFiller;
        private int cacheSize;
        private int cacheStartIndex;
        private List<T> cache;

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller, int cacheSize) {
            this.sizeGetter = sizeGetter;
            this.listFiller = listFiller;
            this.cacheSize = cacheSize;
        }

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller) {
            this(sizeGetter, listFiller, 10);
        }

        @Override
        public T get(int index) {
            int transformedIndex = index - this.cacheStartIndex;
            if (this.cache == null || transformedIndex < 0 || transformedIndex >= this.cacheSize) {
                this.cache = this.listFiller.apply(index, this.cacheSize);
                this.cacheStartIndex = index;
                transformedIndex = 0;
            }
            return (T)((Sendable)this.cache.get(transformedIndex));
        }

        @Override
        public int size() {
            return this.sizeGetter.getAsInt();
        }
    }
}

