/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.iani.cubesideutils.plugin.MessageType;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

class GeneralDataCache {
    private UtilsPlugin plugin = UtilsPlugin.getInstance();
    private Map<String, String> cache = new HashMap<String, String>();

    GeneralDataCache() {
    }

    synchronized String get(String key) throws SQLException {
        try {
            return this.cache.computeIfAbsent(key, k -> {
                try {
                    return this.plugin.getDatabase().getGeneralData((String)k);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    synchronized void set(String key, String value) throws SQLException {
        this.plugin.getDatabase().setGeneralData(key, value);
        this.plugin.getGlobalDataHelper().sendData(MessageType.GENERAL_DATA_CHANGED, key);
        this.cache.put(key, value);
    }

    synchronized void invalidate(String key) {
        this.cache.remove(key);
    }
}

