/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ChatUtil {
    public static final Map<ChatColor, Integer> CHATCOLOR_TO_RGB;
    public static final int PAGE_LENGTH = 10;

    private ChatUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static List<Sendable> stringToSendableList(List<String> msges) {
        ArrayList<Sendable> result = new ArrayList<Sendable>(msges.size());
        for (String msg : msges) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<Sendable> bcToSendableList(List<BaseComponent[]> msges) {
        ArrayList<Sendable> result = new ArrayList<Sendable>(msges.size());
        for (BaseComponent[] msg : msges) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends Sendable> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends Sendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends Sendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        if (page < 0) {
            ChatUtil.sendMessage(recipient, pluginPrefix, warningColor.toString(), "Bitte gib die Seitenzahl als positive ganze Zahl an.", new Object[0]);
            return;
        }
        int listSize = messages.size();
        int numPages = (int)Math.ceil((double)listSize / 10.0);
        if (page >= numPages && page > 0) {
            ChatUtil.sendMessage(recipient, pluginPrefix, warningColor.toString(), name, " hat keine Seite ", page + 1);
            return;
        }
        if (!((String)openPageCommandPrefix).startsWith("/")) {
            openPageCommandPrefix = "/" + (String)openPageCommandPrefix;
        }
        if (numPages > 1) {
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), name, " (Seite ", page + 1, "/", numPages, "):");
        } else {
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), name, ":");
        }
        if (listSize == 0) {
            recipient.sendMessage(net.md_5.bungee.api.ChatColor.GRAY + " -- keine --");
        }
        int index = page * 10;
        for (int i = 0; i < 10 && index < listSize; ++i, ++index) {
            messages.get(index).send(recipient);
        }
        if (numPages > 1) {
            ClickEvent ce;
            HoverEvent he;
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), "Seite x anzeigen: ", openPageCommandPrefix, " x");
            ComponentBuilder builder = new ComponentBuilder(pluginPrefix).append(" << vorherige");
            if (page > 0) {
                builder.color(net.md_5.bungee.api.ChatColor.BLUE);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Seite " + page + " anzeigen").create());
                ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)openPageCommandPrefix + " " + page);
                builder.event(he).event(ce);
            } else {
                builder.color(net.md_5.bungee.api.ChatColor.GRAY);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Bereits auf Seite 1").create());
                builder.event(he);
            }
            builder.append("   ").reset().append("n\u00e4chste >>");
            if (page + 1 < numPages) {
                builder.color(net.md_5.bungee.api.ChatColor.BLUE);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Seite " + (page + 2) + " anzeigen").create());
                ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)openPageCommandPrefix + " " + (page + 2));
                builder.event(he).event(ce);
            } else {
                builder.color(net.md_5.bungee.api.ChatColor.GRAY);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Bereits auf Seite " + numPages).create());
                builder.event(he);
            }
            recipient.sendMessage(builder.create());
        }
    }

    public static void sendMessage(CommandSender sender, String pluginPrefix, String colors, Object message, Object ... messageParts) {
        if (messageParts.length == 0) {
            sender.sendMessage(pluginPrefix + " " + (colors == null ? "" : colors) + message);
        } else {
            StringBuilder builder = new StringBuilder(pluginPrefix).append(" ").append(colors == null ? "" : colors).append(message);
            for (Object s : messageParts) {
                if (colors != null) {
                    builder.append(net.md_5.bungee.api.ChatColor.RESET).append(colors);
                }
                builder.append(Objects.toString(s));
            }
            sender.sendMessage(builder.toString());
        }
    }

    public static Integer toRGB(ChatColor color) {
        return CHATCOLOR_TO_RGB.get(color);
    }

    static {
        EnumMap<ChatColor, Integer> chatcolorToColor = new EnumMap<ChatColor, Integer>(ChatColor.class);
        chatcolorToColor.put(ChatColor.BLACK, 0);
        chatcolorToColor.put(ChatColor.DARK_BLUE, 170);
        chatcolorToColor.put(ChatColor.DARK_GREEN, 43520);
        chatcolorToColor.put(ChatColor.DARK_AQUA, 43690);
        chatcolorToColor.put(ChatColor.DARK_RED, 0xAA0000);
        chatcolorToColor.put(ChatColor.DARK_PURPLE, 0xAA00AA);
        chatcolorToColor.put(ChatColor.GOLD, 0xFFAA00);
        chatcolorToColor.put(ChatColor.GRAY, 0xAAAAAA);
        chatcolorToColor.put(ChatColor.DARK_GRAY, 0x555555);
        chatcolorToColor.put(ChatColor.BLUE, 0x5555FF);
        chatcolorToColor.put(ChatColor.GREEN, 0x55FF55);
        chatcolorToColor.put(ChatColor.AQUA, 0x55FFFF);
        chatcolorToColor.put(ChatColor.RED, 0xFF5555);
        chatcolorToColor.put(ChatColor.LIGHT_PURPLE, 0xFF55FF);
        chatcolorToColor.put(ChatColor.YELLOW, 0xFFFF55);
        chatcolorToColor.put(ChatColor.WHITE, 0xFFFFFF);
        CHATCOLOR_TO_RGB = Collections.unmodifiableMap(chatcolorToColor);
    }

    public static class CachedSendableList<T extends Sendable>
    extends AbstractList<T> {
        private IntSupplier sizeGetter;
        private BiFunction<Integer, Integer, List<T>> listFiller;
        private int cacheSize;
        private int cacheStartIndex;
        private List<T> cache;

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller, int cacheSize) {
            this.sizeGetter = sizeGetter;
            this.listFiller = listFiller;
            this.cacheSize = cacheSize;
        }

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller) {
            this(sizeGetter, listFiller, 10);
        }

        @Override
        public T get(int index) {
            int transformedIndex = index - this.cacheStartIndex;
            if (this.cache == null || transformedIndex < 0 || transformedIndex >= this.cacheSize) {
                this.cache = this.listFiller.apply(index, this.cacheSize);
                this.cacheStartIndex = index;
                transformedIndex = 0;
            }
            return (T)((Sendable)this.cache.get(transformedIndex));
        }

        @Override
        public int size() {
            return this.sizeGetter.getAsInt();
        }
    }

    public static class ComponentMsg
    implements Sendable {
        public final BaseComponent[] msg;

        public ComponentMsg(BaseComponent[] msg) {
            this.msg = msg;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.msg);
        }
    }

    public static class StringMsg
    implements Sendable {
        public final String msg;

        public StringMsg(String msg) {
            this.msg = msg;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.msg);
        }
    }

    public static interface Sendable {
        public void send(CommandSender var1);
    }
}

