/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.commands;

import com.google.common.base.Objects;
import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.commands.PermissionRequirer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractCommandRouter<ControllerT extends PermissionRequirer, HandlerT> {
    private final CommandMap commands = new CommandMap(null, null);
    private final boolean caseInsensitive;

    public AbstractCommandRouter(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void addCommandMapping(ControllerT command, String ... route) {
        if (route.length == 1) {
            if (route[0].isEmpty()) {
                this.addCommandMapping(command, new String[0]);
                return;
            }
            if (route[0].contains(" ")) {
                this.addCommandMapping(command, route[0].split(" "));
                return;
            }
        }
        CommandMap current = this.commands;
        for (int i = 0; i < route.length; ++i) {
            String routePart;
            CommandMap part;
            if (current.subCommands == null) {
                current.subCommands = new HashMap();
                current.subcommandsOrdered = new ArrayList();
            }
            if ((part = current.subCommands.get(routePart = this.toLowerCaseIfCaseInsensitive(route[i]))) == null) {
                part = new CommandMap(current, routePart);
                current.subCommands.put(routePart, part);
                current.subcommandsOrdered.add(part);
                this.onSubCommandsModified(current);
            }
            current = part;
        }
        if (current.executor != null) {
            throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is already mapped!");
        }
        current.executor = command;
        this.onSubCommandsModified(current);
    }

    public void addAliases(String[] aliases, String ... route) {
        for (String alias : aliases) {
            this.addAlias(alias, route);
        }
    }

    public void addAliases(Iterable<String> aliases, String ... route) {
        for (String alias : aliases) {
            this.addAlias(alias, route);
        }
    }

    public void addAlias(String alias, String ... route) {
        if (route.length == 0) {
            throw new IllegalArgumentException("Route may not be empty!");
        }
        if (route.length == 1 && route[0].contains(" ")) {
            this.addAlias(alias, route[0].split(" "));
            return;
        }
        alias = this.toLowerCaseIfCaseInsensitive(alias);
        CommandMap current = this.commands;
        for (int i = 0; i < route.length - 1; ++i) {
            if (current.subCommands == null) {
                throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is not mapped!");
            }
            String routePart = this.toLowerCaseIfCaseInsensitive(route[i]);
            CommandMap part = current.subCommands.get(routePart);
            if (part == null) {
                throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is not mapped!");
            }
            current = part;
        }
        CommandMap createAliasFor = current.subCommands.get(this.toLowerCaseIfCaseInsensitive(route[route.length - 1]));
        if (createAliasFor == null) {
            throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is not mapped!");
        }
        if (current.subCommands.get(alias) != null) {
            route = (String[])route.clone();
            route[route.length - 1] = alias;
            throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is already mapped!");
        }
        current.subCommands.put(alias, createAliasFor);
        this.onSubCommandsModified(current);
    }

    public ControllerT getSubCommand(String path) {
        String[] args = path.split(" ");
        CommandMap currentMap = this.commands;
        int nr = 0;
        while (currentMap != null) {
            CommandMap subMap;
            String currentCmdPart;
            String string = currentCmdPart = args.length > nr ? args[nr] : null;
            if (currentCmdPart != null) {
                currentCmdPart = this.toLowerCaseIfCaseInsensitive(currentCmdPart);
            }
            if (currentCmdPart != null && currentMap.subCommands != null && (subMap = currentMap.subCommands.get(currentCmdPart)) != null) {
                ++nr;
                currentMap = subMap;
                continue;
            }
            Object toExecute = currentMap.executor;
            if (toExecute != null) {
                return toExecute;
            }
            return null;
        }
        return null;
    }

    protected Pair<CommandMap, Integer> matchCommandMap(HandlerT handler, String[] args) {
        return this.matchCommandMap(handler, args, 0);
    }

    protected Pair<CommandMap, Integer> matchCommandMap(HandlerT handler, String[] args, int ignoredLastArgs) {
        CommandMap currentMap = this.commands;
        int nr = 0;
        while (true) {
            CommandMap subMap;
            String currentCmdPart;
            String string = currentCmdPart = args.length - ignoredLastArgs > nr ? args[nr] : null;
            if (currentCmdPart != null) {
                currentCmdPart = this.toLowerCaseIfCaseInsensitive(currentCmdPart);
            }
            if (currentCmdPart == null || currentMap.subCommands == null || (subMap = currentMap.subCommands.get(currentCmdPart)) == null || subMap.requiredPermissions != null && !this.hasAnyPermission(handler, subMap.requiredPermissions)) break;
            ++nr;
            currentMap = subMap;
        }
        return new Pair<CommandMap, Integer>(currentMap, nr);
    }

    protected abstract boolean hasAnyPermission(HandlerT var1, Set<String> var2);

    protected void onSubCommandsModified(CommandMap map) {
        HashSet<String> requiredPermissions = null;
        if (map.executor != null) {
            String requiredPermission = map.executor.getRequiredPermission();
            if (requiredPermission == null) {
                if (map.requiredPermissions != null) {
                    map.requiredPermissions = null;
                    if (map.parent != null) {
                        this.onSubCommandsModified(map.parent);
                    }
                }
                return;
            }
            requiredPermissions = new HashSet<String>();
            requiredPermissions.add(requiredPermission);
        }
        if (map.subcommandsOrdered != null) {
            for (CommandMap subMap : map.subcommandsOrdered) {
                if (subMap.requiredPermissions == null) {
                    if (map.requiredPermissions != null) {
                        map.requiredPermissions = null;
                        if (map.parent != null) {
                            this.onSubCommandsModified(map.parent);
                        }
                    }
                    return;
                }
                if (requiredPermissions == null) {
                    requiredPermissions = new HashSet();
                }
                requiredPermissions.addAll(subMap.requiredPermissions);
            }
        }
        if (!Objects.equal(map.requiredPermissions, requiredPermissions)) {
            map.requiredPermissions = requiredPermissions;
            if (map.parent != null) {
                this.onSubCommandsModified(map.parent);
            }
        }
    }

    protected String toLowerCaseIfCaseInsensitive(String s) {
        return this.caseInsensitive ? s.toLowerCase(Locale.US) : s;
    }

    protected class CommandMap {
        protected String name;
        protected CommandMap parent;
        protected HashMap<String, CommandMap> subCommands;
        protected ArrayList<CommandMap> subcommandsOrdered;
        protected ControllerT executor;
        protected HashSet<String> requiredPermissions;

        public CommandMap(CommandMap parent, String name) {
            this.parent = parent;
            this.name = name;
        }
    }
}

