/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.PlayerMessageAPI;
import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.plugin.AfkManager;
import de.iani.cubesideutils.plugin.Database;
import de.iani.cubesideutils.plugin.OnlinePlayerData;
import de.iani.cubesideutils.plugin.PlayerData;
import de.iani.cubesideutils.plugin.PlayerDataCache;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.sql.SQLConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class UtilsPlugin
extends JavaPlugin {
    public static final long AFK_THRESHOLD = 120000L;
    public static final String MODIFY_RANKS_PERMISSION = "cubesideutils.modify_ranks";
    private static UtilsPlugin instance = null;
    private Database database;
    private PlayerDataCache playerDataCache;
    private AfkManager afkManager;
    private ConnectionAPI connectionApi;
    private PlayerMessageAPI playerMsgApi;
    private UtilsGlobalDataHelper globalDataHelper;
    private ReadWriteLock rankLock;
    private List<String> ranks;
    private Map<String, Pair<String, String>> rankPermissionsAndPrefixes;

    public static synchronized UtilsPlugin getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UtilsPlugin() {
        Class<UtilsPlugin> clazz = UtilsPlugin.class;
        synchronized (UtilsPlugin.class) {
            if (instance != null) {
                throw new IllegalStateException("Only one instance permitted.");
            }
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.rankLock = new ReentrantReadWriteLock();
            this.ranks = Collections.emptyList();
            this.rankPermissionsAndPrefixes = Collections.emptyMap();
            return;
        }
    }

    public void onEnable() {
        try {
            this.database = new Database();
            this.playerDataCache = new PlayerDataCache();
            this.afkManager = new AfkManager();
            GlobalClientPlugin connectionPlugin = (GlobalClientPlugin)JavaPlugin.getPlugin(GlobalClientPlugin.class);
            this.connectionApi = connectionPlugin.getConnectionAPI();
            this.playerMsgApi = connectionPlugin.getMessageAPI();
            this.globalDataHelper = new UtilsGlobalDataHelper(this);
        }
        catch (Throwable e) {
            this.getLogger().log(Level.SEVERE, "Could not initilize CubesideUtils plugin.", e);
            Bukkit.getServer().shutdown();
        }
        this.updateRankInformation();
    }

    SQLConfig getSQLConfig() {
        return new SQLConfig(this.getConfig().getConfigurationSection("database"));
    }

    Database getDatabase() {
        return this.database;
    }

    PlayerDataCache getPlayerDataCache() {
        return this.playerDataCache;
    }

    ConnectionAPI getConnectionAPI() {
        return this.connectionApi;
    }

    PlayerMessageAPI getPlayerMsgApi() {
        return this.playerMsgApi;
    }

    UtilsGlobalDataHelper getGlobalDataHelper() {
        return this.globalDataHelper;
    }

    public OnlinePlayerData getPlayerData(Player player) {
        return this.getPlayerData(player).getOnlineData();
    }

    public PlayerData getPlayerData(OfflinePlayer player) {
        return this.getPlayerData(player.getUniqueId());
    }

    public PlayerData getPlayerData(UUID playerId) {
        return this.playerDataCache.get(playerId);
    }

    @Deprecated
    public PlayerData getPlayerDataTemp(UUID playerId, boolean insertIfMissing) {
        return this.playerDataCache.get(playerId, true);
    }

    public List<String> getRanks() {
        this.rankLock.readLock().lock();
        try {
            List<String> list = this.ranks;
            return list;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    String getDefaultRank() {
        this.rankLock.readLock().lock();
        try {
            if (this.ranks.isEmpty()) {
                String string = null;
                return string;
            }
            String string = this.ranks.get(this.ranks.size() - 1);
            return string;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    public String getPermission(String rank) {
        this.rankLock.readLock().lock();
        try {
            String string = (String)this.rankPermissionsAndPrefixes.get((Object)rank).first;
            return string;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    public String getPrefix(String rank) {
        this.rankLock.readLock().lock();
        try {
            String string = (String)this.rankPermissionsAndPrefixes.get((Object)rank).second;
            return string;
        }
        finally {
            this.rankLock.readLock().unlock();
        }
    }

    void updateRankInformation() {
        this.rankLock.writeLock().lock();
        try {
            this.rankPermissionsAndPrefixes = Collections.unmodifiableMap(this.database.getRankInformation());
            this.ranks = Collections.unmodifiableList(new ArrayList<String>(this.rankPermissionsAndPrefixes.keySet()));
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Could not get rank information from database.", e);
        }
        finally {
            this.rankLock.writeLock().unlock();
        }
        for (PlayerData data : this.playerDataCache.loadedData()) {
            data.checkRank();
        }
    }
}

