/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.iani.cubesideutils.plugin.OnlinePlayerData;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

class AfkManager
implements Listener {
    private static final int AFK_CHECK_BINS = 50;
    private UtilsPlugin plugin = UtilsPlugin.getInstance();
    private Set<Player>[] onlinePlayers = new Set[50];
    private int currentTick;

    public AfkManager() {
        for (int i = 0; i < 50; ++i) {
            this.onlinePlayers[i] = new LinkedHashSet<Player>();
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, this::tick, 10L, 1L);
    }

    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        this.onlinePlayers[Math.floorMod(event.getPlayer().getUniqueId().hashCode(), 50)].add(event.getPlayer());
    }

    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        this.onlinePlayers[Math.floorMod(event.getPlayer().getUniqueId().hashCode(), 50)].remove(event.getPlayer());
    }

    private void tick() {
        for (Player player : this.onlinePlayers[this.currentTick % 50]) {
            OnlinePlayerData data = this.plugin.getPlayerData(player);
            data.checkAfk();
        }
        ++this.currentTick;
    }
}

