/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.collections.ArrayUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;

public class StringUtil {
    public static final ToIntFunction<String> CASE_IGNORING_HASHER = s -> {
        if (s == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            hash = 31 * hash + Character.toLowerCase((int)c);
        }
        return hash;
    };
    public static final BiPredicate<String, String> CASE_IGNORING_EQUALITY = (s1, s2) -> s1 == null ? s2 == null : s1.equalsIgnoreCase((String)s2);
    public static final ToIntFunction<String> CASE_AND_COLORS_IGNORING_HASHER = s -> {
        if (s == null) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u00a7' && i + 1 < s.length() && ChatColor.getByChar((char)s.charAt(i + 1)) != null) {
                ++i;
                continue;
            }
            hash = 31 * hash + Character.toLowerCase((int)c);
        }
        return hash;
    };
    public static final BiPredicate<String, String> CASE_AND_COLORS_IGNORING_EQUALITY = (s1, s2) -> {
        if (s2 == null) {
            return false;
        }
        s1 = ChatColor.stripColor((String)s1);
        s2 = ChatColor.stripColor((String)s2);
        return s1.equalsIgnoreCase((String)s2);
    };
    public static final Set<String> TRUE_STRINGS;
    public static final Set<String> FALSE_STRINGS;
    public static final Pattern SPACES_AND_UNDERSCORES_PATTERN;
    private static final Pattern PIPE_PATTERN;
    private static final Pattern REMOVE_PIPE_PATTERN;
    private static final Pattern AND_PATTERN;
    private static final Pattern COLOR_CHAR_PATTERN;
    private static final Pattern ESCAPE_CHARACTER_PATTERN;
    public static final Pattern MATCH_COLOR_CODES;
    private static final Set<Character> CHARS_ILLEGAL_IN_FILENAME;
    private static final NavigableMap<Integer, String> ROMAN_NUMBER_MAP;
    public static final String DATE_FORMAT_STRING = "dd.MM.yyyy";
    public static final String TIME_FORMAT_STRING = "HH:mm";
    public static final String TIME_SECONDS_FORMAT_STRING = "HH:mm:ss";
    public static final String DATE_AND_TIME_FORMAT_STRING = "dd.MM.yyyy HH:mm";
    public static final String DATE_AND_TIME_SECONDS_FORMAT_STRING = "dd.MM.yyyy HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat dateFormat;
    private static final DateFormat timeFormat;
    private static final DateFormat timeSecondsFormat;
    private static final DateFormat timestampFormat;
    private static final Map<Color, String> CONSTANT_COLOR_NAMES;
    private static final Map<String, Color> CONSTANT_COLORS_BY_NAMES;

    private StringUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static String capitalizeFirstLetter(String s, boolean replaceUnderscores) {
        char[] cap = s.toCharArray();
        boolean lastSpace = true;
        for (int i = 0; i < cap.length; ++i) {
            char c = cap[i];
            if (c == '_') {
                if (replaceUnderscores) {
                    c = ' ';
                }
                lastSpace = true;
            } else if (c >= '0' && c <= '9' || c == '(' || c == ')') {
                lastSpace = true;
            } else {
                c = lastSpace ? Character.toUpperCase(c) : Character.toLowerCase(c);
                lastSpace = false;
            }
            cap[i] = c;
        }
        return new String(cap);
    }

    public static String replaceLast(String in, String sequence, String replacement) {
        int index = in.lastIndexOf(sequence);
        if (index < 0) {
            return in;
        }
        return in.substring(0, index) + replacement + in.substring(index + sequence.length(), in.length());
    }

    public static String repeat(String arg, int times) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(arg);
        }
        return builder.toString();
    }

    public static String exceptionToString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String formatBlockLocationWithoutWorld(Location loc) {
        return loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String convertColors(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char next;
            char current = text.charAt(i);
            if (current == '&' && i + 1 < len && (ChatColor.getByChar((char)(next = text.charAt(i + 1))) != null || next == '&')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(text, 0, i);
                }
                ++i;
                if (next != '&') {
                    builder.append('\u00a7').append(next);
                    continue;
                }
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }

    public static Pair<String, String> splitAtPipe(String args) {
        Matcher matcher = PIPE_PATTERN.matcher(args);
        if (!matcher.find()) {
            return null;
        }
        int splitIndex = matcher.start();
        String first = args.substring(0, splitIndex);
        String second = args.substring(splitIndex + 3);
        first = REMOVE_PIPE_PATTERN.matcher(first).replaceAll("$1");
        second = REMOVE_PIPE_PATTERN.matcher(second).replaceAll("$1");
        return new Pair<String, String>(first, second);
    }

    public static String revertColors(String converted) {
        if (converted == null) {
            return null;
        }
        return COLOR_CHAR_PATTERN.matcher(AND_PATTERN.matcher(converted).replaceAll("&&")).replaceAll("&");
    }

    public static String convertEscaped(String text) {
        Matcher matcher = ESCAPE_CHARACTER_PATTERN.matcher(text);
        StringBuffer buffer = null;
        while (matcher.find()) {
            String replacement;
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            char escaped = matcher.group().charAt(1);
            switch (escaped) {
                case '\\': {
                    replacement = "\\\\";
                    break;
                }
                case 'n': {
                    replacement = "\n";
                    break;
                }
                default: {
                    replacement = String.valueOf(escaped);
                }
            }
            matcher.appendReplacement(buffer, replacement);
        }
        if (buffer == null) {
            return text;
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES);
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength, boolean forceLineBreak) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES, forceLineBreak);
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength, boolean forceLineBreak, boolean preserveColorCodes) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES, forceLineBreak, preserveColorCodes);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength) {
        return StringUtil.breakLines(text, lineLength, ignoreForLength, false);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength, boolean forceLineBreak) {
        return StringUtil.breakLines(text, lineLength, ignoreForLength, forceLineBreak, ignoreForLength == MATCH_COLOR_CODES);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength, boolean forceLineBreak, boolean preserveColorCodes) {
        if (lineLength <= 0) {
            throw new IllegalArgumentException("lineLength must be positive");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentBuilder = new StringBuilder();
        char[] chars = text.toCharArray();
        int index = 0;
        int lastBlank = -1;
        int lastBreak = 0;
        boolean magic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean italic = false;
        ChatColor color = null;
        int currentPrefixLength = 0;
        while (index < chars.length) {
            char next;
            ChatColor col;
            char current = chars[index];
            if (current == ' ') {
                lastBlank = index;
            } else if (preserveColorCodes && current == '\u00a7' && index + 1 < chars.length && (col = ChatColor.getByChar((char)(next = chars[index + 1]))) != null) {
                switch (col) {
                    case MAGIC: {
                        magic = true;
                        break;
                    }
                    case BOLD: {
                        bold = true;
                        break;
                    }
                    case STRIKETHROUGH: {
                        strikethrough = true;
                        break;
                    }
                    case UNDERLINE: {
                        underline = true;
                        break;
                    }
                    case ITALIC: {
                        italic = true;
                        break;
                    }
                    default: {
                        color = col == ChatColor.RESET ? null : col;
                        magic = false;
                        bold = false;
                        strikethrough = false;
                        underline = false;
                        italic = false;
                    }
                }
            }
            currentBuilder.append(current);
            if (StringUtil.tooLong(currentBuilder.toString(), lineLength, ignoreForLength)) {
                if (lastBlank > lastBreak) {
                    int start = lastBlank + currentPrefixLength - lastBreak;
                    int end = currentBuilder.length();
                    currentBuilder.delete(start, end);
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    if (preserveColorCodes) {
                        currentPrefixLength = StringUtil.addColorCodes(currentBuilder, magic, bold, strikethrough, underline, italic, color);
                    }
                    lastBreak = index = lastBlank + 1;
                    continue;
                }
                if (forceLineBreak && index != lastBreak) {
                    currentBuilder.delete(currentBuilder.length() - 1, currentBuilder.length());
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    if (preserveColorCodes) {
                        currentPrefixLength = StringUtil.addColorCodes(currentBuilder, magic, bold, strikethrough, underline, italic, color);
                    }
                    lastBreak = index;
                    continue;
                }
            }
            ++index;
        }
        if (currentBuilder.length() > 0) {
            result.add(currentBuilder.toString());
        }
        return result;
    }

    private static boolean tooLong(String string, int limit, Pattern ignoreForLength) {
        string = ignoreForLength == null ? string : ignoreForLength.matcher(string).replaceAll("");
        return string.length() > limit;
    }

    private static int addColorCodes(StringBuilder builder, boolean magic, boolean bold, boolean strikethrough, boolean underline, boolean italic, ChatColor color) {
        int length = 0;
        if (color != null) {
            builder.append(color);
            length += 2;
        }
        if (magic) {
            builder.append(ChatColor.MAGIC);
            length += 2;
        }
        if (bold) {
            builder.append(ChatColor.BOLD);
            length += 2;
        }
        if (strikethrough) {
            builder.append(ChatColor.STRIKETHROUGH);
            length += 2;
        }
        if (underline) {
            builder.append(ChatColor.UNDERLINE);
            length += 2;
        }
        if (italic) {
            builder.append(ChatColor.ITALIC);
            length += 2;
        }
        return length;
    }

    public static boolean isSafeFilename(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!CHARS_ILLEGAL_IN_FILENAME.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalCommandName(String name) {
        return !name.contains(" ");
    }

    public static String toRomanNumber(int arg) {
        int i = ROMAN_NUMBER_MAP.floorKey(arg);
        if (arg == i) {
            return (String)ROMAN_NUMBER_MAP.get(arg);
        }
        return (String)ROMAN_NUMBER_MAP.get(i) + StringUtil.toRomanNumber(arg - i);
    }

    public static String formatTimespan(long ms) {
        return StringUtil.formatTimespan(ms, "d", "h", "m", "s", "", "");
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter) {
        return StringUtil.formatTimespan(ms, d, h, m, s, delimiter, lastDelimiter, true);
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter, boolean dropAllLowerIfZero) {
        return StringUtil.formatTimespan(ms, d, h, m, s, delimiter, lastDelimiter, dropAllLowerIfZero, false);
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter, boolean dropAllLowerIfZero, boolean forceMinutesAndTwoDigitsForTime) {
        String result;
        long days = ms / 86400000L;
        long hours = (ms -= days * 86400000L) / 3600000L;
        long minutes = (ms -= hours * 3600000L) / 60000L;
        long seconds = (ms -= minutes * 60000L) / 1000L;
        double lessThanSeconds = (double)(ms -= seconds * 1000L) / 1000.0;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        boolean allNext = false;
        if (days != 0L) {
            first = false;
            allNext = !dropAllLowerIfZero;
            builder.append(days);
            builder.append(d);
        }
        if (allNext || hours != 0L) {
            if (!first) {
                if (allNext || minutes != 0L || seconds != 0L || lessThanSeconds != 0.0) {
                    builder.append(delimiter);
                } else {
                    builder.append(lastDelimiter);
                }
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && hours < 10L) {
                builder.append('0');
            }
            builder.append(hours);
            builder.append(h);
        }
        if (allNext || forceMinutesAndTwoDigitsForTime || minutes != 0L) {
            if (!first) {
                if (allNext || seconds != 0L || lessThanSeconds != 0.0) {
                    builder.append(delimiter);
                } else {
                    builder.append(lastDelimiter);
                }
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && minutes < 10L) {
                builder.append('0');
            }
            builder.append(minutes);
            builder.append(m);
        }
        if (allNext || seconds != 0L || lessThanSeconds != 0.0) {
            if (!first) {
                builder.append(lastDelimiter);
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && seconds < 10L) {
                builder.append('0');
            }
            builder.append(seconds);
            if (lessThanSeconds != 0.0) {
                builder.append(".");
                String lessThanSecondsString = "" + lessThanSeconds;
                lessThanSecondsString = lessThanSecondsString.substring(lessThanSecondsString.indexOf(46) + 1);
                builder.append(lessThanSecondsString);
            }
            builder.append(s);
        }
        if (!(result = builder.toString().trim()).equals("")) {
            return result;
        }
        return ("0" + s).trim();
    }

    public static synchronized String formatDate(long date) {
        return StringUtil.formatDate(new Date(date));
    }

    public static synchronized String formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String result = dateFormat.format(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            return result;
        }
        result = result + " " + (second == 0 ? timeFormat.format(date) : timeSecondsFormat.format(date)) + " Uhr";
        return result;
    }

    public static synchronized Date parseDate(String arg) {
        Date result;
        if (arg.isEmpty()) {
            throw new IllegalArgumentException("empty String");
        }
        String[] args = arg.split(" ");
        if (args.length > 2) {
            throw new IllegalArgumentException("Only one space allowed.");
        }
        try {
            result = dateFormat.parse(args[0]);
            if (args.length > 1) {
                long time = args[1].split("\\:").length == 2 ? timeFormat.parse(args[1]).getTime() : timeSecondsFormat.parse(args[1]).getTime();
                result = new Date(result.getTime() + time);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public static synchronized String formatTimestamp(long date) {
        return StringUtil.formatTimestamp(new Date(date));
    }

    public static synchronized String formatTimestamp(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return timestampFormat.format(date);
    }

    private static void registerColor(Map<Color, String> colorToName, Map<String, Color> nameToColor, Color color, String name) {
        colorToName.put(color, name);
        nameToColor.put(name, color);
    }

    public static Set<Color> getConstantColors() {
        return CONSTANT_COLOR_NAMES.keySet();
    }

    public static Color getConstantColor(String name) {
        return CONSTANT_COLORS_BY_NAMES.get(name.toLowerCase());
    }

    public static String getConstantColorName(Color color) {
        return CONSTANT_COLOR_NAMES.get(color);
    }

    public static String toNiceString(Color color) {
        if (CONSTANT_COLOR_NAMES.containsKey(color)) {
            return CONSTANT_COLOR_NAMES.get(color);
        }
        double lowestDiff = Double.MAX_VALUE;
        String bestMatch = null;
        for (Color other : CONSTANT_COLOR_NAMES.keySet()) {
            double diff = StringUtil.diff(color, other);
            if (!(diff < lowestDiff)) continue;
            lowestDiff = diff;
            bestMatch = CONSTANT_COLOR_NAMES.get(other);
        }
        String hexString = Integer.toHexString(color.asRGB()).toUpperCase();
        int zerosMissing = 6 - hexString.length();
        StringBuilder builder = new StringBuilder("roughly ");
        builder.append(bestMatch).append(" (#");
        for (int i = 0; i < zerosMissing; ++i) {
            builder.append('0');
        }
        builder.append(hexString).append(")");
        return builder.toString();
    }

    private static double diff(Color c1, Color c2) {
        return Math.sqrt(Math.pow(c1.getRed() - c2.getRed(), 2.0) + Math.pow(c1.getBlue() - c2.getBlue(), 2.0) + Math.pow(c1.getGreen() - c2.getGreen(), 2.0));
    }

    public static String flip(String s) {
        char[] data = s.toCharArray();
        ArrayUtils.flip(data);
        return String.valueOf(data);
    }

    static {
        Set trueStrings = Collections.newSetFromMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        trueStrings.addAll(Arrays.asList("1", "true", "t", "ja", "j", "wahr", "w"));
        TRUE_STRINGS = Collections.unmodifiableSet(trueStrings);
        Set falseStrings = Collections.newSetFromMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        falseStrings.addAll(Arrays.asList("0", "false", "f", "nein", "n", "falsch"));
        FALSE_STRINGS = Collections.unmodifiableSet(falseStrings);
        SPACES_AND_UNDERSCORES_PATTERN = Pattern.compile("[\\ \\_]");
        PIPE_PATTERN = Pattern.compile(" \\| ");
        REMOVE_PIPE_PATTERN = Pattern.compile("\\|([^\\|])");
        AND_PATTERN = Pattern.compile("\\&");
        COLOR_CHAR_PATTERN = Pattern.compile("\\\u00a7");
        ESCAPE_CHARACTER_PATTERN = Pattern.compile("\\\\.");
        MATCH_COLOR_CODES = Pattern.compile("\\\u00a7[" + Arrays.stream(ChatColor.values()).map(ChatColor::getChar).map(String::valueOf).collect(Collectors.joining()) + "]", 2);
        HashSet<Character> illegals = new HashSet<Character>();
        for (char c = '\u0000'; c <= '\u001f'; c = (char)(c + '\u0001')) {
            illegals.add(Character.valueOf(c));
        }
        for (char c : new char[]{'|', '\\', '/', '?', '!', '*', '+', '%', '<', '>', '\"', ':', ';', ',', '.', '=', '[', ']', '@', '\u007f'}) {
            illegals.add(Character.valueOf(c));
        }
        CHARS_ILLEGAL_IN_FILENAME = Collections.unmodifiableSet(illegals);
        TreeMap<Integer, String> romanNumberMap = new TreeMap<Integer, String>();
        romanNumberMap.put(1000, "M");
        romanNumberMap.put(900, "CM");
        romanNumberMap.put(500, "D");
        romanNumberMap.put(400, "CD");
        romanNumberMap.put(100, "C");
        romanNumberMap.put(90, "XC");
        romanNumberMap.put(50, "L");
        romanNumberMap.put(40, "XL");
        romanNumberMap.put(10, "X");
        romanNumberMap.put(9, "IX");
        romanNumberMap.put(5, "V");
        romanNumberMap.put(4, "IV");
        romanNumberMap.put(1, "I");
        ROMAN_NUMBER_MAP = Collections.unmodifiableNavigableMap(romanNumberMap);
        dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        timeFormat = new SimpleDateFormat(TIME_FORMAT_STRING);
        timeSecondsFormat = new SimpleDateFormat(TIME_SECONDS_FORMAT_STRING);
        timestampFormat = new SimpleDateFormat(TIMESTAMP_FORMAT_STRING);
        LinkedHashMap<Color, String> constantColorNames = new LinkedHashMap<Color, String>();
        LinkedHashMap<String, Color> constantColorsByNames = new LinkedHashMap<String, Color>();
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.AQUA, "aqua");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.BLACK, "black");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.BLUE, "blue");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.FUCHSIA, "fuchsia");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.GRAY, "gray");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.GREEN, "greeen");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.LIME, "lime");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.MAROON, "maroon");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.NAVY, "navy");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.OLIVE, "olive");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.ORANGE, "orange");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.PURPLE, "purple");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.RED, "red");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.SILVER, "silver");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.TEAL, "teal");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.WHITE, "white");
        StringUtil.registerColor(constantColorNames, constantColorsByNames, Color.YELLOW, "yellow");
        for (DyeColor dc : DyeColor.values()) {
            StringUtil.registerColor(constantColorNames, constantColorsByNames, dc.getColor(), dc.name().replaceAll(Pattern.quote("_"), " ").toLowerCase());
        }
        CONSTANT_COLOR_NAMES = Collections.unmodifiableMap(constantColorNames);
        CONSTANT_COLORS_BY_NAMES = Collections.unmodifiableMap(constantColorsByNames);
    }
}

