/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.commands;

import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.cubesideutils.commands.SubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.util.StringUtil;

public class CommandRouter
implements CommandExecutor,
TabCompleter {
    public static final String UNKNOWN_COMMAND_MESSAGE = "Unknown command. Type \"/help\" for help.";
    private CommandMap commands = new CommandMap(null, null);

    public CommandRouter(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public void addPluginCommand(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public void addCommandMapping(SubCommand command, String ... route) {
        if (route.length == 1 && route[0].contains(" ")) {
            this.addCommandMapping(command, route[0].split(" "));
            return;
        }
        CommandMap current = this.commands;
        for (int i = 0; i < route.length; ++i) {
            if (current.subCommands == null) {
                current.subCommands = new HashMap();
                current.subcommandsOrdered = new ArrayList();
            }
            String routePart = route[i].toLowerCase();
            CommandMap part = (CommandMap)current.subCommands.get(routePart);
            if (part == null) {
                part = new CommandMap(current, routePart);
                current.subCommands.put(routePart, part);
                current.subcommandsOrdered.add(part);
            }
            current = part;
        }
        if (current.executor != null) {
            throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is already mapped!");
        }
        current.executor = command;
    }

    public void addAlias(String alias, String ... route) {
        if (route.length == 0) {
            throw new IllegalArgumentException("Route may not be empty!");
        }
        if (route.length == 1 && route[0].contains(" ")) {
            this.addAlias(alias, route[0].split(" "));
            return;
        }
        alias = alias.toLowerCase().trim();
        CommandMap current = this.commands;
        for (int i = 0; i < route.length - 1; ++i) {
            if (current.subCommands == null) {
                throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is not mapped!");
            }
            String routePart = route[i].toLowerCase();
            CommandMap part = (CommandMap)current.subCommands.get(routePart);
            if (part == null) {
                throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is not mapped!");
            }
            current = part;
        }
        CommandMap createAliasFor = (CommandMap)current.subCommands.get(route[route.length - 1]);
        if (createAliasFor == null) {
            throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is not mapped!");
        }
        if (current.subCommands.get(alias) != null) {
            route = (String[])route.clone();
            route[route.length - 1] = alias;
            throw new IllegalArgumentException("Path " + Arrays.toString(route) + " is already mapped!");
        }
        current.subCommands.put(alias, createAliasFor);
    }

    public SubCommand getSubCommand(String path) {
        String[] args = path.split(" ");
        CommandMap currentMap = this.commands;
        int nr = 0;
        while (currentMap != null) {
            CommandMap subMap;
            String currentCmdPart;
            String string = currentCmdPart = args.length > nr ? args[nr] : null;
            if (currentCmdPart != null) {
                currentCmdPart = currentCmdPart.toLowerCase();
            }
            if (currentCmdPart != null && currentMap.subCommands != null && (subMap = (CommandMap)currentMap.subCommands.get(currentCmdPart)) != null) {
                ++nr;
                currentMap = subMap;
                continue;
            }
            SubCommand toExecute = currentMap.executor;
            if (toExecute != null) {
                return toExecute;
            }
            return null;
        }
        return null;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String partial = args.length > 0 ? args[args.length - 1] : "";
        CommandMap currentMap = this.commands;
        int nr = 0;
        while (currentMap != null) {
            CommandMap subMap;
            String currentCmdPart;
            String string = currentCmdPart = args.length - 1 > nr ? args[nr] : null;
            if (currentCmdPart != null) {
                currentCmdPart = currentCmdPart.toLowerCase();
            }
            if (currentCmdPart != null && currentMap.subCommands != null && (subMap = (CommandMap)currentMap.subCommands.get(currentCmdPart)) != null) {
                ++nr;
                currentMap = subMap;
                continue;
            }
            ArrayList<String> options = null;
            ArrayList<String> rv = null;
            if (currentMap.executor != null) {
                options = currentMap.executor.onTabComplete(sender, command, alias, new ArgsParser(args, nr));
            }
            if (currentMap.subCommands != null) {
                for (Map.Entry e : currentMap.subCommands.entrySet()) {
                    CommandMap subcmd;
                    String key = (String)e.getKey();
                    if (!StringUtil.startsWithIgnoreCase((String)key, (String)partial) || (subcmd = (CommandMap)e.getValue()).executor != null && subcmd.executor.getRequiredPermission() != null && !sender.hasPermission(subcmd.executor.getRequiredPermission()) || !(sender instanceof Player) && subcmd.executor != null && subcmd.executor.requiresPlayer()) continue;
                    if (rv == null) {
                        rv = options == null ? new ArrayList<String>() : new ArrayList(options);
                    }
                    rv.add(key);
                }
            }
            if (rv != null || options != null) {
                rv = (ArrayList<String>)StringUtil.copyPartialMatches((String)partial, rv != null ? rv : options, new ArrayList());
                Collections.sort(rv);
            }
            return rv;
        }
        return null;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        CommandMap currentMap = this.commands;
        int nr = 0;
        while (currentMap != null) {
            CommandMap subMap;
            String currentCmdPart;
            String string = currentCmdPart = args.length > nr ? args[nr] : null;
            if (currentCmdPart != null) {
                currentCmdPart = currentCmdPart.toLowerCase();
            }
            if (currentCmdPart != null && currentMap.subCommands != null && (subMap = (CommandMap)currentMap.subCommands.get(currentCmdPart)) != null) {
                ++nr;
                currentMap = subMap;
                continue;
            }
            SubCommand toExecute = currentMap.executor;
            if (toExecute != null) {
                if (toExecute.allowsCommandBlock() || !(sender instanceof BlockCommandSender) && !(sender instanceof CommandMinecart)) {
                    if (!toExecute.requiresPlayer() || sender instanceof Player) {
                        if ((toExecute.getRequiredPermission() == null || sender.hasPermission(toExecute.getRequiredPermission())) && toExecute.isAvailable(sender)) {
                            return toExecute.onCommand(sender, command, alias, this.getCommandString(alias, currentMap), new ArgsParser(args, nr));
                        }
                        sender.sendMessage(ChatColor.RED + "No permission!");
                    } else {
                        sender.sendMessage(ChatColor.RED + "This command can only be executed by players!");
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "This command is not allowed for CommandBlocks!");
                }
            }
            this.showHelp(sender, alias, currentMap);
            return true;
        }
        return false;
    }

    private String getCommandString(String alias, CommandMap currentMap) {
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append('/').append(alias).append(' ');
        ArrayList<CommandMap> hierarchy = new ArrayList<CommandMap>();
        CommandMap map = currentMap;
        while (map != null) {
            hierarchy.add(map);
            map = map.parent;
        }
        for (int i = hierarchy.size() - 2; i >= 0; --i) {
            prefixBuilder.append(((CommandMap)hierarchy.get(i)).name).append(' ');
        }
        return prefixBuilder.toString();
    }

    private void showHelp(CommandSender sender, String alias, CommandMap currentMap) {
        if (currentMap.subCommands != null) {
            String prefix = this.getCommandString(alias, currentMap);
            for (CommandMap subcmd : currentMap.subcommandsOrdered) {
                String key = subcmd.name;
                if (subcmd.executor == null) {
                    sender.sendMessage(prefix + key + " ...");
                    continue;
                }
                if (subcmd.executor.getRequiredPermission() != null && !sender.hasPermission(subcmd.executor.getRequiredPermission()) || !subcmd.executor.isAvailable(sender) || !(sender instanceof Player) && subcmd.executor.requiresPlayer()) continue;
                sender.sendMessage(prefix + key + " " + subcmd.executor.getUsage());
            }
        }
    }

    private class CommandMap {
        private String name;
        private CommandMap parent;
        private HashMap<String, CommandMap> subCommands;
        private ArrayList<CommandMap> subcommandsOrdered;
        private SubCommand executor;

        public CommandMap(CommandMap parent, String name) {
            this.parent = parent;
            this.name = name;
        }
    }
}

