/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.libs.de.iani.cubesideutils.collections;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class GeneralHashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6031498036577864018L;
    public static final ToIntFunction<Object> DEFAULT_HASHER = Objects::hashCode;
    public static final BiPredicate<Object, Object> DEFAULT_EQUALITY = Objects::equals;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Method STREAM_CHECK_ARRAY_METHOD;
    private final ToIntFunction<? super K> hasher;
    private final BiPredicate<? super K, ? super K> equality;
    private int threshold;
    private final float loadFactor;
    transient Node[] table;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;
    transient int size;
    transient int modCount;

    public static <T> ToIntFunction<T> createNullResistantHasher(ToIntFunction<T> original) {
        return x -> x == null ? 0 : original.applyAsInt(x);
    }

    public static <T> ToIntFunction<Object> createTypeResistantHasher(ToIntFunction<? super T> original, Class<T> type) {
        return x -> {
            if (x != null && !type.isInstance(x)) {
                return original.applyAsInt(x);
            }
            return 0;
        };
    }

    public static <T> ToIntFunction<Object> createResistantHasher(ToIntFunction<? super T> original, Class<T> type) {
        return x -> {
            if (x == null) {
                return 0;
            }
            return type.isInstance(x) ? original.applyAsInt(x) : 0;
        };
    }

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static void checkArray(ObjectInputStream stream, Class<?> arrayType, int arrayLength) throws InvalidClassException {
        try {
            STREAM_CHECK_ARRAY_METHOD.invoke((Object)stream, arrayType, arrayLength);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof InvalidClassException) {
                throw (InvalidClassException)e.getCause();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = GeneralHashMap.tableSizeFor(initialCapacity);
        this.hasher = Objects.requireNonNull(hasher);
        this.equality = Objects.requireNonNull(equality);
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity) {
        this(hasher, equality, initialCapacity, 0.75f);
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality) {
        this(hasher, equality, 16, 0.75f);
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, Map<? extends K, ? extends V> copyOf) {
        this(hasher, equality, 16, 0.75f);
        this.putMapEntries(copyOf, false);
    }

    protected int hash(Object key) {
        try {
            int h = this.hasher.applyAsInt(key);
            return h ^ h >>> 16;
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    protected void putMapEntries(Map<? extends K, ? extends V> m, boolean evict) {
        int s = m.size();
        if (s > 0) {
            if (this.table == null) {
                int t;
                float ft = (float)s / this.loadFactor + 1.0f;
                int n = t = ft < 1.0737418E9f ? (int)ft : 0x40000000;
                if (t > this.threshold) {
                    this.threshold = GeneralHashMap.tableSizeFor(t);
                }
            } else if (s > this.threshold) {
                this.resize();
            }
            for (Map.Entry<K, V> e : m.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                this.putVal(this.hash(key), key, value, false, evict);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Node e = this.getNode(this.hash(key), key);
        return e == null ? null : (V)e.value;
    }

    final Node getNode(int hash, Object key) {
        try {
            Node first;
            int n;
            Node[] tab = this.table;
            if (this.table != null && (n = tab.length) > 0 && (first = tab[n - 1 & hash]) != null) {
                if (first.hash == hash && this.equality.test(first.key, key)) {
                    return first;
                }
                Node e = first.next;
                if (e != null) {
                    do {
                        if (e.hash != hash || !this.equality.test(e.key, key)) continue;
                        return e;
                    } while ((e = e.next) != null);
                }
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNode(this.hash(key), key) != null;
    }

    @Override
    public V put(K key, V value) {
        return this.putVal(this.hash(key), key, value, false, true);
    }

    final V putVal(int hash, K key, V value, boolean onlyIfAbsent, boolean evict) {
        int i;
        Node p;
        int n;
        Node[] tab = this.table;
        if (this.table == null || (n = tab.length) == 0) {
            tab = this.resize();
            n = tab.length;
        }
        if ((p = tab[i = n - 1 & hash]) == null) {
            tab[i] = this.newNode(hash, key, value, null);
        } else {
            Node e;
            if (p.hash == hash && this.equality.test(p.key, key)) {
                e = p;
            } else {
                while (true) {
                    if ((e = p.next) == null) {
                        p.next = this.newNode(hash, key, value, null);
                        break;
                    }
                    if (e.hash == hash && this.equality.test(e.key, key)) break;
                    p = e;
                }
            }
            if (e != null) {
                Object oldValue = e.value;
                if (!onlyIfAbsent || oldValue == null) {
                    e.value = value;
                }
                this.afterNodeAccess(e);
                return oldValue;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        this.afterNodeInsertion(evict);
        return null;
    }

    final Node[] resize() {
        int newCap;
        Node[] oldTab = this.table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.threshold;
        int newThr = 0;
        if (oldCap > 0) {
            if (oldCap >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return oldTab;
            }
            newCap = oldCap << 1;
            if (newCap < 0x40000000 && oldCap >= 16) {
                newThr = oldThr << 1;
            }
        } else if (oldThr > 0) {
            newCap = oldThr;
        } else {
            newCap = 16;
            newThr = 12;
        }
        if (newThr == 0) {
            float ft = (float)newCap * this.loadFactor;
            newThr = newCap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
        }
        this.threshold = newThr;
        Node[] newTab = new Node[newCap];
        this.table = newTab;
        if (oldTab != null) {
            for (int j = 0; j < oldCap; ++j) {
                Node next;
                Node e = oldTab[j];
                if (e == null) continue;
                oldTab[j] = null;
                if (e.next == null) {
                    newTab[e.hash & newCap - 1] = e;
                    continue;
                }
                Node loHead = null;
                Node loTail = null;
                Node hiHead = null;
                Node hiTail = null;
                do {
                    next = e.next;
                    if ((e.hash & oldCap) == 0) {
                        if (loTail == null) {
                            loHead = e;
                        } else {
                            loTail.next = e;
                        }
                        loTail = e;
                        continue;
                    }
                    if (hiTail == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                } while ((e = next) != null);
                if (loTail != null) {
                    loTail.next = null;
                    newTab[j] = loHead;
                }
                if (hiTail == null) continue;
                hiTail.next = null;
                newTab[j + oldCap] = hiHead;
            }
        }
        return newTab;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putMapEntries(m, true);
    }

    @Override
    public V remove(Object key) {
        Node e = this.removeNode(this.hash(key), key, null, false, true);
        return e == null ? null : (V)e.value;
    }

    final Node removeNode(int hash, Object key, Object value, boolean matchValue, boolean movable) {
        try {
            int index;
            Node p;
            int n;
            Node[] tab = this.table;
            if (this.table != null && (n = tab.length) > 0 && (p = tab[index = n - 1 & hash]) != null) {
                Object v;
                Node node = null;
                if (p.hash == hash && this.equality.test(p.key, key)) {
                    node = p;
                } else {
                    Node e = p.next;
                    if (e != null) {
                        do {
                            if (e.hash == hash && this.equality.test(e.key, key)) {
                                node = e;
                                break;
                            }
                            p = e;
                        } while ((e = e.next) != null);
                    }
                }
                if (node != null && (!matchValue || (v = node.value) == value || value != null && value.equals(v))) {
                    if (node == p) {
                        tab[index] = node.next;
                    } else {
                        p.next = node.next;
                    }
                    ++this.modCount;
                    --this.size;
                    this.afterNodeRemoval(node);
                    return node;
                }
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Node[] tab = this.table;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Node[] tab = this.table;
        if (this.table != null && this.size > 0) {
            for (int i = 0; i < tab.length; ++i) {
                Node e = tab[i];
                while (e != null) {
                    Object v = e.value;
                    if (v == value || value != null && value.equals(v)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new KeySet();
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        if (vs == null) {
            this.values = vs = new Values();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        Node e = this.getNode(this.hash(key), key);
        return e == null ? defaultValue : e.value;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putVal(this.hash(key), key, value, true, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.removeNode(this.hash(key), key, value, true, true) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object v;
        Node e = this.getNode(this.hash(key), key);
        if (e != null && ((v = e.value) == oldValue || v != null && v.equals(oldValue))) {
            e.value = newValue;
            this.afterNodeAccess(e);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        Node e = this.getNode(this.hash(key), key);
        if (e != null) {
            Object oldValue = e.value;
            e.value = value;
            this.afterNodeAccess(e);
            return oldValue;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V v;
        int i;
        Node first;
        int n;
        Node[] tab;
        Node old;
        int hash;
        block10: {
            block9: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = this.hash(key);
                old = null;
                if (this.size > this.threshold) break block9;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block10;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            Object oldValue;
            Node e = first;
            do {
                if (e.hash != hash || !this.equality.test(e.key, key)) continue;
                old = e;
                break;
            } while ((e = e.next) != null);
            if (old != null && (oldValue = old.value) != null) {
                this.afterNodeAccess(old);
                return oldValue;
            }
        }
        if ((v = mappingFunction.apply(key)) == null) {
            return null;
        }
        if (old != null) {
            old.value = v;
            this.afterNodeAccess(old);
            return v;
        }
        tab[i] = this.newNode(hash, key, v, first);
        ++this.modCount;
        ++this.size;
        this.afterNodeInsertion(true);
        return v;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int hash = this.hash(key);
        Node e = this.getNode(hash, key);
        if (e != null && (oldValue = e.value) != null) {
            V v = remappingFunction.apply(key, oldValue);
            if (v != null) {
                e.value = v;
                this.afterNodeAccess(e);
                return v;
            }
            this.removeNode(hash, key, null, false, true);
        }
        return null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        int i;
        Node first;
        int n;
        Node[] tab;
        Node old;
        int hash;
        block12: {
            block11: {
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = this.hash(key);
                old = null;
                if (this.size > this.threshold) break block11;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block12;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            Node e = first;
            do {
                if (e.hash != hash || !this.equality.test(e.key, key)) continue;
                old = e;
                break;
            } while ((e = e.next) != null);
        }
        Object oldValue = old == null ? null : (Object)old.value;
        V v = remappingFunction.apply(key, oldValue);
        if (old != null) {
            if (v != null) {
                old.value = v;
                this.afterNodeAccess(old);
            } else {
                this.removeNode(hash, key, null, false, true);
            }
        } else if (v != null) {
            tab[i] = this.newNode(hash, key, v, first);
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return v;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        int i;
        Node first;
        int n;
        Node[] tab;
        Node old;
        int hash;
        block11: {
            block10: {
                if (value == null) {
                    throw new NullPointerException();
                }
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = this.hash(key);
                old = null;
                if (this.size > this.threshold) break block10;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block11;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            Node e = first;
            do {
                if (e.hash != hash || !this.equality.test(e.key, key)) continue;
                old = e;
                break;
            } while ((e = e.next) != null);
        }
        if (old != null) {
            V v = old.value != null ? remappingFunction.apply(old.value, value) : value;
            if (v != null) {
                old.value = v;
                this.afterNodeAccess(old);
            } else {
                this.removeNode(hash, key, null, false, true);
            }
            return v;
        }
        tab[i] = this.newNode(hash, key, value, first);
        ++this.modCount;
        ++this.size;
        this.afterNodeInsertion(true);
        return value;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node[] tab = this.table;
            if (this.table != null) {
                int mc = this.modCount;
                for (int i = 0; i < tab.length; ++i) {
                    Node e = tab[i];
                    while (e != null) {
                        action.accept(e.key, e.value);
                        e = e.next;
                    }
                }
                if (this.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node[] tab = this.table;
            if (this.table != null) {
                int mc = this.modCount;
                for (int i = 0; i < tab.length; ++i) {
                    Node e = tab[i];
                    while (e != null) {
                        e.value = function.apply(e.key, e.value);
                        e = e.next;
                    }
                }
                if (this.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public Object clone() {
        GeneralHashMap result;
        try {
            result = (GeneralHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        result.reinitialize();
        result.putMapEntries(this, false);
        return result;
    }

    final float loadFactor() {
        return this.loadFactor;
    }

    final int capacity() {
        return this.table != null ? this.table.length : (this.threshold > 0 ? this.threshold : 16);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int buckets = this.capacity();
        s.defaultWriteObject();
        s.writeInt(buckets);
        s.writeInt(this.size);
        this.internalWriteEntries(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reinitialize();
        if (this.loadFactor <= 0.0f || Float.isNaN(this.loadFactor)) {
            throw new InvalidObjectException("Illegal load factor: " + this.loadFactor);
        }
        s.readInt();
        int mappings = s.readInt();
        if (mappings < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + mappings);
        }
        if (mappings > 0) {
            float lf = Math.min(Math.max(0.25f, this.loadFactor), 4.0f);
            float fc = (float)mappings / lf + 1.0f;
            int cap = fc < 16.0f ? 16 : (fc >= 1.0737418E9f ? 0x40000000 : GeneralHashMap.tableSizeFor((int)fc));
            float ft = (float)cap * lf;
            this.threshold = cap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
            GeneralHashMap.checkArray(s, Map.Entry[].class, cap);
            Node[] tab = new Node[cap];
            this.table = tab;
            for (int i = 0; i < mappings; ++i) {
                Object key = s.readObject();
                Object value = s.readObject();
                this.putVal(this.hash(key), key, value, false, false);
            }
        }
    }

    Node newNode(int hash, K key, V value, Node next) {
        return new Node(hash, key, value, next);
    }

    Node replacementNode(Node p, Node next) {
        return new Node(p.hash, p.key, p.value, next);
    }

    void reinitialize() {
        this.table = null;
        this.entrySet = null;
        this.keySet = null;
        this.values = null;
        this.modCount = 0;
        this.threshold = 0;
        this.size = 0;
    }

    void afterNodeAccess(Node p) {
    }

    void afterNodeInsertion(boolean evict) {
    }

    void afterNodeRemoval(Node p) {
    }

    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        if (this.size > 0) {
            Node[] tab = this.table;
            if (this.table != null) {
                for (int i = 0; i < tab.length; ++i) {
                    Node e = tab[i];
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
            }
        }
    }

    static {
        try {
            STREAM_CHECK_ARRAY_METHOD = ObjectInputStream.class.getDeclaredMethod("checkArray", Class.class, Integer.TYPE);
            STREAM_CHECK_ARRAY_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError("checkArray in ObjectInputStream");
        }
        catch (SecurityException e) {
            throw new Error("Cannot access method checkArray in ObjectInputStream.java.");
        }
    }

    final class EntrySpliterator
    extends HashMapSpliterator
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(GeneralHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public EntrySpliterator trySplit() {
            EntrySpliterator entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator entrySpliterator2 = new EntrySpliterator(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            GeneralHashMap m = this.map;
            Node[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Node e = this.current;
                    this.current = this.current.next;
                    action.accept(e);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    final class ValueSpliterator
    extends HashMapSpliterator
    implements Spliterator<V> {
        ValueSpliterator(GeneralHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public ValueSpliterator trySplit() {
            ValueSpliterator valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator valueSpliterator2 = new ValueSpliterator(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            GeneralHashMap m = this.map;
            Node[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.value);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object v = this.current.value;
                    this.current = this.current.next;
                    action.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    final class KeySpliterator
    extends HashMapSpliterator
    implements Spliterator<K> {
        KeySpliterator(GeneralHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public KeySpliterator trySplit() {
            KeySpliterator keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator keySpliterator2 = new KeySpliterator(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            GeneralHashMap m = this.map;
            Node[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.key);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object k = this.current.key;
                    this.current = this.current.next;
                    action.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    class HashMapSpliterator {
        final GeneralHashMap<K, V> map;
        Node current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        HashMapSpliterator(GeneralHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                GeneralHashMap m = this.map;
                this.est = m.size;
                this.expectedModCount = m.modCount;
                Node[] tab = m.table;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            }
            return hi;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    abstract class HashIterator {
        Node next;
        Node current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = GeneralHashMap.this.modCount;
            Node[] t = GeneralHashMap.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && GeneralHashMap.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node nextNode() {
            Node e = this.next;
            if (GeneralHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Node[] t = GeneralHashMap.this.table;
                if (GeneralHashMap.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (GeneralHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            Object key = p.key;
            GeneralHashMap.this.removeNode(GeneralHashMap.this.hash(key), key, null, false, false);
            this.expectedModCount = GeneralHashMap.this.modCount;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return GeneralHashMap.this.size;
        }

        @Override
        public final void clear() {
            GeneralHashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Node candidate = GeneralHashMap.this.getNode(GeneralHashMap.this.hash(key), key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return GeneralHashMap.this.removeNode(GeneralHashMap.this.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(GeneralHashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (GeneralHashMap.this.size > 0) {
                Node[] tab = GeneralHashMap.this.table;
                if (GeneralHashMap.this.table != null) {
                    int mc = GeneralHashMap.this.modCount;
                    for (int i = 0; i < tab.length; ++i) {
                        Node e = tab[i];
                        while (e != null) {
                            action.accept(e);
                            e = e.next;
                        }
                    }
                    if (GeneralHashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return GeneralHashMap.this.size;
        }

        @Override
        public final void clear() {
            GeneralHashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return GeneralHashMap.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(GeneralHashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (GeneralHashMap.this.size > 0) {
                Node[] tab = GeneralHashMap.this.table;
                if (GeneralHashMap.this.table != null) {
                    int mc = GeneralHashMap.this.modCount;
                    for (int i = 0; i < tab.length; ++i) {
                        Node e = tab[i];
                        while (e != null) {
                            action.accept(e.value);
                            e = e.next;
                        }
                    }
                    if (GeneralHashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return GeneralHashMap.this.size;
        }

        @Override
        public final void clear() {
            GeneralHashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return GeneralHashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return GeneralHashMap.this.removeNode(GeneralHashMap.this.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return new KeySpliterator(GeneralHashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (GeneralHashMap.this.size > 0) {
                Node[] tab = GeneralHashMap.this.table;
                if (GeneralHashMap.this.table != null) {
                    int mc = GeneralHashMap.this.modCount;
                    for (int i = 0; i < tab.length; ++i) {
                        Node e = tab[i];
                        while (e != null) {
                            action.accept(e.key);
                            e = e.next;
                        }
                    }
                    if (GeneralHashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    class Node
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node next;

        Node(int hash, K key, V value, Node next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return GeneralHashMap.this.hasher.applyAsInt(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                try {
                    if (GeneralHashMap.this.equality.test(this.key, e.getKey()) && Objects.equals(this.value, e.getValue())) {
                        return true;
                    }
                }
                catch (ClassCastException exc) {
                    return false;
                }
            }
            return false;
        }
    }
}

