/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubeConomy.commands;

public class ArgsParser {
    private String[] args;
    private int current;

    public ArgsParser(String[] args) {
        this.args = args;
        this.current = -1;
    }

    public ArgsParser(String[] args, int skipParts) {
        this.args = args;
        this.current = -1 + skipParts;
    }

    public boolean hasNext() {
        return this.current < this.args.length - 1;
    }

    public int remaining() {
        return Math.max(this.args.length - 1 - this.current, 0);
    }

    public String getAll(String def) {
        ++this.current;
        if (this.args.length <= this.current) {
            return def;
        }
        StringBuilder sb = new StringBuilder();
        while (this.args.length > this.current) {
            sb.append(this.args[this.current]);
            sb.append(' ');
            ++this.current;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String seeNext(String def) {
        if (this.args.length <= this.current + 1) {
            return def;
        }
        return this.args[this.current + 1];
    }

    public String getNext(String def) {
        ++this.current;
        if (this.args.length <= this.current) {
            return def;
        }
        return this.args[this.current];
    }

    public int getNext(int def) {
        String next = this.getNext(null);
        if (next == null) {
            return def;
        }
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double getNext(double def) {
        String next = this.getNext(null);
        if (next == null) {
            return def;
        }
        try {
            return Double.parseDouble(next);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Boolean getNext(boolean ignored) {
        String next = this.getNext(null);
        if (next == null) {
            return null;
        }
        if (next.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (next.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

