/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockSpreadEvent;

public class BlockSpreadLogging
extends LoggingListener {
    public BlockSpreadLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        String name;
        World world = event.getNewState().getWorld();
        Material type = event.getNewState().getType();
        switch (type) {
            case GRASS: {
                if (!Config.isLogging(world, Logging.GRASSGROWTH)) {
                    return;
                }
                name = "GrassGrowth";
                break;
            }
            case MYCELIUM: {
                if (!Config.isLogging(world, Logging.MYCELIUMSPREAD)) {
                    return;
                }
                name = "MyceliumSpread";
                break;
            }
            case WEEPING_VINES: 
            case TWISTING_VINES: 
            case VINE: 
            case WEEPING_VINES_PLANT: 
            case TWISTING_VINES_PLANT: 
            case CAVE_VINES: 
            case CAVE_VINES_PLANT: {
                if (!Config.isLogging(world, Logging.VINEGROWTH)) {
                    return;
                }
                name = "VineGrowth";
                break;
            }
            case BROWN_MUSHROOM: 
            case RED_MUSHROOM: {
                if (!Config.isLogging(world, Logging.MUSHROOMSPREAD)) {
                    return;
                }
                name = "MushroomSpread";
                break;
            }
            case BAMBOO: 
            case BAMBOO_SAPLING: {
                if (!Config.isLogging(world, Logging.BAMBOOGROWTH)) {
                    return;
                }
                name = "BambooGrowth";
                if (type != Material.BAMBOO_SAPLING) break;
                this.consumer.queueBlockReplace(new Actor(name), event.getSource().getState(), Material.BAMBOO.createBlockData());
                break;
            }
            case POINTED_DRIPSTONE: {
                if (!Config.isLogging(world, Logging.DRIPSTONEGROWTH)) {
                    return;
                }
                name = "DripstoneGrowth";
                PointedDripstone pointed = (PointedDripstone)event.getNewState().getBlockData();
                if (pointed.getThickness() != PointedDripstone.Thickness.TIP_MERGE) {
                    BlockFace direction = pointed.getVerticalDirection();
                    Block previousPart = event.getBlock().getRelative(direction.getOppositeFace());
                    if (previousPart.getType() != Material.POINTED_DRIPSTONE) break;
                    PointedDripstone newBelow = (PointedDripstone)previousPart.getBlockData();
                    newBelow.setThickness(PointedDripstone.Thickness.FRUSTUM);
                    this.consumer.queueBlockReplace(new Actor(name), previousPart.getState(), (BlockData)newBelow);
                    previousPart = previousPart.getRelative(direction.getOppositeFace());
                    if (previousPart.getType() != Material.POINTED_DRIPSTONE) break;
                    Block evenMorePrevious = previousPart.getRelative(direction.getOppositeFace());
                    newBelow = (PointedDripstone)previousPart.getBlockData();
                    newBelow.setThickness(evenMorePrevious.getType() == Material.POINTED_DRIPSTONE ? PointedDripstone.Thickness.MIDDLE : PointedDripstone.Thickness.BASE);
                    this.consumer.queueBlockReplace(new Actor(name), previousPart.getState(), (BlockData)newBelow);
                    break;
                }
                PointedDripstone oldState = (PointedDripstone)event.getNewState().getBlockData();
                oldState.setThickness(PointedDripstone.Thickness.TIP);
                this.consumer.queueBlockReplace(new Actor(name), (BlockData)oldState, event.getNewState());
                return;
            }
            default: {
                return;
            }
        }
        this.consumer.queueBlockReplace(new Actor(name), event.getBlock().getState(), event.getNewState());
    }
}

