/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.config;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.EntityLogging;
import de.diddiz.LogBlock.config.LoggingEnabledMapping;
import de.diddiz.LogBlock.util.BukkitUtils;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;

public class WorldConfig
extends LoggingEnabledMapping {
    public final String world;
    public final String table;
    public final String insertBlockStatementString;
    public final String selectBlockActorIdStatementString;
    public final String insertBlockStateStatementString;
    public final String insertBlockChestDataStatementString;
    public final String insertEntityStatementString;
    public final String updateEntityUUIDString;
    private final EnumMap<EntityLogging, EntityLoggingList> entityLogging = new EnumMap(EntityLogging.class);

    public WorldConfig(String world, File file) throws IOException {
        this.world = world;
        HashMap<String, Object> def = new HashMap<String, Object>();
        def.put("table", "lb-" + file.getName().substring(0, file.getName().length() - 4).replaceAll("[ ./\\\\]", "_"));
        Logging[] loggingArray = Logging.values();
        int n = loggingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Logging l = loggingArray[n2];
            def.put("logging." + l.toString(), l.isDefaultEnabled());
            ++n2;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (Map.Entry e : def.entrySet()) {
            if (config.get((String)e.getKey()) != null) continue;
            config.set((String)e.getKey(), e.getValue());
        }
        Enum[] enumArray = EntityLogging.values();
        int n3 = enumArray.length;
        int n4 = 0;
        while (n4 < n3) {
            EntityLogging el = enumArray[n4];
            if (!(config.get("entity." + el.name().toLowerCase()) instanceof List)) {
                config.set("entity." + el.name().toLowerCase(), el.getDefaultEnabled());
            }
            this.entityLogging.put(el, new EntityLoggingList(config.getStringList("entity." + el.name().toLowerCase())));
            ++n4;
        }
        config.save(file);
        this.table = config.getString("table");
        enumArray = Logging.values();
        n3 = enumArray.length;
        n4 = 0;
        while (n4 < n3) {
            Enum l = enumArray[n4];
            this.setLogging((Logging)l, config.getBoolean("logging." + l.toString()));
            ++n4;
        }
        this.insertBlockStatementString = "INSERT INTO `" + this.table + "-blocks` (date, playerid, replaced, replaceddata, type, typedata, x, y, z) VALUES (FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?, ?, ?)";
        this.selectBlockActorIdStatementString = "SELECT playerid FROM `" + this.table + "-blocks` WHERE x = ? AND y = ? AND z = ? ORDER BY date DESC LIMIT 1";
        this.insertBlockStateStatementString = "INSERT INTO `" + this.table + "-state` (replacedState, typeState, id) VALUES(?, ?, ?)";
        this.insertBlockChestDataStatementString = "INSERT INTO `" + this.table + "-chestdata` (item, itemremove, id, itemtype) values (?, ?, ?, ?)";
        this.insertEntityStatementString = "INSERT INTO `" + this.table + "-entities` (date, playerid, entityid, entitytypeid, x, y, z, action, data) VALUES (FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?, ?, ?)";
        this.updateEntityUUIDString = "UPDATE `" + this.table + "-entityids` SET entityuuid = ? WHERE entityid = ?";
    }

    public boolean isLogging(EntityLogging logging, Entity entity) {
        return this.entityLogging.get((Object)logging).isLogging(entity);
    }

    public boolean isLoggingAnyEntities() {
        for (EntityLoggingList list : this.entityLogging.values()) {
            if (!list.isLoggingAnyEntities()) continue;
            return true;
        }
        return false;
    }

    private class EntityLoggingList {
        private final EnumSet<EntityType> logged = EnumSet.noneOf(EntityType.class);
        private final boolean logAll;
        private final boolean logAnimals;
        private final boolean logMonsters;
        private final boolean logLiving;

        public EntityLoggingList(List<String> types) {
            boolean all = false;
            boolean animals = false;
            boolean monsters = false;
            boolean living = false;
            for (String type : types) {
                EntityType et = BukkitUtils.matchEntityType(type);
                if (et != null) {
                    this.logged.add(et);
                    continue;
                }
                if (type.equalsIgnoreCase("all")) {
                    all = true;
                    continue;
                }
                if (type.equalsIgnoreCase("animal") || type.equalsIgnoreCase("animals")) {
                    animals = true;
                    continue;
                }
                if (type.equalsIgnoreCase("monster") || type.equalsIgnoreCase("monsters")) {
                    monsters = true;
                    continue;
                }
                if (type.equalsIgnoreCase("living")) {
                    living = true;
                    continue;
                }
                LogBlock.getInstance().getLogger().log(Level.WARNING, "Unkown entity type in config for " + WorldConfig.this.world + ": " + type);
            }
            this.logAll = all;
            this.logAnimals = animals;
            this.logMonsters = monsters;
            this.logLiving = living;
        }

        public boolean isLogging(Entity entity) {
            if (entity == null || entity instanceof Player) {
                return false;
            }
            EntityType type = entity.getType();
            if (this.logAll || this.logged.contains(type)) {
                return true;
            }
            if (this.logLiving && LivingEntity.class.isAssignableFrom(entity.getClass()) && !(entity instanceof ArmorStand)) {
                return true;
            }
            if (this.logAnimals && (Animals.class.isAssignableFrom(entity.getClass()) || WaterMob.class.isAssignableFrom(entity.getClass()))) {
                return true;
            }
            return this.logMonsters && (Monster.class.isAssignableFrom(entity.getClass()) || entity.getType() == EntityType.SLIME || entity.getType() == EntityType.WITHER || entity.getType() == EntityType.ENDER_DRAGON || entity.getType() == EntityType.SHULKER || entity.getType() == EntityType.GHAST);
        }

        public boolean isLoggingAnyEntities() {
            return this.logAll || this.logAnimals || this.logLiving || this.logMonsters || !this.logged.isEmpty();
        }
    }
}

