/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.blockstate;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.blockstate.BlockStateCodec;
import de.diddiz.LogBlock.blockstate.BlockStateCodecBanner;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSign;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSkull;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSpawner;
import de.diddiz.util.Utils;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlockStateCodecs {
    private static Map<Material, BlockStateCodec> codecs = new EnumMap<Material, BlockStateCodec>(Material.class);

    static {
        BlockStateCodecs.registerCodec(new BlockStateCodecSign());
        BlockStateCodecs.registerCodec(new BlockStateCodecSkull());
        BlockStateCodecs.registerCodec(new BlockStateCodecBanner());
        BlockStateCodecs.registerCodec(new BlockStateCodecSpawner());
    }

    public static void registerCodec(BlockStateCodec codec) {
        Material[] materials;
        Material[] materialArray = materials = codec.getApplicableMaterials();
        int n = materials.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            if (codecs.containsKey(material)) {
                throw new IllegalArgumentException("BlockStateCodec for " + material + " already registered!");
            }
            codecs.put(material, codec);
            ++n2;
        }
    }

    public static boolean hasCodec(Material material) {
        return codecs.containsKey(material);
    }

    public static byte[] serialize(BlockState state) {
        YamlConfiguration serialized;
        BlockStateCodec codec = codecs.get(state.getType());
        if (codec != null && (serialized = codec.serialize(state)) != null && !serialized.getKeys(false).isEmpty()) {
            return Utils.serializeYamlConfiguration(serialized);
        }
        return null;
    }

    public static void deserialize(BlockState block, byte[] state) {
        BlockStateCodec codec = codecs.get(block.getType());
        if (codec != null) {
            YamlConfiguration conf = null;
            try {
                if (state != null) {
                    conf = Utils.deserializeYamlConfiguration(state);
                }
            }
            catch (InvalidConfigurationException e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Exception while deserializing BlockState", e);
            }
            codec.deserialize(block, conf);
        }
    }

    public static String toString(Material material, byte[] state) {
        BlockStateCodec codec = codecs.get(material);
        if (codec != null) {
            YamlConfiguration conf = null;
            try {
                if (state != null) {
                    conf = Utils.deserializeYamlConfiguration(state);
                }
            }
            catch (InvalidConfigurationException e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Exception while deserializing BlockState", e);
            }
            return codec.toString(conf);
        }
        return null;
    }
}

