/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.util.LoggingUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Location;

public class ChatMessage
implements LookupCacheElement {
    final long id;
    final long date;
    final String playerName;
    final String message;
    final Actor player;

    public ChatMessage(Actor player, String message) {
        this.id = 0L;
        this.date = System.currentTimeMillis() / 1000L;
        this.player = player;
        this.message = LoggingUtil.checkText(message);
        this.playerName = player == null ? null : player.getName();
    }

    public ChatMessage(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? rs.getInt("id") : 0;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.player = p.needPlayer ? new Actor(rs) : null;
        this.playerName = p.needPlayer ? rs.getString("playername") : null;
        this.message = p.needMessage ? rs.getString("message") : null;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    @Override
    public String getMessage() {
        return String.valueOf(this.player != null ? "<" + this.player.getName() + "> " : "") + (this.message != null ? this.message : "");
    }
}

