/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Switch;
import org.bukkit.inventory.ItemStack;

public class BlockChange
implements LookupCacheElement {
    public final long id;
    public final long date;
    public final Location loc;
    public final Actor actor;
    public final String playerName;
    public final int replacedMaterial;
    public final int replacedData;
    public final int typeMaterial;
    public final int typeData;
    public final byte[] replacedState;
    public final byte[] typeState;
    public final ChestAccess ca;

    public BlockChange(long date, Location loc, Actor actor, int replaced, int replacedData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess ca) {
        this.id = 0L;
        this.date = date;
        this.loc = loc;
        this.actor = actor;
        this.replacedMaterial = replaced;
        this.replacedData = replacedData;
        this.replacedState = replacedState;
        this.typeMaterial = type;
        this.typeData = typeData;
        this.typeState = typeState;
        this.ca = ca;
        this.playerName = actor == null ? null : actor.getName();
    }

    public BlockChange(ResultSet rs, QueryParams p) throws SQLException {
        ItemStack stack;
        this.id = p.needId ? rs.getInt("id") : 0;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.actor = p.needPlayer ? new Actor(rs) : null;
        this.playerName = p.needPlayer ? rs.getString("playername") : null;
        this.replacedMaterial = p.needType ? rs.getInt("replaced") : 0;
        this.replacedData = p.needType ? rs.getInt("replacedData") : -1;
        this.typeMaterial = p.needType ? rs.getInt("type") : 0;
        this.typeData = p.needType ? rs.getInt("typeData") : -1;
        this.replacedState = p.needType ? rs.getBytes("replacedState") : null;
        this.typeState = p.needType ? rs.getBytes("typeState") : null;
        ChestAccess catemp = null;
        if (p.needChestAccess && (stack = Utils.loadItemStack(rs.getBytes("item"))) != null) {
            catemp = new ChestAccess(stack, rs.getBoolean("itemremove"));
        }
        this.ca = catemp;
    }

    public String toString() {
        BlockData type = MaterialConverter.getBlockData(this.typeMaterial, this.typeData);
        BlockData replaced = MaterialConverter.getBlockData(this.replacedMaterial, this.replacedData);
        String typeDetails = null;
        if (BlockStateCodecs.hasCodec(type.getMaterial())) {
            try {
                typeDetails = BlockStateCodecs.toString(type.getMaterial(), this.typeState);
            }
            catch (Exception e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Could not parse BlockState for " + type.getMaterial(), e);
            }
        }
        typeDetails = typeDetails == null ? "" : " " + typeDetails;
        String replacedDetails = null;
        if (BlockStateCodecs.hasCodec(replaced.getMaterial())) {
            try {
                replacedDetails = BlockStateCodecs.toString(replaced.getMaterial(), this.replacedState);
            }
            catch (Exception e) {
                LogBlock.getInstance().getLogger().log(Level.SEVERE, "Could not parse BlockState for " + replaced.getMaterial(), e);
            }
        }
        replacedDetails = replacedDetails == null ? "" : " " + replacedDetails;
        StringBuilder msg = new StringBuilder();
        if (this.date > 0L) {
            msg.append(Config.formatter.format(this.date)).append(" ");
        }
        if (this.actor != null) {
            msg.append(this.actor.getName()).append(" ");
        }
        if (type.equals(replaced)) {
            if (BukkitUtils.isEmpty(type.getMaterial())) {
                msg.append("did an unspecified action");
            } else if (this.ca != null) {
                if (this.ca.itemStack == null) {
                    msg.append("looked inside ").append(type.getMaterial().name());
                } else if (this.ca.remove) {
                    msg.append("took ").append(this.ca.itemStack.getAmount()).append("x ").append(this.ca.itemStack.getType().name()).append(" from ").append(type.getMaterial().name());
                } else {
                    msg.append("put ").append(this.ca.itemStack.getAmount()).append("x ").append(this.ca.itemStack.getType().name()).append(" into ").append(type.getMaterial().name());
                }
            } else if (BukkitUtils.getContainerBlocks().contains(type.getMaterial())) {
                msg.append("opened ").append(type.getMaterial().name());
            } else if (type instanceof Openable) {
                msg.append(((Openable)type).isOpen() ? "opened" : "closed").append(" ").append(type.getMaterial().name());
            } else if (type.getMaterial() == Material.LEVER) {
                msg.append("switched ").append(type.getMaterial().name());
            } else if (type instanceof Switch) {
                msg.append("pressed ").append(type.getMaterial().name());
            } else if (type.getMaterial() == Material.CAKE) {
                msg.append("ate a piece of ").append(type.getMaterial().name());
            } else if (type.getMaterial() == Material.NOTE_BLOCK || type.getMaterial() == Material.REPEATER || type.getMaterial() == Material.COMPARATOR || type.getMaterial() == Material.DAYLIGHT_DETECTOR) {
                msg.append("changed ").append(type.getMaterial().name());
            } else if (type instanceof Powerable) {
                msg.append("stepped on ").append(type.getMaterial().name());
            } else if (type.getMaterial() == Material.TRIPWIRE) {
                msg.append("ran into ").append(type.getMaterial().name());
            }
        } else if (BukkitUtils.isEmpty(type.getMaterial())) {
            msg.append("destroyed ").append(replaced.getMaterial().name()).append(replacedDetails);
        } else if (BukkitUtils.isEmpty(replaced.getMaterial())) {
            msg.append("created ").append(type.getMaterial().name()).append(typeDetails);
        } else {
            msg.append("replaced ").append(replaced.getMaterial().name()).append(replacedDetails).append(" with ").append(type.getMaterial().name()).append(typeDetails);
        }
        if (this.loc != null) {
            msg.append(" at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ());
        }
        return msg.toString();
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

