/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import com.zaxxer.hikari.HikariDataSource;
import de.diddiz.LogBlock.config.Config;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;

public class MySQLConnectionPool
implements Closeable {
    private final HikariDataSource ds = new HikariDataSource();

    public MySQLConnectionPool(String url, String user, String password) throws ClassNotFoundException {
        this.ds.setJdbcUrl(url);
        this.ds.setUsername(user);
        this.ds.setPassword(password);
        this.ds.setMinimumIdle(2);
        this.ds.setPoolName("LogBlock-Connection-Pool");
        this.ds.addDataSourceProperty("useUnicode", "true");
        this.ds.addDataSourceProperty("characterEncoding", "utf-8");
        this.ds.addDataSourceProperty("rewriteBatchedStatements", "true");
        this.ds.addDataSourceProperty("cachePrepStmts", "true");
        this.ds.addDataSourceProperty("prepStmtCacheSize", "250");
        this.ds.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
    }

    @Override
    public void close() {
        this.ds.close();
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.ds.getConnection();
        if (Config.mb4) {
            connection.createStatement().executeQuery("SET NAMES utf8mb4");
        }
        return connection;
    }
}

