/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.logging.AbstractLoggingExtent;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

public class WorldEditLoggingHook {
    private LogBlock plugin;

    public WorldEditLoggingHook(LogBlock plugin) {
        this.plugin = plugin;
    }

    private de.diddiz.LogBlock.Actor AtoA(Actor weActor) {
        if (weActor.isPlayer()) {
            return new de.diddiz.LogBlock.Actor(weActor.getName(), weActor.getUniqueId());
        }
        return new de.diddiz.LogBlock.Actor(weActor.getName());
    }

    private org.bukkit.World adapt(World weWorld) {
        if (weWorld == null) {
            throw new NullPointerException("[Logblock-Worldedit] The provided world was null.");
        }
        if (weWorld instanceof BukkitWorld) {
            return ((BukkitWorld)weWorld).getWorld();
        }
        org.bukkit.World world = Bukkit.getServer().getWorld(weWorld.getName());
        if (world == null) {
            throw new IllegalArgumentException("Can't find a Bukkit world for " + weWorld);
        }
        return world;
    }

    public void hook() {
        WorldEdit.getInstance().getEventBus().register(new Object(){

            @Subscribe
            public void wrapForLogging(final EditSessionEvent event) {
                org.bukkit.World world;
                Actor actor = event.getActor();
                if (actor == null) {
                    return;
                }
                final de.diddiz.LogBlock.Actor lbActor = WorldEditLoggingHook.this.AtoA(actor);
                World k = event.getWorld();
                try {
                    world = WorldEditLoggingHook.this.adapt(k);
                }
                catch (RuntimeException ex) {
                    WorldEditLoggingHook.this.plugin.getLogger().warning("Failed to register logging for WorldEdit!");
                    WorldEditLoggingHook.this.plugin.getLogger().log(Level.WARNING, ex.getMessage(), ex);
                    return;
                }
                if (!Config.isLogging(world, Logging.WORLDEDIT)) {
                    return;
                }
                event.setExtent((Extent)new AbstractLoggingExtent(event.getExtent()){

                    protected void onBlockChange(Vector pt, BaseBlock block) {
                        if (event.getStage() != EditSession.Stage.BEFORE_CHANGE) {
                            return;
                        }
                        Location location = new Location(world, (double)pt.getBlockX(), (double)pt.getBlockY(), (double)pt.getBlockZ());
                        Block origin = location.getBlock();
                        int typeBefore = origin.getTypeId();
                        byte dataBefore = origin.getData();
                        BlockState stateBefore = null;
                        if (typeBefore == Material.SIGN_POST.getId() || typeBefore == Material.SIGN.getId()) {
                            stateBefore = origin.getState();
                        }
                        if (Config.isLogging(location.getWorld().getName(), Logging.SIGNTEXT) && (typeBefore == Material.SIGN_POST.getId() || typeBefore == Material.SIGN.getId())) {
                            WorldEditLoggingHook.this.plugin.getConsumer().queueSignBreak(lbActor, (Sign)stateBefore);
                            if (block.getType() != Material.AIR.getId()) {
                                WorldEditLoggingHook.this.plugin.getConsumer().queueBlockPlace(lbActor, location, block.getType(), (byte)block.getData());
                            }
                        } else if (dataBefore != 0) {
                            WorldEditLoggingHook.this.plugin.getConsumer().queueBlockBreak(lbActor, location, typeBefore, dataBefore);
                            if (block.getType() != Material.AIR.getId()) {
                                WorldEditLoggingHook.this.plugin.getConsumer().queueBlockPlace(lbActor, location, block.getType(), (byte)block.getData());
                            }
                        } else {
                            WorldEditLoggingHook.this.plugin.getConsumer().queueBlock(lbActor, location, typeBefore, block.getType(), (byte)block.getData());
                        }
                    }
                });
            }
        });
    }
}

