/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.material.MaterialData;

public class MaterialName {
    private static final String[] COLORS = new String[]{"white", "orange", "magenta", "light blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final Map<Integer, String> materialNames = new HashMap<Integer, String>();
    private static final Map<Integer, Map<Short, String>> materialDataNames = new HashMap<Integer, Map<Short, String>>();
    private static final Map<String, Integer> nameTypes = new HashMap<String, Integer>();

    public static String materialName(int type) {
        return materialNames.containsKey(type) ? materialNames.get(type) : String.valueOf(type);
    }

    public static String materialName(int type, short data) {
        Map<Short, String> dataNames = materialDataNames.get(type);
        if (dataNames != null && dataNames.containsKey(data)) {
            return dataNames.get(data);
        }
        return MaterialName.materialName(type);
    }

    public static Integer typeFromName(String name) {
        Integer answer = nameTypes.get(MaterialName.toReadable(name));
        if (answer != null) {
            return answer;
        }
        Material mat = Material.matchMaterial((String)name);
        if (mat == null) {
            throw new IllegalArgumentException("No material matching: '" + name + "'");
        }
        return mat.getId();
    }

    private static String toReadable(MaterialData matData) {
        return matData.toString().toLowerCase().replace('_', ' ').replaceAll("[^a-z ]", "");
    }

    private static String toReadable(String matData) {
        return matData.toLowerCase().replace('_', ' ').replaceAll("[^a-z ]", "");
    }

    static {
        for (Material mat : Material.values()) {
            materialNames.put(mat.getId(), mat.toString().replace('_', ' ').toLowerCase());
        }
        File file = new File(LogBlock.getInstance().getDataFolder(), "materials.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        if (cfg.getKeys(false).isEmpty()) {
            byte i;
            cfg.options().header("Add block or item names you want to be overridden or also names for custom blocks");
            cfg.set("1.1", (Object)"granite");
            cfg.set("1.2", (Object)"polished granite");
            cfg.set("1.3", (Object)"diorite");
            cfg.set("1.4", (Object)"polished diorite");
            cfg.set("1.5", (Object)"andesite");
            cfg.set("1.6", (Object)"polished andesite");
            cfg.set("5.0", (Object)"oak wood");
            cfg.set("5.1", (Object)"spruce wood");
            cfg.set("5.2", (Object)"birch wood");
            cfg.set("5.3", (Object)"jungle wood");
            cfg.set("5.4", (Object)"acacia wood");
            cfg.set("5.5", (Object)"dark oak wood");
            cfg.set("3.1", (Object)"coarse dirt");
            cfg.set("3.2", (Object)"podzol");
            cfg.set("6.1", (Object)"redwood sapling");
            cfg.set("6.2", (Object)"birch sapling");
            cfg.set("6.3", (Object)"jungle sapling");
            cfg.set("6.4", (Object)"acacia sapling");
            cfg.set("6.5", (Object)"dark oak sapling");
            cfg.set("9", (Object)"water");
            cfg.set("11", (Object)"lava");
            cfg.set("12.1", (Object)"red sand");
            cfg.set("17.0", (Object)"oak log");
            cfg.set("17.1", (Object)"spruce log");
            cfg.set("17.2", (Object)"birch log");
            cfg.set("17.3", (Object)"jungle log");
            cfg.set("17.4", (Object)"oak log");
            cfg.set("17.5", (Object)"spruce log");
            cfg.set("17.6", (Object)"birch log");
            cfg.set("17.7", (Object)"jungle log");
            cfg.set("17.8", (Object)"oak log");
            cfg.set("17.9", (Object)"spruce log");
            cfg.set("17.10", (Object)"birch log");
            cfg.set("17.11", (Object)"jungle log");
            cfg.set("17.12", (Object)"oak log");
            cfg.set("17.13", (Object)"spruce log");
            cfg.set("17.14", (Object)"birch log");
            cfg.set("17.15", (Object)"jungle log");
            cfg.set("18.1", (Object)"spruce leaves");
            cfg.set("18.2", (Object)"birch leaves");
            cfg.set("18.3", (Object)"jungle leaves");
            cfg.set("18.4", (Object)"oak leaves");
            cfg.set("18.5", (Object)"spruce leaves");
            cfg.set("18.6", (Object)"birch leaves");
            cfg.set("18.7", (Object)"jungle leaves");
            cfg.set("18.8", (Object)"oak leaves");
            cfg.set("18.9", (Object)"spruce leaves");
            cfg.set("18.10", (Object)"birch leaves");
            cfg.set("18.11", (Object)"jungle leaves");
            cfg.set("18.12", (Object)"oak leaves");
            cfg.set("18.13", (Object)"spruce leaves");
            cfg.set("18.14", (Object)"birch leaves");
            cfg.set("18.15", (Object)"jungle leaves");
            cfg.set("19.1", (Object)"wet sponge");
            cfg.set("37.0", (Object)"dandelion");
            cfg.set("38.0", (Object)"poppy");
            cfg.set("38.1", (Object)"blue orchid");
            cfg.set("38.2", (Object)"allium");
            cfg.set("38.3", (Object)"azure bluet");
            cfg.set("38.4", (Object)"red tulip");
            cfg.set("38.5", (Object)"orange tulip");
            cfg.set("38.6", (Object)"white tulip");
            cfg.set("38.7", (Object)"pink tulip");
            cfg.set("38.8", (Object)"oxeye daisy");
            cfg.set("24.1", (Object)"chiseled sandstone");
            cfg.set("24.2", (Object)"smooth sandstone");
            cfg.set("31.0", (Object)"dead bush");
            cfg.set("31.1", (Object)"tall grass");
            cfg.set("31.2", (Object)"fern");
            cfg.set("98.0", (Object)"stone brick");
            cfg.set("98.1", (Object)"mossy stone brick");
            cfg.set("98.2", (Object)"cracked stone brick");
            cfg.set("98.3", (Object)"chiseled stone brick");
            cfg.set("125.0", (Object)"oak double step");
            cfg.set("125.1", (Object)"spruce double step");
            cfg.set("125.2", (Object)"birch double step");
            cfg.set("125.3", (Object)"jungle double step");
            cfg.set("125.4", (Object)"acacia double step");
            cfg.set("125.5", (Object)"dark oak double step");
            cfg.set("126.0", (Object)"oak step");
            cfg.set("126.1", (Object)"spruce step");
            cfg.set("126.2", (Object)"birch step");
            cfg.set("126.3", (Object)"jungle step");
            cfg.set("126.4", (Object)"acacia step");
            cfg.set("126.5", (Object)"dark oak step");
            cfg.set("126.8", (Object)"oak step");
            cfg.set("126.9", (Object)"spruce step");
            cfg.set("126.10", (Object)"birch step");
            cfg.set("126.11", (Object)"jungle step");
            cfg.set("126.12", (Object)"acacia step");
            cfg.set("126.13", (Object)"dark oak step");
            cfg.set("139.1", (Object)"mossy cobble wall");
            cfg.set("155.1", (Object)"chiseled quartz block");
            cfg.set("155.2", (Object)"pillar quartz block");
            cfg.set("155.3", (Object)"pillar quartz block");
            cfg.set("155.4", (Object)"pillar quartz block");
            cfg.set("161.0", (Object)"acacia leaves");
            cfg.set("161.1", (Object)"dark oak leaves");
            cfg.set("161.4", (Object)"acacia leaves");
            cfg.set("161.5", (Object)"dark oak leaves");
            cfg.set("161.8", (Object)"acacia leaves");
            cfg.set("161.9", (Object)"dark oak leaves");
            cfg.set("161.12", (Object)"acacia leaves");
            cfg.set("161.13", (Object)"dark oak leaves");
            cfg.set("162.0", (Object)"acacia log");
            cfg.set("162.1", (Object)"dark oak log");
            cfg.set("162.4", (Object)"acacia log");
            cfg.set("162.5", (Object)"dark oak log");
            cfg.set("162.8", (Object)"acacia log");
            cfg.set("162.9", (Object)"dark oak log");
            cfg.set("162.12", (Object)"acacia log");
            cfg.set("162.13", (Object)"dark oak log");
            cfg.set("168.1", (Object)"prismarine brick");
            cfg.set("168.2", (Object)"dark prismarine");
            cfg.set("181.0", (Object)"red sandstone double step");
            cfg.set("181.8", (Object)"smooth red sandstone double step");
            cfg.set("162.13", (Object)"dark oak log");
            cfg.set("175.0", (Object)"sunflower");
            cfg.set("175.1", (Object)"lilac");
            cfg.set("175.2", (Object)"double tall grass");
            cfg.set("175.3", (Object)"large fern");
            cfg.set("175.4", (Object)"rose bush");
            cfg.set("175.5", (Object)"peony");
            cfg.set("175.8", (Object)"sunflower");
            cfg.set("175.9", (Object)"lilac");
            cfg.set("175.10", (Object)"double tall grass");
            cfg.set("175.11", (Object)"large fern");
            cfg.set("175.12", (Object)"rose bush");
            cfg.set("175.13", (Object)"peony");
            cfg.set("179.1", (Object)"chiseled sandstone");
            cfg.set("179.2", (Object)"smooth sandstone");
            cfg.set("263.1", (Object)"charcoal");
            for (i = 0; i < 10; i = (byte)(i + 1)) {
                cfg.set("43." + i, (Object)MaterialName.toReadable(Material.DOUBLE_STEP.getNewData(i)));
            }
            cfg.set("43.8", (Object)"stone double step");
            cfg.set("43.9", (Object)"sandstone double step");
            cfg.set("43.15", (Object)"quartz double step");
            for (i = 0; i < 8; i = (byte)(i + 1)) {
                cfg.set("44." + i, (Object)MaterialName.toReadable(Material.STEP.getNewData(i)));
                cfg.set("44." + (i + 7), (Object)MaterialName.toReadable(Material.STEP.getNewData(i)));
            }
            for (i = 0; i < 16; i = (byte)(i + 1)) {
                cfg.set("351." + i, (Object)MaterialName.toReadable(Material.INK_SACK.getNewData(i)));
                cfg.set("35." + i, (Object)(COLORS[i] + " wool"));
                cfg.set("159." + i, (Object)(COLORS[i] + " stained terracotta"));
                cfg.set("95." + i, (Object)(COLORS[i] + " stained glass"));
                cfg.set("160." + i, (Object)(COLORS[i] + " stained glass pane"));
                cfg.set("171." + i, (Object)(COLORS[i] + " carpet"));
                cfg.set("251." + i, (Object)(COLORS[i] + " concrete"));
                cfg.set("252." + i, (Object)(COLORS[i] + " concrete powder"));
            }
            for (i = 0; i < 6; i = (byte)(i + 1)) {
                cfg.set("125." + i, (Object)MaterialName.toReadable(Material.WOOD_DOUBLE_STEP.getNewData(i)));
                cfg.set("126." + i, (Object)MaterialName.toReadable(Material.WOOD_STEP.getNewData(i)));
                cfg.set("126." + i + 8, (Object)MaterialName.toReadable(Material.WOOD_STEP.getNewData(i)));
            }
            try {
                cfg.save(file);
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Unable to save material.yml: ", ex);
            }
        }
        if (cfg.getString("252.1") == null) {
            Bukkit.getLogger().info("[Logblock-names] Logblock's default materials.yml file has been updated with more names");
            Bukkit.getLogger().info("[Logblock-names] Consider deleting your current materials.yml file to allow it to be recreated");
        }
        for (String entry : cfg.getKeys(false)) {
            if (Utils.isInt(entry)) {
                if (cfg.isString(entry)) {
                    materialNames.put(Integer.valueOf(entry), cfg.getString(entry));
                    nameTypes.put(cfg.getString(entry), Integer.valueOf(entry));
                    continue;
                }
                if (cfg.isConfigurationSection(entry)) {
                    HashMap<Short, String> dataNames = new HashMap<Short, String>();
                    materialDataNames.put(Integer.valueOf(entry), dataNames);
                    ConfigurationSection sec = cfg.getConfigurationSection(entry);
                    for (String data : sec.getKeys(false)) {
                        if (Utils.isShort(data)) {
                            if (sec.isString(data)) {
                                dataNames.put(Short.valueOf(data), sec.getString(data));
                                nameTypes.put(sec.getString(data), Integer.valueOf(entry));
                                continue;
                            }
                            Bukkit.getLogger().warning("Parsing materials.yml: '" + data + "' is not a string.");
                            continue;
                        }
                        Bukkit.getLogger().warning("Parsing materials.yml: '" + data + "' is no valid material data");
                    }
                    continue;
                }
                Bukkit.getLogger().warning("Parsing materials.yml: '" + entry + "' is neither a string nor a section.");
                continue;
            }
            Bukkit.getLogger().warning("Parsing materials.yml: '" + entry + "' is no valid material id");
        }
    }
}

