/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.projectiles.ProjectileSource;

public class ExplosionLogging
extends LoggingListener {
    public ExplosionLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getLocation().getWorld());
        if (wcfg != null) {
            Actor actor = new Actor("Explosion");
            Entity source = event.getEntity();
            if (source == null) {
                if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                    return;
                }
            } else if (source instanceof TNTPrimed) {
                if (!wcfg.isLogging(Logging.TNTEXPLOSION)) {
                    return;
                }
                actor = new Actor("TNT");
            } else if (source instanceof ExplosiveMinecart) {
                if (!wcfg.isLogging(Logging.TNTMINECARTEXPLOSION)) {
                    return;
                }
                actor = new Actor("TNTMinecart");
            } else if (source instanceof Creeper) {
                if (!wcfg.isLogging(Logging.CREEPEREXPLOSION)) {
                    return;
                }
                if (Config.logCreeperExplosionsAsPlayerWhoTriggeredThese) {
                    LivingEntity target = ((Creeper)source).getTarget();
                    actor = target instanceof Player ? Actor.actorFromEntity((Entity)target) : new Actor("Creeper");
                } else {
                    new Actor("Creeper");
                }
            } else if (source instanceof Fireball) {
                Fireball fireball = (Fireball)source;
                ProjectileSource shooter = fireball.getShooter();
                if (shooter == null) {
                    return;
                }
                if (shooter instanceof Ghast) {
                    if (!wcfg.isLogging(Logging.GHASTFIREBALLEXPLOSION)) {
                        return;
                    }
                    actor = Actor.actorFromProjectileSource(shooter);
                } else if (shooter instanceof Wither) {
                    if (!wcfg.isLogging(Logging.WITHER)) {
                        return;
                    }
                    actor = Actor.actorFromProjectileSource(shooter);
                }
            } else if (source instanceof EnderDragon) {
                if (!wcfg.isLogging(Logging.ENDERDRAGON)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (source instanceof Wither) {
                if (!wcfg.isLogging(Logging.WITHER)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (source instanceof WitherSkull) {
                if (!wcfg.isLogging(Logging.WITHER_SKULL)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (source instanceof EnderCrystal) {
                if (!wcfg.isLogging(Logging.ENDERCRYSTALEXPLOSION)) {
                    return;
                }
                actor = Actor.actorFromEntity(source);
            } else if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                return;
            }
            for (Block block : event.blockList()) {
                int type = block.getTypeId();
                if (wcfg.isLogging(Logging.SIGNTEXT) & (type == 63 || type == 68)) {
                    this.consumer.queueSignBreak(actor, (Sign)block.getState());
                    continue;
                }
                if (wcfg.isLogging(Logging.CHESTACCESS) && BukkitUtils.getContainerBlocks().contains(Material.getMaterial((int)type))) {
                    this.consumer.queueContainerBreak(actor, block.getState());
                    continue;
                }
                this.consumer.queueBlockBreak(actor, block.getState());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        for (Block block : event.blockList()) {
            WorldConfig wcfg = Config.getWorldConfig(block.getLocation().getWorld());
            if (wcfg == null) continue;
            if (!wcfg.isLogging(Logging.MISCEXPLOSION)) {
                return;
            }
            Actor actor = new Actor("Explosion");
            int type = block.getTypeId();
            if (wcfg.isLogging(Logging.SIGNTEXT) & (type == 63 || type == 68)) {
                this.consumer.queueSignBreak(actor, (Sign)block.getState());
                continue;
            }
            if (wcfg.isLogging(Logging.CHESTACCESS) && BukkitUtils.getContainerBlocks().contains(Material.getMaterial((int)type))) {
                this.consumer.queueContainerBreak(actor, block.getState());
                continue;
            }
            this.consumer.queueBlockBreak(actor, block.getState());
        }
    }
}

