/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.BaseCheckName;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckWrittenBookContent
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:written_book_content");
    private boolean allow;
    private boolean allowFormating;
    private int pageTextMaxLength;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", false);
        this.allowFormating = ConfigUtil.getOrCreate(data, "allow_formating", false);
        this.pageTextMaxLength = ConfigUtil.getOrCreate(data, "page_text_max_length", 10000);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        CompoundTag compound = itemComponentsTag.getCompound(key);
        if (!this.allow || compound == null) {
            itemComponentsTag.remove(key);
            changed = true;
        } else {
            ListTag pages = compound.getList("pages");
            if (pages != null) {
                int pageCount;
                for (pageCount = pages.size(); pageCount > 100; --pageCount) {
                    pages.remove(pageCount - 1);
                    changed = true;
                }
                for (int i = 0; i < pageCount; ++i) {
                    CompoundTag page = pages.getCompound(i);
                    if (page == null) continue;
                    if (BaseCheckName.enforce(page, "raw", true, this.allowFormating, this.pageTextMaxLength, group.getMaxComponentExpansions())) {
                        changed = true;
                    }
                    if (!BaseCheckName.enforce(page, "filtered", true, this.allowFormating, this.pageTextMaxLength, group.getMaxComponentExpansions())) continue;
                    changed = true;
                }
            }
        }
        return changed;
    }
}

