/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.cause.Cause;
import com.sk89q.worldguard.bukkit.event.DelegateEvent;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.event.entity.DamageEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.DestroyEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.SpawnEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.UseEntityEvent;
import com.sk89q.worldguard.bukkit.internal.WGMetadata;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.bukkit.protection.events.DisallowedPVPEvent;
import com.sk89q.worldguard.bukkit.util.Entities;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.bukkit.util.InteropUtils;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.config.WorldConfiguration;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.internal.permission.RegionPermissionModel;
import com.sk89q.worldguard.protection.DelayedRegionOverlapAssociation;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.metadata.Metadatable;

public class RegionProtectionListener
extends AbstractListener {
    private static final String DENY_MESSAGE_KEY = "worldguard.region.lastMessage";
    private static final String DISEMBARK_MESSAGE_KEY = "worldguard.region.disembarkMessage";
    private static final int LAST_MESSAGE_DELAY = 500;

    public RegionProtectionListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    private void tellErrorMessage(DelegateEvent event, Cause cause, Location location, String what) {
        if (event.isSilent() || cause.isIndirect()) {
            return;
        }
        Object rootCause = cause.getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
            long now = System.currentTimeMillis();
            Long lastTime = WGMetadata.getIfPresent((Metadatable)player, DENY_MESSAGE_KEY, Long.class);
            if (lastTime == null || now - lastTime >= 500L) {
                RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
                String message = (String)query.queryValue(BukkitAdapter.adapt((Location)location), localPlayer, (Flag)Flags.DENY_MESSAGE);
                message = WorldGuard.getInstance().getPlatform().getMatcher().replaceMacros((Actor)localPlayer, message);
                if ((message = CommandUtils.replaceColorMacros((String)message)) != null && !message.isEmpty()) {
                    player.sendMessage(message.replace("%what%", what));
                }
                WGMetadata.put((Metadatable)player, DENY_MESSAGE_KEY, now);
            }
        }
    }

    private boolean isWhitelisted(Cause cause, org.bukkit.World world, boolean pvp) {
        Object rootCause = cause.getRootCause();
        if (rootCause instanceof Block) {
            Material type = ((Block)rootCause).getType();
            return type == Material.HOPPER || type == Material.DROPPER;
        }
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            WorldConfiguration config = this.getWorldConfig(BukkitAdapter.adapt((org.bukkit.World)world));
            if (config.fakePlayerBuildOverride && InteropUtils.isFakePlayer(player)) {
                return true;
            }
            return !pvp && new RegionPermissionModel((Actor)localPlayer).mayIgnoreRegionProtection(BukkitAdapter.adapt((org.bukkit.World)world));
        }
        return false;
    }

    private RegionAssociable createRegionAssociable(Cause cause) {
        Object rootCause = cause.getRootCause();
        if (!cause.isKnown()) {
            return Associables.constant((Association)Association.NON_MEMBER);
        }
        if (rootCause instanceof Player) {
            return this.getPlugin().wrapPlayer((Player)rootCause);
        }
        if (rootCause instanceof OfflinePlayer) {
            return this.getPlugin().wrapOfflinePlayer((OfflinePlayer)rootCause);
        }
        if (rootCause instanceof Entity) {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            return new DelayedRegionOverlapAssociation(query, BukkitAdapter.adapt((Location)((Entity)rootCause).getLocation()));
        }
        if (rootCause instanceof Block) {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            return new DelayedRegionOverlapAssociation(query, BukkitAdapter.adapt((Location)((Block)rootCause).getLocation()));
        }
        return Associables.constant((Association)Association.NON_MEMBER);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlaceBlock(PlaceBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Material type = event.getEffectiveMaterial();
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        if (event.getCause().getRootCause() instanceof Block && Materials.isLiquid(type) && !this.getWorldConfig((World)BukkitAdapter.adapt((org.bukkit.World)event.getWorld())).checkLiquidFlow) {
            return;
        }
        event.filter((Predicate)((com.google.common.base.Predicate)target -> {
            String what;
            boolean canPlace;
            if (type == Material.FIRE) {
                Block block = event.getCause().getFirstBlock();
                boolean fire = block != null && block.getType() == Material.FIRE;
                boolean lava = block != null && Materials.isLava(block.getType());
                ArrayList<StateFlag> flags = new ArrayList<StateFlag>();
                flags.add(Flags.BLOCK_PLACE);
                flags.add(Flags.LIGHTER);
                if (fire) {
                    flags.add(Flags.FIRE_SPREAD);
                }
                if (lava) {
                    flags.add(Flags.LAVA_FIRE);
                }
                canPlace = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, flags.toArray(new StateFlag[flags.size()])));
                what = "place fire";
            } else {
                canPlace = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.BLOCK_PLACE));
                try {
                    event.setSilent(type == Material.FROSTED_ICE);
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                what = "place that block";
            }
            if (!canPlace) {
                this.tellErrorMessage(event, event.getCause(), (Location)target, what);
                return false;
            }
            return true;
        }));
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreakBlock(BreakBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        if (!event.isCancelled()) {
            RegionAssociable associable = this.createRegionAssociable(event.getCause());
            event.filter((Predicate)((com.google.common.base.Predicate)target -> {
                String what;
                boolean canBreak;
                if (event.getCause().find(EntityType.PRIMED_TNT, EntityType.MINECART_TNT) != null) {
                    canBreak = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.BLOCK_BREAK, Flags.TNT));
                    what = "use dynamite";
                } else {
                    canBreak = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.BLOCK_BREAK));
                    what = "break that block";
                }
                if (!canBreak) {
                    this.tellErrorMessage(event, event.getCause(), (Location)target, what);
                    return false;
                }
                return true;
            }));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseBlock(UseBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Material type = event.getEffectiveMaterial();
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        event.filter((Predicate)((com.google.common.base.Predicate)target -> {
            String what;
            boolean canUse;
            if (Materials.isConsideredBuildingIfUsed(type)) {
                canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, new StateFlag[0]));
                what = "use that";
            } else if (Materials.isInventoryBlock(type)) {
                canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.INTERACT, Flags.CHEST_ACCESS));
                what = "open that";
            } else if (Materials.isBed(type)) {
                canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.INTERACT, Flags.SLEEP));
                what = "sleep";
            } else if (type == Material.TNT) {
                canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.INTERACT, Flags.TNT));
                what = "use explosives";
            } else if (Materials.isUseFlagApplicable(type)) {
                canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.INTERACT, Flags.USE));
                what = "use that";
            } else {
                canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.INTERACT));
                what = "use that";
            }
            if (!canUse) {
                this.tellErrorMessage(event, event.getCause(), (Location)target, what);
                return false;
            }
            return true;
        }));
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpawnEntity(SpawnEntityEvent event) {
        String what;
        boolean canSpawn;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Location target = event.getTarget();
        EntityType type = event.getEffectiveType();
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        if (Entities.isVehicle(type)) {
            canSpawn = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.PLACE_VEHICLE));
            what = "place vehicles";
        } else if (event.getEntity() instanceof Item) {
            canSpawn = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.ITEM_DROP));
            what = "drop items";
        } else if (type == EntityType.EXPERIENCE_ORB) {
            canSpawn = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.EXP_DROPS));
            what = "drop XP";
        } else if (Entities.isAoECloud(type)) {
            canSpawn = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.POTION_SPLASH));
            what = "use lingering potions";
        } else {
            canSpawn = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = event.getEntity() instanceof Item ? "drop items" : "place things";
        }
        if (!canSpawn) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDestroyEntity(DestroyEntityEvent event) {
        String what;
        boolean canDestroy;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Location target = event.getTarget();
        EntityType type = event.getEntity().getType();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        if (Entities.isVehicle(type)) {
            canDestroy = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.DESTROY_VEHICLE));
            what = "break vehicles";
        } else if (event.getEntity() instanceof Item || event.getEntity() instanceof ExperienceOrb) {
            canDestroy = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.ITEM_PICKUP));
            what = "pick up items";
        } else {
            canDestroy = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = "break things";
        }
        if (!canDestroy) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseEntity(UseEntityEvent event) {
        String what;
        boolean canUse;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Location target = event.getTarget();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        if (Entities.isHostile(event.getEntity()) || Entities.isAmbient(event.getEntity()) || Entities.isNPC(event.getEntity()) || Entities.isVehicle(event.getEntity().getType())) {
            canUse = event.getRelevantFlags().isEmpty() || query.queryState(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, new StateFlag[0])) != StateFlag.State.DENY;
            what = "use that";
        } else if (Entities.isConsideredBuildingIfUsed(event.getEntity())) {
            canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = "change that";
        } else if (Entities.isRiddenOnUse(event.getEntity())) {
            canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.RIDE, Flags.INTERACT));
            what = "ride that";
        } else {
            canUse = query.testBuild(BukkitAdapter.adapt((Location)target), associable, RegionProtectionListener.combine(event, Flags.INTERACT));
            what = "use that";
        }
        if (!canUse) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageEntity(DamageEntityEvent event) {
        String what;
        boolean canDamage;
        boolean pvp;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)event.getWorld()))) {
            return;
        }
        com.sk89q.worldedit.util.Location target = BukkitAdapter.adapt((Location)event.getTarget());
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        Player playerAttacker = event.getCause().getFirstPlayer();
        boolean bl = pvp = event.getEntity() instanceof Player && playerAttacker != null && !playerAttacker.equals(event.getEntity());
        if (this.isWhitelisted(event.getCause(), event.getWorld(), pvp)) {
            return;
        }
        if (Entities.isHostile(event.getEntity()) || Entities.isAmbient(event.getEntity()) || Entities.isVehicle(event.getEntity().getType())) {
            canDamage = event.getRelevantFlags().isEmpty() || query.queryState(target, associable, RegionProtectionListener.combine(event, new StateFlag[0])) != StateFlag.State.DENY;
            what = "hit that";
        } else if (Entities.isConsideredBuildingIfUsed(event.getEntity())) {
            canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = "change that";
        } else if (pvp) {
            LocalPlayer localAttacker = WorldGuardPlugin.inst().wrapPlayer(playerAttacker);
            Player defender = (Player)event.getEntity();
            if (Entities.isNPC((Entity)defender)) {
                return;
            }
            boolean bl2 = canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, Flags.PVP)) && query.queryState(localAttacker.getLocation(), localAttacker, RegionProtectionListener.combine(event, Flags.PVP)) != StateFlag.State.DENY && query.queryState(target, localAttacker, RegionProtectionListener.combine(event, Flags.PVP)) != StateFlag.State.DENY;
            if (!canDamage && Events.fireAndTestCancel(new DisallowedPVPEvent(playerAttacker, defender, event.getOriginalEvent()))) {
                canDamage = true;
            }
            what = "PvP";
        } else if (event.getEntity() instanceof Player) {
            canDamage = event.getRelevantFlags().isEmpty() || query.queryState(target, associable, RegionProtectionListener.combine(event, new StateFlag[0])) != StateFlag.State.DENY;
            what = "damage that";
        } else if (Entities.isNonHostile(event.getEntity())) {
            canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, Flags.DAMAGE_ANIMALS));
            what = "harm that";
        } else {
            canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, Flags.INTERACT));
            what = "hit that";
        }
        if (!canDamage) {
            this.tellErrorMessage(event, event.getCause(), event.getTarget(), what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleExit(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!this.isRegionSupportEnabled(BukkitAdapter.adapt((org.bukkit.World)vehicle.getWorld()))) {
            return;
        }
        LivingEntity exited = event.getExited();
        if (vehicle instanceof Tameable && exited instanceof Player) {
            Location location;
            RegionQuery query;
            Player player = (Player)exited;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (!this.isWhitelisted(Cause.create(player), vehicle.getWorld(), false) && !(query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery()).testBuild(BukkitAdapter.adapt((Location)(location = vehicle.getLocation())), localPlayer, new StateFlag[]{Flags.RIDE, Flags.INTERACT})) {
                long now = System.currentTimeMillis();
                Long lastTime = WGMetadata.getIfPresent((Metadatable)player, DISEMBARK_MESSAGE_KEY, Long.class);
                if (lastTime == null || now - lastTime >= 500L) {
                    player.sendMessage("" + ChatColor.GOLD + "Don't disembark here!" + ChatColor.GRAY + " You can't get back on.");
                    WGMetadata.put((Metadatable)player, DISEMBARK_MESSAGE_KEY, now);
                }
                event.setCancelled(true);
            }
        }
    }

    private boolean isWhitelistedEntity(Entity entity) {
        return Entities.isNonPlayerCreature(entity);
    }

    private static StateFlag[] combine(DelegateEvent event, StateFlag ... flag) {
        List<StateFlag> extra = event.getRelevantFlags();
        StateFlag[] flags = Arrays.copyOf(flag, flag.length + extra.size());
        for (int i = 0; i < extra.size(); ++i) {
            flags[flag.length + i] = extra.get(i);
        }
        return flags;
    }
}

