/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverter;
import com.sk89q.worldedit.util.formatting.Style;
import com.sk89q.worldedit.util.paste.ActorCallbackPaste;
import com.sk89q.worldedit.util.task.Supervisor;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.debug.CancelLogging;
import com.sk89q.worldguard.bukkit.event.debug.LoggingBlockBreakEvent;
import com.sk89q.worldguard.bukkit.event.debug.LoggingBlockPlaceEvent;
import com.sk89q.worldguard.bukkit.event.debug.LoggingEntityDamageByEntityEvent;
import com.sk89q.worldguard.bukkit.event.debug.LoggingPlayerInteractEvent;
import com.sk89q.worldguard.bukkit.util.report.CancelReport;
import com.sk89q.worldguard.internal.platform.DebugHandler;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.BlockIterator;

public class BukkitDebugHandler
implements DebugHandler {
    private static final Logger log = Logger.getLogger(BukkitDebugHandler.class.getCanonicalName());
    private static final int MAX_TRACE_DISTANCE = 20;
    private final WorldGuardPlugin plugin;

    BukkitDebugHandler(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    private <T extends Event> void testEvent(CommandSender receiver, org.bukkit.entity.Player target, T event, boolean stacktraceMode) throws CommandPermissionsException {
        boolean isConsole = receiver instanceof ConsoleCommandSender;
        if (!receiver.equals(target)) {
            if (!isConsole) {
                log.info(receiver.getName() + " is simulating an event on " + target.getName());
            }
            target.sendMessage(ChatColor.RED + "(Please ignore any messages that may immediately follow.)");
        }
        Bukkit.getPluginManager().callEvent(event);
        int start = new Exception().getStackTrace().length;
        CancelReport report = new CancelReport(event, ((CancelLogging)event).getCancels(), start);
        report.setDetectingPlugin(!stacktraceMode);
        String result = report.toString();
        if (stacktraceMode) {
            receiver.sendMessage(ChatColor.GRAY + "The report was printed to console.");
            log.info("Event report for " + receiver.getName() + ":\n\n" + result);
            this.plugin.checkPermission(receiver, "worldguard.debug.pastebin");
            ActorCallbackPaste.pastebin((Supervisor)WorldGuard.getInstance().getSupervisor(), (Actor)this.plugin.wrapCommandSender(receiver), (String)result, (String)"Event debugging report: %s.txt", (ExceptionConverter)WorldGuard.getInstance().getExceptionConverter());
        } else {
            receiver.sendMessage(result.replaceAll("(?m)^", ChatColor.AQUA.toString()));
            if (result.length() >= 500 && !isConsole) {
                receiver.sendMessage(ChatColor.GRAY + "The report was also printed to console.");
                log.info("Event report for " + receiver.getName() + ":\n\n" + result);
            }
        }
    }

    private org.bukkit.entity.Player getSource(CommandSender sender, org.bukkit.entity.Player target, boolean fromTarget) throws CommandException {
        if (fromTarget) {
            return target;
        }
        if (sender instanceof org.bukkit.entity.Player) {
            return (org.bukkit.entity.Player)sender;
        }
        throw new CommandException("If this command is not to be used in-game, use -t to run the test from the viewpoint of the given player rather than yourself.");
    }

    private Block traceBlock(CommandSender sender, org.bukkit.entity.Player target, boolean fromTarget) throws CommandException {
        org.bukkit.entity.Player source = this.getSource(sender, target, fromTarget);
        BlockIterator it = new BlockIterator((LivingEntity)source);
        for (int i = 0; it.hasNext() && i < 20; ++i) {
            Block block = it.next();
            if (block.getType() == Material.AIR) continue;
            return block;
        }
        throw new CommandException("Not currently looking at a block that is close enough.");
    }

    private Entity traceEntity(CommandSender sender, org.bukkit.entity.Player target, boolean fromTarget) throws CommandException {
        org.bukkit.entity.Player source = this.getSource(sender, target, fromTarget);
        BlockIterator it = new BlockIterator((LivingEntity)source);
        for (int i = 0; it.hasNext() && i < 20; ++i) {
            Entity[] entities;
            Block block = it.next();
            for (Entity entity : entities = block.getChunk().getEntities()) {
                if (entity.equals(target) || !(entity.getLocation().distanceSquared(block.getLocation()) < 10.0)) continue;
                return entity;
            }
        }
        throw new CommandException("Not currently looking at an entity that is close enough.");
    }

    public void testBreak(Actor sender, LocalPlayer target, boolean fromTarget, boolean stackTraceMode) throws CommandException {
        CommandSender bukkitSender = this.plugin.unwrapActor(sender);
        org.bukkit.entity.Player bukkitTarget = BukkitAdapter.adapt((Player)target);
        Block block = this.traceBlock(bukkitSender, bukkitTarget, fromTarget);
        sender.printRaw(Style.CYAN + "Testing BLOCK BREAK at " + Style.CYAN_DARK + block);
        LoggingBlockBreakEvent event = new LoggingBlockBreakEvent(block, bukkitTarget);
        this.testEvent(bukkitSender, bukkitTarget, event, stackTraceMode);
    }

    public void testPlace(Actor sender, LocalPlayer target, boolean fromTarget, boolean stackTraceMode) throws CommandException {
        CommandSender bukkitSender = this.plugin.unwrapActor(sender);
        org.bukkit.entity.Player bukkitTarget = BukkitAdapter.adapt((Player)target);
        Block block = this.traceBlock(bukkitSender, bukkitTarget, fromTarget);
        sender.printRaw(Style.CYAN + "Testing BLOCK PLACE at " + Style.CYAN_DARK + block);
        LoggingBlockPlaceEvent event = new LoggingBlockPlaceEvent(block, block.getState(), block.getRelative(BlockFace.DOWN), bukkitTarget.getItemInHand(), bukkitTarget, true);
        this.testEvent(bukkitSender, bukkitTarget, event, stackTraceMode);
    }

    public void testInteract(Actor sender, LocalPlayer target, boolean fromTarget, boolean stackTraceMode) throws CommandException {
        CommandSender bukkitSender = this.plugin.unwrapActor(sender);
        org.bukkit.entity.Player bukkitTarget = BukkitAdapter.adapt((Player)target);
        Block block = this.traceBlock(bukkitSender, bukkitTarget, fromTarget);
        sender.printRaw(Style.CYAN + "Testing BLOCK INTERACT at " + Style.CYAN_DARK + block);
        LoggingPlayerInteractEvent event = new LoggingPlayerInteractEvent(bukkitTarget, Action.RIGHT_CLICK_BLOCK, bukkitTarget.getItemInHand(), block, BlockFace.SOUTH);
        this.testEvent(bukkitSender, bukkitTarget, event, stackTraceMode);
    }

    public void testDamage(Actor sender, LocalPlayer target, boolean fromTarget, boolean stackTraceMode) throws CommandException {
        CommandSender bukkitSender = this.plugin.unwrapActor(sender);
        org.bukkit.entity.Player bukkitTarget = BukkitAdapter.adapt((Player)target);
        Entity entity = this.traceEntity(bukkitSender, bukkitTarget, fromTarget);
        sender.printRaw(Style.CYAN + "Testing ENTITY DAMAGE on " + Style.CYAN_DARK + entity);
        LoggingEntityDamageByEntityEvent event = new LoggingEntityDamageByEntityEvent((Entity)bukkitTarget, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, 1.0);
        this.testEvent(bukkitSender, bukkitTarget, event, stackTraceMode);
    }
}

