/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.material.Bed;
import org.bukkit.material.Chest;
import org.bukkit.material.MaterialData;

public final class Blocks {
    private Blocks() {
    }

    public static List<Block> getConnected(Block block) {
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Bed) {
            Bed bed = (Bed)data;
            if (bed.isHeadOfBed()) {
                return Collections.singletonList(block.getRelative(bed.getFacing().getOppositeFace()));
            }
            return Collections.singletonList(block.getRelative(bed.getFacing()));
        }
        if (data instanceof Chest) {
            BlockFace facing = ((Chest)data).getFacing();
            ArrayList<Block> chests = new ArrayList<Block>();
            if (facing == BlockFace.NORTH || facing == BlockFace.SOUTH) {
                if (block.getRelative(BlockFace.EAST).getState().getData() instanceof Chest) {
                    chests.add(block.getRelative(BlockFace.EAST));
                }
                if (block.getRelative(BlockFace.WEST).getState().getData() instanceof Chest) {
                    chests.add(block.getRelative(BlockFace.WEST));
                }
            } else if (facing == BlockFace.EAST || facing == BlockFace.WEST) {
                if (block.getRelative(BlockFace.NORTH).getState().getData() instanceof Chest) {
                    chests.add(block.getRelative(BlockFace.NORTH));
                }
                if (block.getRelative(BlockFace.SOUTH).getState().getData() instanceof Chest) {
                    chests.add(block.getRelative(BlockFace.SOUTH));
                }
            } else {
                return Collections.emptyList();
            }
            return chests;
        }
        return Collections.emptyList();
    }
}

