/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.commands.AsyncCommandHelper;
import com.sk89q.worldguard.util.paste.EngineHubPaste;
import java.net.URL;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public final class CommandUtils {
    private static final Logger log = Logger.getLogger(CommandUtils.class.getCanonicalName());

    private CommandUtils() {
    }

    public static String replaceColorMacros(String str) {
        str = str.replace("`r", ChatColor.RED.toString());
        str = str.replace("`R", ChatColor.DARK_RED.toString());
        str = str.replace("`y", ChatColor.YELLOW.toString());
        str = str.replace("`Y", ChatColor.GOLD.toString());
        str = str.replace("`g", ChatColor.GREEN.toString());
        str = str.replace("`G", ChatColor.DARK_GREEN.toString());
        str = str.replace("`c", ChatColor.AQUA.toString());
        str = str.replace("`C", ChatColor.DARK_AQUA.toString());
        str = str.replace("`b", ChatColor.BLUE.toString());
        str = str.replace("`B", ChatColor.DARK_BLUE.toString());
        str = str.replace("`p", ChatColor.LIGHT_PURPLE.toString());
        str = str.replace("`P", ChatColor.DARK_PURPLE.toString());
        str = str.replace("`0", ChatColor.BLACK.toString());
        str = str.replace("`1", ChatColor.DARK_GRAY.toString());
        str = str.replace("`2", ChatColor.GRAY.toString());
        str = str.replace("`w", ChatColor.WHITE.toString());
        str = str.replace("`k", ChatColor.MAGIC.toString());
        str = str.replace("`l", ChatColor.BOLD.toString());
        str = str.replace("`m", ChatColor.STRIKETHROUGH.toString());
        str = str.replace("`n", ChatColor.UNDERLINE.toString());
        str = str.replace("`o", ChatColor.ITALIC.toString());
        str = str.replace("`x", ChatColor.RESET.toString());
        str = str.replace("&c", ChatColor.RED.toString());
        str = str.replace("&4", ChatColor.DARK_RED.toString());
        str = str.replace("&e", ChatColor.YELLOW.toString());
        str = str.replace("&6", ChatColor.GOLD.toString());
        str = str.replace("&a", ChatColor.GREEN.toString());
        str = str.replace("&2", ChatColor.DARK_GREEN.toString());
        str = str.replace("&b", ChatColor.AQUA.toString());
        str = str.replace("&3", ChatColor.DARK_AQUA.toString());
        str = str.replace("&9", ChatColor.BLUE.toString());
        str = str.replace("&1", ChatColor.DARK_BLUE.toString());
        str = str.replace("&d", ChatColor.LIGHT_PURPLE.toString());
        str = str.replace("&5", ChatColor.DARK_PURPLE.toString());
        str = str.replace("&0", ChatColor.BLACK.toString());
        str = str.replace("&8", ChatColor.DARK_GRAY.toString());
        str = str.replace("&7", ChatColor.GRAY.toString());
        str = str.replace("&f", ChatColor.WHITE.toString());
        str = str.replace("&k", ChatColor.MAGIC.toString());
        str = str.replace("&l", ChatColor.BOLD.toString());
        str = str.replace("&m", ChatColor.STRIKETHROUGH.toString());
        str = str.replace("&n", ChatColor.UNDERLINE.toString());
        str = str.replace("&o", ChatColor.ITALIC.toString());
        str = str.replace("&x", ChatColor.RESET.toString());
        str = str.replace("&r", ChatColor.RESET.toString());
        return str;
    }

    public static String getOwnerName(@Nullable Object owner) {
        if (owner == null) {
            return "?";
        }
        if (owner instanceof Player) {
            return ((Player)owner).getName();
        }
        if (owner instanceof ConsoleCommandSender) {
            return "*CONSOLE*";
        }
        if (owner instanceof BlockCommandSender) {
            return ((BlockCommandSender)owner).getBlock().getLocation().toString();
        }
        return "?";
    }

    public static Function<String, ?> messageFunction(CommandSender sender) {
        return s -> {
            sender.sendMessage(s);
            return null;
        };
    }

    public static void pastebin(WorldGuardPlugin plugin, final CommandSender sender, String content, final String successMessage) {
        ListenableFuture future = new EngineHubPaste().paste(content);
        AsyncCommandHelper.wrap(future, plugin, sender).registerWithSupervisor("Submitting content to a pastebin service...").sendMessageAfterDelay("(Please wait... sending output to pastebin...)");
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<URL>(){

            public void onSuccess(URL url) {
                sender.sendMessage(ChatColor.YELLOW + String.format(successMessage, url));
            }

            public void onFailure(Throwable throwable) {
                log.log(Level.WARNING, "Failed to submit pastebin", throwable);
                sender.sendMessage(ChatColor.RED + "Failed to submit to a pastebin. Please see console for the error.");
            }
        });
    }
}

