/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.config.WorldConfiguration;

public final class SpongeUtil {
    private SpongeUtil() {
    }

    public static void clearSpongeWater(World world, int ox, int oy, int oz) {
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(world);
        for (int cx = -wcfg.spongeRadius; cx <= wcfg.spongeRadius; ++cx) {
            for (int cy = -wcfg.spongeRadius; cy <= wcfg.spongeRadius; ++cy) {
                for (int cz = -wcfg.spongeRadius; cz <= wcfg.spongeRadius; ++cz) {
                    BlockVector vector = new BlockVector(ox + cx, oy + cy, oz + cz);
                    if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                    try {
                        world.setBlock((Vector)vector, (BlockStateHolder)BlockTypes.AIR.getDefaultState());
                        continue;
                    }
                    catch (WorldEditException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void setBlockToWater(World world, int ox, int oy, int oz) throws WorldEditException {
        BlockVector vector = new BlockVector(ox, oy, oz);
        if (world.getBlock((Vector)vector).getBlockType() == BlockTypes.AIR) {
            world.setBlock((Vector)vector, (BlockStateHolder)BlockTypes.WATER.getDefaultState());
        }
    }

    public static void addSpongeWater(World world, int ox, int oy, int oz) {
        BlockVector vector;
        int cz;
        int cy;
        WorldConfiguration wcfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager().get(world);
        int cx = ox - wcfg.spongeRadius - 1;
        for (cy = oy - wcfg.spongeRadius - 1; cy <= oy + wcfg.spongeRadius + 1; ++cy) {
            for (cz = oz - wcfg.spongeRadius - 1; cz <= oz + wcfg.spongeRadius + 1; ++cz) {
                vector = new BlockVector(cx, cy, cz);
                if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                try {
                    SpongeUtil.setBlockToWater(world, cx + 1, cy, cz);
                    continue;
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        }
        cx = ox + wcfg.spongeRadius + 1;
        for (cy = oy - wcfg.spongeRadius - 1; cy <= oy + wcfg.spongeRadius + 1; ++cy) {
            for (cz = oz - wcfg.spongeRadius - 1; cz <= oz + wcfg.spongeRadius + 1; ++cz) {
                vector = new BlockVector(cx, cy, cz);
                if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                try {
                    SpongeUtil.setBlockToWater(world, cx - 1, cy, cz);
                    continue;
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        }
        cy = oy - wcfg.spongeRadius - 1;
        for (cx = ox - wcfg.spongeRadius - 1; cx <= ox + wcfg.spongeRadius + 1; ++cx) {
            for (cz = oz - wcfg.spongeRadius - 1; cz <= oz + wcfg.spongeRadius + 1; ++cz) {
                vector = new BlockVector(cx, cy, cz);
                if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                try {
                    SpongeUtil.setBlockToWater(world, cx, cy + 1, cz);
                    continue;
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        }
        cy = oy + wcfg.spongeRadius + 1;
        for (cx = ox - wcfg.spongeRadius - 1; cx <= ox + wcfg.spongeRadius + 1; ++cx) {
            for (cz = oz - wcfg.spongeRadius - 1; cz <= oz + wcfg.spongeRadius + 1; ++cz) {
                vector = new BlockVector(cx, cy, cz);
                if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                try {
                    SpongeUtil.setBlockToWater(world, cx, cy - 1, cz);
                    continue;
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        }
        cz = oz - wcfg.spongeRadius - 1;
        for (cx = ox - wcfg.spongeRadius - 1; cx <= ox + wcfg.spongeRadius + 1; ++cx) {
            for (cy = oy - wcfg.spongeRadius - 1; cy <= oy + wcfg.spongeRadius + 1; ++cy) {
                vector = new BlockVector(cx, cy, cz);
                if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                try {
                    SpongeUtil.setBlockToWater(world, cx, cy, cz + 1);
                    continue;
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        }
        cz = oz + wcfg.spongeRadius + 1;
        for (cx = ox - wcfg.spongeRadius - 1; cx <= ox + wcfg.spongeRadius + 1; ++cx) {
            for (cy = oy - wcfg.spongeRadius - 1; cy <= oy + wcfg.spongeRadius + 1; ++cy) {
                vector = new BlockVector(cx, cy, cz);
                if (world.getBlock((Vector)vector).getBlockType() != BlockTypes.WATER) continue;
                try {
                    SpongeUtil.setBlockToWater(world, cx, cy, cz - 1);
                    continue;
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

