/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends com.sk89q.worldedit.bukkit.BukkitPlayer
implements LocalPlayer {
    private final WorldGuardPlugin plugin;
    private final String name;
    private final boolean silenced;

    public BukkitPlayer(WorldGuardPlugin plugin, Player player) {
        this(plugin, player, false);
    }

    BukkitPlayer(WorldGuardPlugin plugin, Player player, boolean silenced) {
        super((WorldEditPlugin)Bukkit.getPluginManager().getPlugin("WorldEdit"), player);
        this.plugin = plugin;
        this.name = player.getName();
        this.silenced = silenced;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasGroup(String group) {
        return this.plugin.inGroup(this.getPlayer(), group);
    }

    public void kick(String msg) {
        if (!this.silenced) {
            this.getPlayer().kickPlayer(msg);
        }
    }

    public void ban(String msg) {
        if (!this.silenced) {
            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(this.getName(), null, null, null);
            this.getPlayer().kickPlayer(msg);
        }
    }

    public double getHealth() {
        return this.getPlayer().getHealth();
    }

    public void setHealth(double health) {
        this.getPlayer().setHealth(health);
    }

    public double getMaxHealth() {
        return this.getPlayer().getMaxHealth();
    }

    public double getFoodLevel() {
        return this.getPlayer().getFoodLevel();
    }

    public void setFoodLevel(double foodLevel) {
        this.getPlayer().setFoodLevel((int)foodLevel);
    }

    public double getSaturation() {
        return this.getPlayer().getSaturation();
    }

    public void setSaturation(double saturation) {
        this.getPlayer().setSaturation((float)saturation);
    }

    public WeatherType getPlayerWeather() {
        return null;
    }

    public void setPlayerWeather(WeatherType weather) {
        this.getPlayer().setPlayerWeather(weather == WeatherTypes.CLEAR ? org.bukkit.WeatherType.CLEAR : org.bukkit.WeatherType.DOWNFALL);
    }

    public void resetPlayerWeather() {
        this.getPlayer().resetPlayerWeather();
    }

    public boolean isPlayerTimeRelative() {
        return this.getPlayer().isPlayerTimeRelative();
    }

    public long getPlayerTimeOffset() {
        return this.getPlayer().getPlayerTimeOffset();
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getPlayer().setPlayerTime(time, relative);
    }

    public void resetPlayerTime() {
        this.getPlayer().resetPlayerTime();
    }

    public String[] getGroups() {
        return this.plugin.getGroups(this.getPlayer());
    }

    public void printRaw(String msg) {
        if (!this.silenced) {
            this.getPlayer().sendMessage(msg);
        }
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.getPlayer(), perm);
    }
}

