/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class InvincibilityListener
extends AbstractListener {
    public InvincibilityListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    private boolean isInvincible(LocalPlayer player) {
        return WorldGuard.getInstance().getPlatform().getSessionManager().get(player).isInvincible(player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity victim = event.getEntity();
        if (victim instanceof Player) {
            Player player = (Player)victim;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            BukkitWorldConfiguration worldConfig = (BukkitWorldConfiguration)WorldGuard.getInstance().getPlatform().getGlobalStateManager().get((World)localPlayer.getExtent());
            if (this.isInvincible(localPlayer)) {
                player.setFireTicks(0);
                event.setCancelled(true);
                if (event instanceof EntityDamageByEntityEvent) {
                    EntityDamageByEntityEvent byEntityEvent = (EntityDamageByEntityEvent)event;
                    Entity attacker = byEntityEvent.getDamager();
                    if (!(!worldConfig.regionInvinciblityRemovesMobs || !(attacker instanceof LivingEntity) || attacker instanceof Player || attacker instanceof Tameable && ((Tameable)attacker).isTamed())) {
                        attacker.remove();
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (this.isInvincible(localPlayer)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (event.getFoodLevel() < player.getFoodLevel() && this.isInvincible(localPlayer)) {
                event.setCancelled(true);
            }
        }
    }
}

