/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends LocalPlayer {
    private final WorldGuardPlugin plugin;
    private final Player player;
    private final com.sk89q.worldedit.bukkit.BukkitPlayer worldEditPlayer;
    private final String name;
    private final boolean silenced;

    public BukkitPlayer(WorldGuardPlugin plugin, Player player) {
        this(plugin, player, false);
    }

    BukkitPlayer(WorldGuardPlugin plugin, Player player, boolean silenced) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)player);
        this.plugin = plugin;
        this.player = player;
        this.name = player.getName();
        this.silenced = silenced;
        this.worldEditPlayer = new com.sk89q.worldedit.bukkit.BukkitPlayer((WorldEditPlugin)Bukkit.getPluginManager().getPlugin("WorldEdit"), player);
    }

    public String getName() {
        return this.name;
    }

    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    public boolean hasGroup(String group) {
        return this.plugin.inGroup(this.player, group);
    }

    public void kick(String msg) {
        if (!this.silenced) {
            this.player.kickPlayer(msg);
        }
    }

    public void ban(String msg) {
        if (!this.silenced) {
            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(this.player.getName(), null, null, null);
            this.player.kickPlayer(msg);
        }
    }

    public double getHealth() {
        return this.player.getHealth();
    }

    public void setHealth(double health) {
        this.player.setHealth(health);
    }

    public double getMaxHealth() {
        return this.player.getMaxHealth();
    }

    public double getFoodLevel() {
        return this.player.getFoodLevel();
    }

    public void setFoodLevel(double foodLevel) {
        this.player.setFoodLevel((int)foodLevel);
    }

    public double getSaturation() {
        return this.player.getSaturation();
    }

    public void setSaturation(double saturation) {
        this.player.setSaturation((float)saturation);
    }

    public WeatherType getPlayerWeather() {
        return null;
    }

    public void setPlayerWeather(WeatherType weather) {
        this.player.setPlayerWeather(weather == WeatherTypes.CLEAR ? org.bukkit.WeatherType.CLEAR : org.bukkit.WeatherType.DOWNFALL);
    }

    public void resetPlayerWeather() {
        this.player.resetPlayerWeather();
    }

    public boolean isPlayerTimeRelative() {
        return this.player.isPlayerTimeRelative();
    }

    public long getPlayerTimeOffset() {
        return this.player.getPlayerTimeOffset();
    }

    public void setPlayerTime(long time, boolean relative) {
        this.player.setPlayerTime(time, relative);
    }

    public void resetPlayerTime() {
        this.player.resetPlayerTime();
    }

    public String[] getGroups() {
        return this.plugin.getGroups(this.player);
    }

    public void printRaw(String msg) {
        if (!this.silenced) {
            this.player.sendMessage(msg);
        }
    }

    public void printDebug(String msg) {
        this.worldEditPlayer.printDebug(msg);
    }

    public void print(String msg) {
        this.worldEditPlayer.print(msg);
    }

    public void printError(String msg) {
        this.worldEditPlayer.printError(msg);
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }

    public Player getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return BukkitAdapter.adapt((org.bukkit.World)this.player.getWorld());
    }

    public BaseItemStack getItemInHand(HandSide handSide) {
        return this.worldEditPlayer.getItemInHand(handSide);
    }

    public void giveItem(BaseItemStack itemStack) {
        this.worldEditPlayer.giveItem(itemStack);
    }

    public BlockBag getInventoryBlockBag() {
        return this.worldEditPlayer.getInventoryBlockBag();
    }

    public void setPosition(Vector pos, float pitch, float yaw) {
        this.worldEditPlayer.setPosition(pos, pitch, yaw);
    }

    @Nullable
    public BaseEntity getState() {
        return this.worldEditPlayer.getState();
    }

    public com.sk89q.worldedit.util.Location getLocation() {
        Location loc = this.player.getLocation();
        return BukkitAdapter.adapt((Location)loc);
    }

    public SessionKey getSessionKey() {
        return this.worldEditPlayer.getSessionKey();
    }

    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return (T)this.worldEditPlayer.getFacet(cls);
    }
}

