/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.util.logging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.plugin.Plugin;

public class ClassSourceValidator {
    private static final Logger log = Logger.getLogger(ClassSourceValidator.class.getCanonicalName());
    private static final String separatorLine = Strings.repeat((String)"*", (int)46);
    private final Plugin plugin;
    @Nullable
    private final CodeSource expectedCodeSource;

    public ClassSourceValidator(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.plugin = plugin;
        this.expectedCodeSource = plugin.getClass().getProtectionDomain().getCodeSource();
    }

    public Map<Class<?>, CodeSource> findMismatches(List<Class<?>> classes) {
        Preconditions.checkNotNull(classes, (Object)"classes");
        HashMap mismatches = Maps.newHashMap();
        if (this.expectedCodeSource != null) {
            for (Class<?> testClass : classes) {
                CodeSource testSource = testClass.getProtectionDomain().getCodeSource();
                if (this.expectedCodeSource.equals(testSource)) continue;
                mismatches.put(testClass, testSource);
            }
        }
        return mismatches;
    }

    public void reportMismatches(List<Class<?>> classes) {
        if (Boolean.getBoolean("worldguard.disable.class.validation")) {
            return;
        }
        Map<Class<?>, CodeSource> mismatches = this.findMismatches(classes);
        if (!mismatches.isEmpty()) {
            StringBuilder builder = new StringBuilder("\n");
            builder.append(separatorLine).append("\n");
            builder.append("** /!\\    SEVERE WARNING    /!\\\n");
            builder.append("** \n");
            builder.append("** A plugin developer has copied and pasted a portion of \n");
            builder.append("** ").append(this.plugin.getName()).append(" into their own plugin, so rather than using\n");
            builder.append("** the version of ").append(this.plugin.getName()).append(" that you downloaded, you\n");
            builder.append("** will be using a broken mix of old ").append(this.plugin.getName()).append(" (that came\n");
            builder.append("** with the plugin) and your downloaded version. THIS MAY\n");
            builder.append("** SEVERELY BREAK ").append(this.plugin.getName().toUpperCase()).append(" AND ALL OF ITS FEATURES.\n");
            builder.append("**\n");
            builder.append("** This may have happened because the developer is using\n");
            builder.append("** the ").append(this.plugin.getName()).append(" API and thinks that including\n");
            builder.append("** ").append(this.plugin.getName()).append(" is necessary. However, it is not!\n");
            builder.append("**\n");
            builder.append("** Here are some files that have been overridden:\n");
            builder.append("** \n");
            for (Map.Entry<Class<?>, CodeSource> entry : mismatches.entrySet()) {
                CodeSource codeSource = entry.getValue();
                String url = codeSource != null ? codeSource.getLocation().toExternalForm() : "(unknown)";
                builder.append("** '").append(entry.getKey().getSimpleName()).append("' came from '").append(url).append("'\n");
            }
            builder.append("**\n");
            builder.append("** Please report this to the plugins' developers.\n");
            builder.append(separatorLine).append("\n");
            log.log(Level.SEVERE, builder.toString());
        }
    }
}

