/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.blacklist.event.BlacklistEvent;
import com.sk89q.worldguard.blacklist.event.BlockBreakBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.BlockDispenseBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.BlockInteractBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.BlockPlaceBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.ItemAcquireBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.ItemDestroyWithBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.ItemDropBlacklistEvent;
import com.sk89q.worldguard.blacklist.event.ItemUseBlacklistEvent;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.event.entity.DestroyEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.SpawnEntityEvent;
import com.sk89q.worldguard.bukkit.event.inventory.UseItemEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.config.WorldConfiguration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BlacklistListener
extends AbstractListener {
    public BlacklistListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreakBlock(BreakBlockEvent event) {
        Player player = event.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        WorldConfiguration wcfg = this.getWorldConfig(localPlayer);
        if (wcfg.getBlacklist() == null) {
            return;
        }
        event.filter(target -> {
            if (!wcfg.getBlacklist().check((BlacklistEvent)new BlockBreakBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)target), BukkitUtil.createTarget(target.getBlock(), event.getEffectiveMaterial())), false, false)) {
                return false;
            }
            return wcfg.getBlacklist().check((BlacklistEvent)new ItemDestroyWithBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)target), BukkitUtil.createTarget(player.getItemInHand())), false, false);
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlaceBlock(PlaceBlockEvent event) {
        Player player = event.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        WorldConfiguration wcfg = this.getWorldConfig(localPlayer);
        if (wcfg.getBlacklist() == null) {
            return;
        }
        event.filter(target -> wcfg.getBlacklist().check((BlacklistEvent)new BlockPlaceBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)target), BukkitUtil.createTarget(target.getBlock(), event.getEffectiveMaterial())), false, false));
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseBlock(UseBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        Player player = event.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        WorldConfiguration wcfg = this.getWorldConfig(localPlayer);
        if (wcfg.getBlacklist() == null) {
            return;
        }
        event.filter(target -> wcfg.getBlacklist().check((BlacklistEvent)new BlockInteractBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)target), BukkitUtil.createTarget(target.getBlock(), event.getEffectiveMaterial())), false, false));
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpawnEntity(SpawnEntityEvent event) {
        Player player = event.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        WorldConfiguration wcfg = this.getWorldConfig(localPlayer);
        if (wcfg.getBlacklist() == null) {
            return;
        }
        Material material = Materials.getRelatedMaterial(event.getEffectiveType());
        if (material != null && !wcfg.getBlacklist().check((BlacklistEvent)new ItemUseBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)event.getTarget()), BukkitUtil.createTarget(material)), false, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDestroyEntity(DestroyEntityEvent event) {
        Material material;
        Player player = event.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        Entity target = event.getEntity();
        WorldConfiguration wcfg = this.getWorldConfig(localPlayer);
        if (wcfg.getBlacklist() == null) {
            return;
        }
        if (target instanceof Item) {
            Item item = (Item)target;
            if (!wcfg.getBlacklist().check((BlacklistEvent)new ItemAcquireBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)target.getLocation()), BukkitUtil.createTarget(item.getItemStack())), false, true)) {
                event.setCancelled(true);
                return;
            }
        }
        if ((material = Materials.getRelatedMaterial(target.getType())) != null && !wcfg.getBlacklist().check((BlacklistEvent)new BlockBreakBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)event.getTarget()), BukkitUtil.createTarget(material)), false, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseItem(UseItemEvent event) {
        Player player = event.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
        ItemStack target = event.getItemStack();
        WorldConfiguration wcfg = this.getWorldConfig(localPlayer);
        if (wcfg.getBlacklist() == null) {
            return;
        }
        if (!wcfg.getBlacklist().check((BlacklistEvent)new ItemUseBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)player.getLocation()), BukkitUtil.createTarget(target)), false, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((World)event.getPlayer().getWorld()));
        if (wcfg.getBlacklist() != null) {
            Item ci = event.getItemDrop();
            if (!wcfg.getBlacklist().check((BlacklistEvent)new ItemDropBlacklistEvent(this.getPlugin().wrapPlayer(event.getPlayer()), BukkitAdapter.asBlockVector((Location)ci.getLocation()), BukkitUtil.createTarget(ci.getItemStack())), false, false)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((World)event.getBlock().getWorld()));
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check((BlacklistEvent)new BlockDispenseBlacklistEvent(null, BukkitAdapter.asBlockVector((Location)event.getBlock().getLocation()), BukkitUtil.createTarget(event.getItem())), false, false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity entity = event.getWhoClicked();
        Inventory inventory = event.getInventory();
        ItemStack item = event.getCurrentItem();
        if (item != null && inventory != null && inventory.getHolder() != null && entity instanceof Player) {
            Player player = (Player)entity;
            ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((World)entity.getWorld()));
            LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
            if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check((BlacklistEvent)new ItemAcquireBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)entity.getLocation()), BukkitUtil.createTarget(item)), false, false)) {
                event.setCancelled(true);
                if (inventory.getHolder().equals(player)) {
                    event.setCurrentItem(null);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryCreative(InventoryCreativeEvent event) {
        HumanEntity entity = event.getWhoClicked();
        ItemStack item = event.getCursor();
        if (item != null && entity instanceof Player) {
            Player player = (Player)entity;
            ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((World)entity.getWorld()));
            LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
            if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check((BlacklistEvent)new ItemAcquireBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)entity.getLocation()), BukkitUtil.createTarget(item)), false, false)) {
                event.setCancelled(true);
                event.setCursor(null);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack item = inventory.getItem(event.getNewSlot());
        if (item != null) {
            ConfigurationManager cfg = WorldGuard.getInstance().getPlatform().getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(BukkitAdapter.adapt((World)player.getWorld()));
            LocalPlayer localPlayer = this.getPlugin().wrapPlayer(player);
            if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check((BlacklistEvent)new ItemAcquireBlacklistEvent(localPlayer, BukkitAdapter.asBlockVector((Location)player.getLocation()), BukkitUtil.createTarget(item)), false, false)) {
                inventory.setItem(event.getNewSlot(), null);
            }
        }
    }
}

